#!/bin/bash
#
# dm-config-pam.sh
#
#    Configure the pam config file of current Display Manager.
#
#    Copyright (c) 2005-2006 Userful Corporation
#    
#    Jason Kim <jason@userful.com>
#
# 	- Initial configuration for PAM and default.session
#
# $1: CURRENTDM
logfile="/var/log/userful-start.log"
ProgramName=`basename $0`

PATH=$PATH:/usr/X11R6/bin/

if [ ! -f /etc/sysconfig/xtype ]; then
	echo "`date +"%b %d %T"` $ProgramName: Unable to find /etc/sysconfig/xtype" >> $logfile
	exit 1
fi
source /etc/sysconfig/xtype

if [ -f /usr/share/gnome/default.session ]; then # FC4
	default_session="/usr/share/gnome/default.session"
elif [ -f /opt/gnome/share/gnome/default.session ]; then #SLED 10
	default_session="/opt/gnome/share/gnome/default.session"
fi

# If the XTYPE is SINGLE, then restore files and exit.
if [ -z "$XTYPE" -o "$XTYPE" == "SINGLE" ]; then
	if [ -f $default_session.multi-save ]; then # restore $default_session
		mv -f $default_session.multi-save $default_session
	fi

	if [ -f /etc/pam.d/gdm.multi-save ]; then #restore /etc/pam.d/gdm for normal X
		mv -f /etc/pam.d/gdm.multi-save  /etc/pam.d/gdm
	fi

    # remove multistation.desktop (For KDE)
    if [ -f /usr/share/autostart/multistation.desktop ]; then
        rm -f /usr/share/autostart/multistation.desktop
    fi

	exit 0
fi

#
# add multistation-devices-session-startup.sh to default.session 
if [ -n "$default_session" ]; then

	if [ ! -f $default_session.multi-save ]; then
		cp -f $default_session $default_session.multi-save
	fi

	# check if multistation-devices-session-startup.sh was added already.
   	RET=`grep -c multistation-devices-session-startup.sh $default_session`

	if [ "$RET" -eq "0" ]; then
		# multistation-devices-session-startup.sh hasn't been added to default.session yet.
		echo "`date +"%b %d %T"` $ProgramName: Add multistation-devices-session-startup.sh into $default_session" >> $logfile

   		session_num_clients_line=`grep num_clients= $default_session`
   		client_num=`echo $session_num_clients_line | awk -F= '{print $2}'`
   		client_num_new=`expr $client_num + 1`

		# add multistation-devices-session-startup.sh
   		sed -i -e "s/$session_num_clients_line/num_clients=$client_num_new/" $default_session
		echo -e "$client_num,RestartStyleHint=3" >> $default_session
		echo -e "$client_num,Priority=10" >> $default_session
		echo -e "$client_num,RestartCommand=/opt/userful/bin/multistation-devices-session-startup.sh" >> $default_session
	fi
fi

# add multistation.desktop as a Autostart entry for KDE destkop
if [ -d /usr/share/autostart ];then
    cp -f /etc/userful/setup/multistation.desktop /usr/share/autostart/
fi

# Update Display Manager's config files
if [ "$1" == "gdm" ]; then		### GDM ###
	chown gdm /tmp/.X11-unix/X*
	chown gdm /tmp/.X11-unix/.X*

	if [ -e /etc/pam.d/gdm ]; then
		if [ ! -f /etc/pam.d/gdm.multi-save ]; then
			cp -f /etc/pam.d/gdm  /etc/pam.d/gdm.multi-save
		fi

		grep pam_console.so /etc/pam.d/gdm | grep allow_nonroot_tty > /dev/null
		if [ $? != 0 ]; then
			sed -i -e "s/pam_console\.so/pam_console\.so allow_nonroot_tty /g" /etc/pam.d/gdm
		fi

		if [ "`grep pam_external_exec.so /etc/pam.d/gdm`" == "" ]; then
			# add pam_external_exec 
			echo "`date +"%b %d %T"` $ProgramName: Add pam_external_exec module into /etc/pam.d/gdm" >> $logfile
			echo "session  optional  pam_external_exec.so /opt/userful/bin/multistation-devices-update-ownership.sh" >> /etc/pam.d/gdm
		fi
			
		cat /etc/pam.d/gdm | grep pam_xconsole > /dev/null
		if [ $? != 0 ]; then
			echo "session    required	pam_xconsole.so default_user=gdm" >> /etc/pam.d/gdm 
    	fi
	fi
else							### KDM, XDM ###
    DM_PATH=
	if [ -e /etc/pam.d/kde ]; then
        DM_PATH="/etc/pam.d/kde"
	elif [ -e /etc/pam.d/kde3 ]; then # for Mandrake
        DM_PATH="/etc/pam.d/kde3"
	elif [ -e /etc/pam.d/kdm ]; then
        DM_PATH="/etc/pam.d/kdm"
	elif [ -e /etc/pam.d/xdm ]; then
        DM_PATH="/etc/pam.d/xdm"
    else
	    echo "`date +"%b %d %T"` $ProgramName: PAM module for the Display Manager is not available." >> $logfile
    fi

    if [ "$DM_PATH" != "" ]; then
        if ! grep "pam_external_exec.so" $DM_PATH > /dev/null; then
			echo "session    optional  pam_external_exec.so /opt/userful/bin/multistation-devices-update-ownership.sh" >> $DM_PATH
        fi

        if ! grep "pam_xconsole.so" $DM_PATH > /dev/null; then
			echo "session    required	pam_xconsole.so" >> $DM_PATH
        fi
    fi
fi

# only root can update xhost access control
chmod go-x `which xhost`

# update xhost access control
# only allow LOCAL connection
DISPLAY=:0 xhost > /tmp/xhost.tmp

while read XHOSTENTRY; do
	case "${XHOSTENTRY%:*}" in
		"INET"|"INET6"|"DNET"|"NIS"|"KRB":"SI" )
			# block connections
			DISPLAY=:0 xhost -$XHOSTENTRY
			;;
		* )
			# allow connection from LOCAL
			:
			;;
	esac
	#if echo $XHOSTENTRY | grep "^INET:"
	#echo $XHOSTENTRY
done < /tmp/xhost.tmp

rm -f /tmp/xhost.tmp

# add hostname from /etc/userful/xhost-list to allow connection
if [ -e /etc/userful/xhost-list ]; then
	while read XHOSTLIST; do
		if [ ${#XHOSTLIST} -gt 0 -a "${XHOSTLIST:0:1}" != "#" ]; then
			DISPLAY=:0 xhost +$XHOSTLIST
		fi
	done < /etc/userful/xhost-list
fi

