#!/bin/bash
#
#   remote-login.sh
#
#   Copyright (c) 2002-2007 Userful Corporation. All rights reserved.
#   http://www.userful.com
# This script controls station start-up.
# If the station is configured with input-device, it starts remote-login-server.
# If the station is not configured with input-device, it starts userful-usbinput-config.
# Called from: remote-dm.sh

logfile="/var/log/userful-start.log"
ProgramName=`basename $0`

# find display number to work on
for ARG in $@
do
	if [ "${ARG:0:1}" == ":" ]; then
		DIS=${ARG:1}
	fi
done

if [ -z "$DIS" ]; then
	echo "`date +"%b %d %T"` [$ProgramName](error): Invalid DISPLAY number." >> $logfile
	sleep 999d
	exit 1
fi

if [ $DIS -lt 10 ]; then
	DISPLAY_STR="Srn#=0$DIS"
else
	DISPLAY_STR="Srn#=$DIS"
fi

LOGIN_LOG="/var/log/remote-login-$DIS.log"

# arguments for the remote-login-server
DEBUG=0
VERBOSE=0
if [ -f /etc/userful/dm.conf ]; then
    # Get the configuration from dm.conf
    sed -e "s/^\[/#\[/g" /etc/userful/dm.conf > /tmp/dm.conf.tmp
	source /tmp/dm.conf.tmp

	if [ -z "$ADMIN_TERMINAL" ]; then
		ADMIN_TERMINAL=false
	fi
	if [ -z "$XDMHOST" ]; then
		XDMHOST=localhost
	fi
	if [ -z "$XDMPORT" ]; then # 177 is the default port for XDMCP protocol.
		XDMPORT=177
	fi
else
	XDMHOST=localhost
	XDMPORT=177
fi

if [ ! -f /etc/usbinput ] ; then
	/opt/userful/bin/make-config-file -r
fi
KBD_STR=`grep "kbd" /etc/usbinput | grep "$DISPLAY_STR"`

if [ -z "$KBD_STR" ]; then
	echo "`date +"%b %d %T"` [$ProgramName]: Starting Press F-Key program on DISPLAY=:$DIS" >> $logfile
	exec /opt/userful/bin/userful-usbinput-config -display :$DIS >> $LOGIN_LOG 2>&1

else
	if [ "${KBD_STR:1:1}" == "1" ]; then 

        # If current display is part of UNMANAGED_DISPLAY, then do nothing.
		if [ -n "$UNMANAGED_DISPLAY" ]; then
			for U in $UNMANAGED_DISPLAY; do
				if [ "$U" == "$DIS" ]; then
					echo "`date +"%b %d %T"` [$ProgramName]: Unmanaged display :$DIS" >> $logfile
					exec sleep 999d
				fi
			done
		fi

		if [ "$DIS" == "0" -a "$ADMIN_TERMINAL" == "true" ]; then
			# run xterm on first station for admin mode
		    echo "`date +"%b %d %T"` [$ProgramName]: Start ADMIN Terminal on DISPLAY=:$DIS" >> $logfile
			exec xterm -display :$DIS -geometry 110x40-0-0
		else
		    echo "`date +"%b %d %T"` [$ProgramName]: Start remote-login-server on DISPLAY=:$DIS" >> $logfile
			exec /opt/userful/bin/remote-login-server -display :$DIS -debug $DEBUG -verbose $VERBOSE $XDMHOST $XDMPORT >> $LOGIN_LOG 2>&1
		fi
	else
	    echo "`date +"%b %d %T"` [$ProgramName]: Starting Press F-Key program on DISPLAY=:$DIS" >> $logfile
		exec /opt/userful/bin/userful-usbinput-config -display :$DIS >> $LOGIN_LOG 2>&1
	fi
fi
