#!/bin/bash
#
# userful-usbhub-hotplug.sh
#
# Copyright (c) 2005-2006 by Userful Corporation
#
#  This script is called from udev rule in 99-userful-hotplug.rules.

logfile="/var/log/userful-start.log"


#DEBUG
#env >> $logfile

# Exit if the driver is not hub
if [[ "$PHYSDEVDRIVER" != "hub" ]] && [[ "$DRIVERS" != "hub" ]];  then
    exit 1
fi

# Exit if X is not running or X is starting.
if [[ ! -e /var/run/x.pid ]]; then
	exit 1
elif ! kill -0 `cat /var/run/x.pid` > /dev/null 2>&1; then
	exit 1
fi
if [[ -e /tmp/X-start ]]; then
	exit 1
fi

echo "`date +"%b %d %T"` USB hub added. $PHYSDEVPATH" >>  $logfile
touch /tmp/usbhub-hotplug
