#!/bin/bash

# Copyright (c) 2002-2005 Userful Corporation. All rights reserved.
# http://www.userful.com/

# launch-preferred-browser.sh

ARGS="$*"

echo "LPB: args: $ARGS"

# Use gnome's default browser
G=`which gconftool-2`
if [ -n "$G" ] && [ -x $G ] ; then 
    P=`$G -g /desktop/gnome/applications/browser/exec`
    if [ -n "$P" ] ; then
        if [ -x $P ] ; then 
            #echo "Using gconf key value"
            exec $P "$ARGS"
        else
            P=`which $P`
            if [ -n "$P" ] && [ -x $P ] ; then 
                #echo "Using which'd gconf key value"
                exec $P "$ARGS"
            fi
        fi
    fi
fi

# We didn't find a default gnome browser, check all known browsers

# preferred:
BROWSER_LIST="firefox epiphany galeon"

# bottom of the barrel:
BROWSER_LIST="$BROWSER_LIST mozilla dillo netscape opera konqueror"

for B in $BROWSER_LIST ; do
    P=`which $B`
    if [ -n "$P" ] && [ -x $P ] ; then 
        exec $P "$ARGS"
    fi
done

exit 1
