/*
 * Decompiled with CFR 0.152.
 */
package ru.novosoft.uml.undo;

import java.util.ArrayList;
import java.util.TooManyListenersException;
import ru.novosoft.uml.MFactoryImpl;
import ru.novosoft.uml.undo.MCheckPoint;
import ru.novosoft.uml.undo.MUndoManager;
import ru.novosoft.uml.undo.MUndoableAction;

public class MCheckPointUndoManager {
    static final MUndoManagerProxy proxy = new MUndoManagerProxy();
    public static final int UNDO_POLICY_DISABLED = 0;
    public static final int UNDO_POLICY_ENABLED = 1;
    private static final int UNDO_POLICY_UNDOING = 2;
    private static final int UNDO_POLICY_REDOING = 3;
    static int undo_policy = 0;
    static int currentCheckPointPosition;
    static boolean addingUndo;
    static ArrayList undoStack;

    public static void setUndoPolicy(int policy) {
        if (undo_policy == 0 && policy == 1) {
            try {
                MFactoryImpl.addUndoManager(proxy);
            }
            catch (TooManyListenersException ex) {
                throw new IllegalStateException("undo manager is already registered with factory");
            }
        }
        if (undo_policy == 1 && policy == 0) {
            MCheckPointUndoManager.forget(MCheckPointUndoManager.getCheckPoint());
            MFactoryImpl.removeUndoManager(proxy);
        }
        undo_policy = policy;
    }

    public static int getUndoPolicy() {
        return undo_policy;
    }

    public static MCheckPoint getCheckPoint() {
        MCheckPoint rc;
        addingUndo = false;
        if (undo_policy == 0) {
            throw new IllegalStateException("undo support is disabled.");
        }
        if (currentCheckPointPosition == undoStack.size() - 1) {
            MCheckPoint mCheckPoint = (MCheckPoint)undoStack.get(currentCheckPointPosition);
        } else {
            currentCheckPointPosition = undoStack.size();
            rc = new MCheckPoint(currentCheckPointPosition);
            undoStack.add(rc);
        }
        return rc;
    }

    public static void undo(MCheckPoint c) {
        if (undo_policy == 0) {
            throw new IllegalStateException("undo support is disabled.");
        }
        addingUndo = false;
        MCheckPointUndoManager.setUndoPolicy(2);
        if (!c.canBeUndone()) {
            throw new IllegalArgumentException();
        }
        int i = currentCheckPointPosition;
        while (i > c.stackPosition) {
            Object o = undoStack.get(i);
            if (o instanceof MUndoableAction) {
                MUndoableAction u = (MUndoableAction)o;
                u.undo();
            }
            --i;
        }
        currentCheckPointPosition = c.stackPosition;
        MCheckPointUndoManager.setUndoPolicy(1);
    }

    public static void redo(MCheckPoint c) {
        addingUndo = false;
        if (undo_policy == 0) {
            throw new IllegalStateException("undo support is disabled.");
        }
        MCheckPointUndoManager.setUndoPolicy(3);
        if (!c.canBeRedone()) {
            throw new IllegalArgumentException();
        }
        int i = currentCheckPointPosition + 1;
        while (i < c.stackPosition) {
            Object o = undoStack.get(i);
            if (o instanceof MUndoableAction) {
                MUndoableAction u = (MUndoableAction)o;
                u.redo();
            }
            ++i;
        }
        currentCheckPointPosition = c.stackPosition;
        MCheckPointUndoManager.setUndoPolicy(1);
    }

    public static void forget(MCheckPoint c) {
        if (undo_policy == 0) {
            throw new IllegalStateException("undo support is disabled.");
        }
        int i = currentCheckPointPosition - 1;
        while (i >= 0) {
            Object o = undoStack.get(i);
            if (o instanceof MCheckPoint) {
                MCheckPoint ic = (MCheckPoint)o;
                ic.valid = false;
            }
            --i;
        }
        i = currentCheckPointPosition - 1;
        while (i >= 0) {
            undoStack.remove(0);
            --i;
        }
        currentCheckPointPosition = c.stackPosition;
    }

    static void enlistUndo(MUndoableAction u) {
        if (!addingUndo && currentCheckPointPosition < undoStack.size() - 1) {
            while (currentCheckPointPosition != undoStack.size() - 1) {
                undoStack.remove(currentCheckPointPosition + 1);
            }
        }
        undoStack.add(u);
        addingUndo = true;
    }

    static {
        undoStack = new ArrayList(1024);
        currentCheckPointPosition = 0;
        addingUndo = false;
        undoStack.add(new MCheckPoint(0));
    }

    static class MUndoManagerProxy
    implements MUndoManager {
        public void enlistUndo(MUndoableAction a) {
            if (undo_policy == 1) {
                MCheckPointUndoManager.enlistUndo(a);
            }
        }

        MUndoManagerProxy() {
        }
    }
}

