/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.datatype;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.xerces.validators.datatype.AbstractDatatypeValidator;
import org.apache.xerces.validators.datatype.AnySimpleType;
import org.apache.xerces.validators.datatype.AnyURIDatatypeValidator;
import org.apache.xerces.validators.datatype.Base64BinaryDatatypeValidator;
import org.apache.xerces.validators.datatype.BooleanDatatypeValidator;
import org.apache.xerces.validators.datatype.DatatypeValidator;
import org.apache.xerces.validators.datatype.DatatypeValidatorFactory;
import org.apache.xerces.validators.datatype.DateDatatypeValidator;
import org.apache.xerces.validators.datatype.DateTimeDatatypeValidator;
import org.apache.xerces.validators.datatype.DayDatatypeValidator;
import org.apache.xerces.validators.datatype.DecimalDatatypeValidator;
import org.apache.xerces.validators.datatype.DoubleDatatypeValidator;
import org.apache.xerces.validators.datatype.DurationDatatypeValidator;
import org.apache.xerces.validators.datatype.ENTITYDatatypeValidator;
import org.apache.xerces.validators.datatype.FloatDatatypeValidator;
import org.apache.xerces.validators.datatype.HexBinaryDatatypeValidator;
import org.apache.xerces.validators.datatype.IDDatatypeValidator;
import org.apache.xerces.validators.datatype.IDREFDatatypeValidator;
import org.apache.xerces.validators.datatype.InvalidDatatypeFacetException;
import org.apache.xerces.validators.datatype.ListDatatypeValidator;
import org.apache.xerces.validators.datatype.MonthDatatypeValidator;
import org.apache.xerces.validators.datatype.MonthDayDatatypeValidator;
import org.apache.xerces.validators.datatype.NOTATIONDatatypeValidator;
import org.apache.xerces.validators.datatype.QNameDatatypeValidator;
import org.apache.xerces.validators.datatype.StringDatatypeValidator;
import org.apache.xerces.validators.datatype.TimeDatatypeValidator;
import org.apache.xerces.validators.datatype.UnionDatatypeValidator;
import org.apache.xerces.validators.datatype.YearDatatypeValidator;
import org.apache.xerces.validators.datatype.YearMonthDatatypeValidator;

public class DatatypeValidatorFactoryImpl
implements DatatypeValidatorFactory {
    private static final boolean fDebug = false;
    private Hashtable fRegistry = new Hashtable(30);
    private Hashtable fDTDDatatypeRegistry;
    private Hashtable fSchemaDatatypeRegistry = new Hashtable(40);
    private byte fRegistryExpanded = 0;
    private byte fSchemaValidation = 0;
    static /* synthetic */ Class class$org$apache$xerces$validators$datatype$DatatypeValidator;
    static /* synthetic */ Class class$java$util$Hashtable;

    public DatatypeValidatorFactoryImpl() {
        this.fDTDDatatypeRegistry = new Hashtable(10);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private DatatypeValidator createDTDDatatypeValidator(String string, DatatypeValidator datatypeValidator, Hashtable hashtable, boolean bl) throws InvalidDatatypeFacetException {
        DatatypeValidator datatypeValidator2 = this.createSchemaValidator(string, datatypeValidator, hashtable, bl);
        this.registerDTDValidator(string, datatypeValidator2);
        return datatypeValidator2;
    }

    public DatatypeValidator createDatatypeValidator(String string, Vector vector) {
        UnionDatatypeValidator unionDatatypeValidator = null;
        if (vector != null) {
            unionDatatypeValidator = new UnionDatatypeValidator(vector);
        }
        if (unionDatatypeValidator != null) {
            this.registerUserDefinedValidator(string, unionDatatypeValidator);
        }
        return unionDatatypeValidator;
    }

    public DatatypeValidator createDatatypeValidator(String string, DatatypeValidator datatypeValidator, Hashtable hashtable, boolean bl) throws InvalidDatatypeFacetException {
        if (datatypeValidator == null) {
            return null;
        }
        DatatypeValidator datatypeValidator2 = this.createSchemaValidator(string, datatypeValidator, hashtable, bl);
        this.registerUserDefinedValidator(string, datatypeValidator2);
        return datatypeValidator2;
    }

    private static Object createDatatypeValidator(Constructor constructor, Object[] objectArray) throws InvalidDatatypeFacetException {
        Object var2_2 = null;
        try {
            var2_2 = constructor.newInstance(objectArray);
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new InvalidDatatypeFacetException(invocationTargetException.getTargetException().getMessage());
        }
        return var2_2;
    }

    private DatatypeValidator createSchemaDatatypeValidator(String string, DatatypeValidator datatypeValidator, Hashtable hashtable, boolean bl) throws InvalidDatatypeFacetException {
        DatatypeValidator datatypeValidator2 = this.createSchemaValidator(string, datatypeValidator, hashtable, bl);
        this.registerSchemaValidator(string, datatypeValidator2);
        return datatypeValidator2;
    }

    private DatatypeValidator createSchemaValidator(String string, DatatypeValidator datatypeValidator, Hashtable hashtable, boolean bl) throws InvalidDatatypeFacetException {
        DatatypeValidator datatypeValidator2 = null;
        if (bl) {
            datatypeValidator2 = new ListDatatypeValidator(datatypeValidator, hashtable, bl);
        } else {
            try {
                String string2 = (String)hashtable.get("whiteSpace");
                if (string2 != null && !(datatypeValidator instanceof StringDatatypeValidator)) {
                    if (!string2.equals("collapse")) {
                        throw new InvalidDatatypeFacetException("whiteSpace value '" + string2 + "' for this type must be 'collapse'.");
                    }
                    hashtable.remove("whiteSpace");
                }
                Class<?> clazz = datatypeValidator.getClass();
                Class[] classArray = new Class[]{class$org$apache$xerces$validators$datatype$DatatypeValidator != null ? class$org$apache$xerces$validators$datatype$DatatypeValidator : (class$org$apache$xerces$validators$datatype$DatatypeValidator = DatatypeValidatorFactoryImpl.class$("org.apache.xerces.validators.datatype.DatatypeValidator")), class$java$util$Hashtable != null ? class$java$util$Hashtable : (class$java$util$Hashtable = DatatypeValidatorFactoryImpl.class$("java.util.Hashtable")), Boolean.TYPE};
                Object[] objectArray = new Object[]{datatypeValidator, hashtable, Boolean.FALSE};
                Constructor<?> constructor = clazz.getConstructor(classArray);
                datatypeValidator2 = (DatatypeValidator)DatatypeValidatorFactoryImpl.createDatatypeValidator(constructor, objectArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                noSuchMethodException.printStackTrace();
            }
        }
        return datatypeValidator2;
    }

    public void expandRegistryToFullSchemaSet() {
        block3: {
            this.fSchemaValidation = 1;
            if (this.fRegistryExpanded == 2) break block3;
            try {
                this.fSchemaDatatypeRegistry.put("anySimpleType", new AnySimpleType());
                this.fSchemaDatatypeRegistry.put("boolean", new BooleanDatatypeValidator());
                this.fSchemaDatatypeRegistry.put("float", new FloatDatatypeValidator());
                this.fSchemaDatatypeRegistry.put("double", new DoubleDatatypeValidator());
                this.fSchemaDatatypeRegistry.put("decimal", new DecimalDatatypeValidator());
                this.fSchemaDatatypeRegistry.put("hexBinary", new HexBinaryDatatypeValidator());
                this.fSchemaDatatypeRegistry.put("base64Binary", new Base64BinaryDatatypeValidator());
                this.fSchemaDatatypeRegistry.put("anyURI", new AnyURIDatatypeValidator());
                this.fSchemaDatatypeRegistry.put("QName", new QNameDatatypeValidator());
                this.fSchemaDatatypeRegistry.put("duration", new DurationDatatypeValidator());
                this.fSchemaDatatypeRegistry.put("gDay", new DayDatatypeValidator());
                this.fSchemaDatatypeRegistry.put("time", new TimeDatatypeValidator());
                this.fSchemaDatatypeRegistry.put("dateTime", new DateTimeDatatypeValidator());
                this.fSchemaDatatypeRegistry.put("date", new DateDatatypeValidator());
                this.fSchemaDatatypeRegistry.put("gMonthDay", new MonthDayDatatypeValidator());
                this.fSchemaDatatypeRegistry.put("gYearMonth", new YearMonthDatatypeValidator());
                this.fSchemaDatatypeRegistry.put("gYear", new YearDatatypeValidator());
                this.fSchemaDatatypeRegistry.put("gMonth", new MonthDatatypeValidator());
                if (this.fRegistryExpanded == 0) {
                    this.initializeDTDRegistry();
                }
                Hashtable<String, String> hashtable = new Hashtable<String, String>(2);
                hashtable.put("whiteSpace", "replace");
                this.createSchemaDatatypeValidator("normalizedString", this.getDatatypeValidator("string"), hashtable, false);
                hashtable.clear();
                hashtable.put("whiteSpace", "collapse");
                this.createSchemaDatatypeValidator("token", this.getDatatypeValidator("string"), hashtable, false);
                hashtable.clear();
                hashtable.put("whiteSpace", "collapse");
                hashtable.put("pattern", "([a-zA-Z]{2}|[iI]-[a-zA-Z]+|[xX]-[a-zA-Z]+)(-[a-zA-Z]+)*");
                this.createSchemaDatatypeValidator("language", this.getDatatypeValidator("string"), hashtable, false);
                hashtable.clear();
                hashtable.put("whiteSpace", "collapse");
                hashtable.put("specialToken", "Name");
                this.createSchemaDatatypeValidator("Name", this.getDatatypeValidator("string"), hashtable, false);
                hashtable.clear();
                hashtable.put("whiteSpace", "collapse");
                hashtable.put("specialToken", "NCName");
                this.createSchemaDatatypeValidator("NCName", this.getDatatypeValidator("string"), hashtable, false);
                hashtable.clear();
                hashtable.put("fractionDigits", "0");
                this.createSchemaDatatypeValidator("integer", this.getDatatypeValidator("decimal"), hashtable, false);
                hashtable.clear();
                hashtable.put("maxInclusive", "0");
                this.createSchemaDatatypeValidator("nonPositiveInteger", this.getDatatypeValidator("integer"), hashtable, false);
                hashtable.clear();
                hashtable.put("maxInclusive", "-1");
                this.createSchemaDatatypeValidator("negativeInteger", this.getDatatypeValidator("nonPositiveInteger"), hashtable, false);
                hashtable.clear();
                hashtable.put("maxInclusive", "9223372036854775807");
                hashtable.put("minInclusive", "-9223372036854775808");
                this.createSchemaDatatypeValidator("long", this.getDatatypeValidator("integer"), hashtable, false);
                hashtable.clear();
                hashtable.put("maxInclusive", "2147483647");
                hashtable.put("minInclusive", "-2147483648");
                this.createSchemaDatatypeValidator("int", this.getDatatypeValidator("long"), hashtable, false);
                hashtable.clear();
                hashtable.put("maxInclusive", "32767");
                hashtable.put("minInclusive", "-32768");
                this.createSchemaDatatypeValidator("short", this.getDatatypeValidator("int"), hashtable, false);
                hashtable.clear();
                hashtable.put("maxInclusive", "127");
                hashtable.put("minInclusive", "-128");
                this.createSchemaDatatypeValidator("byte", this.getDatatypeValidator("short"), hashtable, false);
                hashtable.clear();
                hashtable.put("minInclusive", "0");
                this.createSchemaDatatypeValidator("nonNegativeInteger", this.getDatatypeValidator("integer"), hashtable, false);
                hashtable.clear();
                hashtable.put("maxInclusive", "18446744073709551615");
                this.createSchemaDatatypeValidator("unsignedLong", this.getDatatypeValidator("nonNegativeInteger"), hashtable, false);
                hashtable.clear();
                hashtable.put("maxInclusive", "4294967295");
                this.createSchemaDatatypeValidator("unsignedInt", this.getDatatypeValidator("unsignedLong"), hashtable, false);
                hashtable.clear();
                hashtable.put("maxInclusive", "65535");
                this.createSchemaDatatypeValidator("unsignedShort", this.getDatatypeValidator("unsignedInt"), hashtable, false);
                hashtable.clear();
                hashtable.put("maxInclusive", "255");
                this.createSchemaDatatypeValidator("unsignedByte", this.getDatatypeValidator("unsignedShort"), hashtable, false);
                hashtable.clear();
                hashtable.put("minInclusive", "1");
                this.createSchemaDatatypeValidator("positiveInteger", this.getDatatypeValidator("nonNegativeInteger"), hashtable, false);
                ((IDDatatypeValidator)this.getDatatypeValidator("ID")).setTokenType("ID");
                ((IDREFDatatypeValidator)this.getDatatypeValidator("IDREF")).setTokenType("IDREF");
                QNameDatatypeValidator.setNCNameValidator(this.getDatatypeValidator("NCName"));
                this.fRegistryExpanded = (byte)2;
            }
            catch (InvalidDatatypeFacetException invalidDatatypeFacetException) {
                invalidDatatypeFacetException.printStackTrace();
            }
        }
    }

    public DatatypeValidator getDatatypeValidator(String string) {
        AbstractDatatypeValidator abstractDatatypeValidator = null;
        if (string == null) {
            return null;
        }
        abstractDatatypeValidator = (AbstractDatatypeValidator)this.fDTDDatatypeRegistry.get(string);
        if (abstractDatatypeValidator == null && this.fSchemaValidation == 1 && (abstractDatatypeValidator = (AbstractDatatypeValidator)this.fSchemaDatatypeRegistry.get(string)) == null) {
            return (DatatypeValidator)this.fRegistry.get(string);
        }
        return abstractDatatypeValidator;
    }

    public void initializeDTDRegistry() {
        block2: {
            if (this.fRegistryExpanded != 0) break block2;
            try {
                this.fDTDDatatypeRegistry.put("string", new StringDatatypeValidator());
                this.fDTDDatatypeRegistry.put("ID", new IDDatatypeValidator());
                this.fDTDDatatypeRegistry.put("IDREF", new IDREFDatatypeValidator());
                this.fDTDDatatypeRegistry.put("ENTITY", new ENTITYDatatypeValidator());
                this.fDTDDatatypeRegistry.put("NOTATION", new NOTATIONDatatypeValidator());
                this.createDTDDatatypeValidator("IDREFS", new IDREFDatatypeValidator(), null, true);
                this.createDTDDatatypeValidator("ENTITIES", new ENTITYDatatypeValidator(), null, true);
                Hashtable<String, String> hashtable = new Hashtable<String, String>(2);
                hashtable.put("specialToken", "NMTOKEN");
                hashtable.put("whiteSpace", "collapse");
                this.createDTDDatatypeValidator("NMTOKEN", new StringDatatypeValidator(), hashtable, false);
                this.createDTDDatatypeValidator("NMTOKENS", this.getDatatypeValidator("NMTOKEN"), null, true);
                this.fRegistryExpanded = 1;
            }
            catch (InvalidDatatypeFacetException invalidDatatypeFacetException) {
                invalidDatatypeFacetException.printStackTrace();
            }
        }
    }

    private void registerDTDValidator(String string, DatatypeValidator datatypeValidator) {
        if (datatypeValidator != null) {
            this.fDTDDatatypeRegistry.put(string, datatypeValidator);
        }
    }

    private void registerSchemaValidator(String string, DatatypeValidator datatypeValidator) {
        if (datatypeValidator != null) {
            this.fSchemaDatatypeRegistry.put(string, datatypeValidator);
        }
    }

    private void registerUserDefinedValidator(String string, DatatypeValidator datatypeValidator) {
        if (datatypeValidator != null) {
            this.fRegistry.put(string, datatypeValidator);
        }
    }

    public void resetRegistry() {
        this.fRegistry.clear();
        this.fSchemaValidation = 0;
    }
}

