#!/usr/bin/python

from distutils.core import setup

import subprocess, glob, os.path
import os

mo_files = []
# HACK: make sure that the mo files are generated and up-to-date
subprocess.call(["make", "-C", "po", "build-mo"])
for filepath in glob.glob("po/mo/*/LC_MESSAGES/*.mo"):
    lang = filepath[len("po/mo/"):]
    targetpath = os.path.dirname(os.path.join("share/locale",lang))
    mo_files.append((targetpath, [filepath]))

setup(
    name="envyng-qt",
    author="Alberto Milone",
    author_email="albertomilone@alice.it",
    maintainer="Alberto Milone",
    maintainer_email="albertomilone@alice.it",
    url="http://www.albertomilone.com/nvidia_scripts1.html",
    license="gpl",
    description="install/uninstall the ATI or the NVIDIA driver",
    packages=["Envyngqt"],
    data_files=[("share/envyng-qt/designer", glob.glob("designer/*")),
                ("share/envyng-qt/pixmaps", glob.glob("pixmaps/*")),
                ("share/man/man1", glob.glob("man/*.1")),
                ("share/lintian/overrides", glob.glob("overrides/envyng-*")),
                ("share/envyng-qt", glob.glob("envyng*.py")),
               ] , #+ mo_files
    scripts=["envyng-qt"],
)
#try:
    #os.makedirs('debian/envyng-qt/usr/share/applications/')
#except OSError:
    #pass
#try:
    #os.symlink('/usr/share/envy/applications/envyng.desktop', 'debian/envyng-qt/usr/share/applications/envyng-qt.desktop')
#except OSError:
    #pass

