/*
 * BackupStatus.java
 *
 * Created on December 13, 2000, 6:52 AM
 */

package com.sun.enterprise.config.backup.status;

import com.sun.enterprise.config.backup.pluggable.EnvironmentFactory;
import com.sun.enterprise.config.backup.BackupException;

/**
 *
 * @author  sridatta
 */
public class RemoveStatus extends Status {
        
    private String _removedBackupFileName;
    
    //can be user or system
    private boolean _isSystemRemoved=true;
    
    /** Creates a new instance of BackupStatus */
    public RemoveStatus() throws BackupException {
        super(true);
    }
     public RemoveStatus(String file, boolean system) throws BackupException {
         super(true);
        _removedBackupFileName = file;
        _isSystemRemoved = system;
    }
    
    public String getOperation() {
        return "RemoveStatus";
    }
    /*
    public void setIsSystemRemoved(boolean val) {
        _isSystemRemoved = val;
    }
     */
    
    public String thisToString() {
            return "Removed FileName " + _removedBackupFileName +
                    ", Removed by " + (_isSystemRemoved?"system":"user");
    }
}
