/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.upgrade.common;

import com.sun.enterprise.tools.upgrade.common.Appserver70DomainNamesResolver;
import com.sun.enterprise.tools.upgrade.common.CommonInfoModel;
import com.sun.enterprise.tools.upgrade.common.DomainInfo;
import com.sun.enterprise.tools.upgrade.common.UpgradeConstants;
import com.sun.enterprise.tools.upgrade.common.UpgradeUtils;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class VersionExtracter {
    private String installDir;
    private StringManager stringManager = StringManager.getManager((String)"com.sun.enterprise.tools.upgrade.common");
    private Logger logger = CommonInfoModel.getDefaultLogger();
    private CommonInfoModel common;

    public VersionExtracter(String iD, CommonInfoModel common) {
        this.installDir = iD;
        this.common = common;
    }

    public String getVersion() {
        String asAdminFileStr;
        String appserverVersion = null;
        String asadminString = "asadmin";
        if (System.getProperty("os.name").indexOf("indows") != -1) {
            asadminString = "asadmin.bat";
        }
        if (new File(asAdminFileStr = this.installDir + File.separator + "bin" + File.separator + asadminString).exists()) {
            String execCommand = asAdminFileStr + " version";
            try {
                Process asadminProcess = Runtime.getRuntime().exec(execCommand);
                BufferedReader pInReader = new BufferedReader(new InputStreamReader(asadminProcess.getInputStream()));
                String inLine = null;
                while ((inLine = pInReader.readLine()) != null && (appserverVersion = this.parseVersion(inLine)) == null) {
                }
                asadminProcess.destroy();
            }
            catch (Exception ex) {
                this.logger.log(Level.SEVERE, this.stringManager.getString("common.versionextracter.getVersionError"), ex);
            }
        }
        if (appserverVersion == null) {
            appserverVersion = this.extractVersionFromConfigFile();
        }
        return appserverVersion;
    }

    private String parseVersion(String versionString) {
        String appservString = this.stringManager.getString("common.versionextracter.appserver.string");
        String app80String = this.stringManager.getString("common.versionextracter.appserver.80string");
        String appPEString = this.stringManager.getString("common.versionextracter.appserver.platformEdition");
        String appSEString = this.stringManager.getString("common.versionextracter.appserver.standardEdition");
        String appEEString = this.stringManager.getString("common.versionextracter.appserver.enterpriseEdition");
        if (versionString.indexOf(appservString) != -1 && versionString.indexOf(app80String) != -1) {
            if (versionString.indexOf(appPEString) != -1) {
                return "as80pe";
            }
            if (versionString.indexOf(appSEString) != -1) {
                return "as81se";
            }
            if (versionString.indexOf(appEEString) != -1) {
                return "as81ee";
            }
            return null;
        }
        String app81String = this.stringManager.getString("common.versionextracter.appserver.81string");
        if (versionString.indexOf(appservString) != -1 && versionString.indexOf(app81String) != -1) {
            if (versionString.indexOf(appPEString) != -1) {
                return "as81pe";
            }
            if (versionString.indexOf(appSEString) != -1) {
                return "as81se";
            }
            if (versionString.indexOf(appEEString) != -1) {
                return "as81ee";
            }
            return null;
        }
        String app90String = this.stringManager.getString("common.versionextracter.appserver.90string");
        if (versionString.indexOf(appservString) != -1 && versionString.indexOf(app90String) != -1) {
            if (versionString.indexOf(appPEString) != -1) {
                return "as90pe";
            }
            if (versionString.indexOf(appSEString) != -1) {
                return "as90se";
            }
            if (versionString.indexOf(appEEString) != -1) {
                return "as90ee";
            }
            return null;
        }
        String app91_01String = this.stringManager.getString("common.versionextracter.appserver.91_01string");
        if (versionString.indexOf(appservString) != -1 && versionString.indexOf(app91_01String) != -1) {
            return "9.1";
        }
        String app91_1String = this.stringManager.getString("common.versionextracter.appserver.91_1string");
        if (versionString.indexOf(appservString) != -1 && versionString.indexOf(app91_1String) != -1) {
            return "9.1";
        }
        String app91String = this.stringManager.getString("common.versionextracter.appserver.91string");
        if (versionString.indexOf(appservString) != -1 && versionString.indexOf(app91String) != -1) {
            return "9.1";
        }
        String app10_0String = this.stringManager.getString("common.versionextracter.appserver.10_0string");
        if (versionString.indexOf(appservString) != -1 && versionString.indexOf(app10_0String) != -1) {
            return "10.0";
        }
        String app82String = this.stringManager.getString("common.versionextracter.appserver.82string");
        if (versionString.indexOf(appservString) != -1 && versionString.indexOf(app82String) != -1) {
            if (versionString.indexOf(appPEString) != -1) {
                return "as82pe";
            }
            if (versionString.indexOf(appSEString) != -1) {
                return "as82se";
            }
            if (versionString.indexOf(appEEString) != -1) {
                return "as82ee";
            }
            return null;
        }
        return null;
    }

    public String formatVersionEditionStrings(String[] verEd) {
        if (verEd != null) {
            if (verEd[0].equals("80")) {
                if (verEd[1].equals("pe")) {
                    return "as80pe";
                }
                if (verEd[1].equals("se")) {
                    return "as80se";
                }
                if (verEd[1].equals("ee")) {
                    return "as81ee";
                }
            } else if (verEd[0].equals("81")) {
                if (verEd[1].equals("pe")) {
                    return "as81pe";
                }
                if (verEd[1].equals("se")) {
                    return "as81se";
                }
                if (verEd[1].equals("ee")) {
                    return "as81ee";
                }
            } else if (verEd[0].equals("90")) {
                if (verEd[1].equals("pe")) {
                    return "as90pe";
                }
                if (verEd[1].equals("se")) {
                    return "as90se";
                }
                if (verEd[1].equals("ee")) {
                    return "as90ee";
                }
            } else if (verEd[0].equals("82")) {
                if (verEd[1].equals("pe")) {
                    return "as82pe";
                }
                if (verEd[1].equals("se")) {
                    return "as82se";
                }
                if (verEd[1].equals("ee")) {
                    return "as82ee";
                }
            } else {
                if (verEd[0].startsWith("9.1")) {
                    return verEd[0] + verEd[1];
                }
                if (verEd[0].equals("10.0")) {
                    return verEd[0] + verEd[1];
                }
            }
        }
        return null;
    }

    public String extractVersionFromConfigFile() {
        String versionString = null;
        String editionString = null;
        File configFile = this.getConfigFile();
        if (configFile == null || !configFile.exists()) {
            return null;
        }
        UpgradeUtils upgrUtils = UpgradeUtils.getUpgradeUtils(this.common);
        Document adminServerDoc = upgrUtils.getDomainDocumentElement(configFile.toString());
        try {
            String publicID = adminServerDoc.getDoctype().getPublicId();
            String systemID = adminServerDoc.getDoctype().getSystemId();
            String appservString = this.stringManager.getString("common.versionextracter.appserver.string");
            String app80String = this.stringManager.getString("common.versionextracter.appserver.80ConfigString");
            if (publicID.indexOf(appservString) != -1 && systemID.indexOf(app80String) != -1) {
                versionString = "80";
                editionString = "pe";
            }
            String app81String = this.stringManager.getString("common.versionextracter.appserver.81ConfigString");
            if (publicID.indexOf(appservString) != -1 && systemID.indexOf(app81String) != -1) {
                versionString = "81";
            }
            String app90String = this.stringManager.getString("common.versionextracter.appserver.90ConfigString");
            if (publicID.indexOf(appservString) != -1 && systemID.indexOf(app90String) != -1) {
                versionString = "90";
            }
            String app91String = this.stringManager.getString("common.versionextracter.appserver.91ConfigString");
            if (publicID.indexOf(appservString) != -1 && systemID.indexOf(app91String) != -1) {
                versionString = "9.1";
            }
            if (editionString == null) {
                NodeList taggedElements = adminServerDoc.getDocumentElement().getElementsByTagName("web-container-availability");
                if (taggedElements.getLength() == 0) {
                    editionString = UpgradeConstants.isPreAS91Version(versionString) ? "pe" : "developer";
                } else {
                    for (int lh = 0; lh < taggedElements.getLength(); ++lh) {
                        Element element = (Element)taggedElements.item(lh);
                        String attr = element.getAttribute("persistence-type");
                        if (attr.equals("ha")) {
                            editionString = UpgradeConstants.isPreAS91Version(versionString) ? "ee" : "enterprise";
                        } else if (attr.equals("replicated")) {
                            editionString = "cluster";
                        }
                        if (editionString != null) break;
                    }
                }
            }
            return this.formatVersionEditionStrings(new String[]{versionString, editionString});
        }
        catch (Exception ex) {
            this.logger.log(Level.SEVERE, this.stringManager.getString("common.versionextracter.transform_start_failure_message"), ex);
            return null;
        }
    }

    private Hashtable extractDomainsMapping() {
        File runtime70Jar = new File(this.installDir + File.separator + "lib" + File.separator + "admingui.ear");
        boolean notTargetInstallation7x = true;
        if (this.common.getTargetInstallDir() != null) {
            boolean bl = notTargetInstallation7x = !this.common.getTargetInstallDir().equals(this.installDir);
        }
        if (runtime70Jar.exists() && !UpgradeUtils.getUpgradeUtils(this.common).checkSourceInputAsDomainRoot(this.installDir) && notTargetInstallation7x) {
            Appserver70DomainNamesResolver as = new Appserver70DomainNamesResolver(this.installDir);
            Hashtable domainsMapping = as.getDomainNamesPathMapping();
            this.common.setInstallConfig70(as.getConfigDir70(this.installDir));
            return domainsMapping;
        }
        return null;
    }

    private File getConfigFile() {
        Hashtable domainMapping = this.extractDomainsMapping();
        if (domainMapping != null && !domainMapping.isEmpty()) {
            DomainInfo dInfo = (DomainInfo)domainMapping.values().iterator().next();
            String instanceName = null;
            Iterator instIt = dInfo.getInstanceNames().iterator();
            while (instIt.hasNext() && (instanceName = (String)instIt.next()).equals("admin-server")) {
            }
            return new File(dInfo.getInstancePath(instanceName) + File.separator + "config" + File.separator + "server.xml");
        }
        String[] dCDirs = this.getDomainAndConfigDirs();
        if (dCDirs == null) {
            return null;
        }
        if (dCDirs[1].indexOf("server1") != -1) {
            return new File(dCDirs[1] + File.separator + "server.xml");
        }
        return new File(dCDirs[1] + File.separator + "domain.xml");
    }

    public String[] getDomainAndConfigDirs() {
        String domainsDir = this.installDir + File.separator + "domains";
        String configDir = null;
        boolean domainRootSame = false;
        if (!new File(domainsDir).exists()) {
            domainsDir = this.installDir + File.separator + "domains_bak";
            if (!new File(domainsDir).exists()) {
                String[] chList = new File(this.installDir).list();
                if (chList == null || chList.length <= 0) {
                    domainsDir = null;
                    configDir = null;
                } else {
                    domainsDir = this.installDir + File.separator + chList[0];
                    if (!new File(domainsDir + File.separator + "config").exists()) {
                        String sourceConfigDir = this.installDir + File.separator + "config";
                        if (new File(sourceConfigDir).isDirectory()) {
                            configDir = sourceConfigDir;
                            domainsDir = this.installDir;
                        } else {
                            domainsDir = null;
                            configDir = null;
                        }
                    } else {
                        String domainsDir2 = domainsDir + File.separator + "server1";
                        configDir = !new File(domainsDir2).exists() ? domainsDir + File.separator + "config" : domainsDir + File.separator + "server1" + File.separator + "config";
                        domainsDir = this.installDir;
                    }
                }
            } else {
                String[] chList = new File(domainsDir).list();
                configDir = domainsDir + File.separator + chList[0] + File.separator + "config";
            }
        } else {
            String[] chList = new File(domainsDir).list();
            if (chList != null) {
                String domainsDir2 = domainsDir + File.separator + chList[0] + File.separator + "server1";
                configDir = !new File(domainsDir2).exists() ? domainsDir + File.separator + chList[0] + File.separator + "config" : domainsDir + File.separator + chList[0] + File.separator + "server1" + File.separator + "config";
            }
        }
        if (configDir == null) {
            return null;
        }
        return new String[]{domainsDir, configDir};
    }

    private String getTextNodeData(Element element) {
        NodeList children = element.getChildNodes();
        for (int index = 0; index < children.getLength(); ++index) {
            if (children.item(index).getNodeType() != 3) continue;
            return children.item(index).getNodeValue();
        }
        return null;
    }

    public String getTargetDefaultProfile() {
        String defaultProfile = null;
        try {
            String path = this.installDir + File.separator + "config" + File.separator + "asadminenv.conf";
            File asadminenvFile = new File(path);
            BufferedReader reader = new BufferedReader(new FileReader(asadminenvFile));
            while (reader.ready()) {
                String line = reader.readLine();
                if (!line.startsWith("AS_ADMIN_PROFILE=")) continue;
                defaultProfile = line.substring(line.indexOf("=") + 1);
                break;
            }
            reader.close();
            if (defaultProfile == null) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            this.logger.severe(this.stringManager.getString("upgrade.common.general_exception") + " " + e.getMessage());
            this.common.recover();
            System.exit(2);
        }
        return defaultProfile;
    }

    public static void main(String[] args) {
    }
}

