/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.upgrade.gui;

import com.sun.enterprise.tools.upgrade.gui.util.DialogEvent;
import com.sun.enterprise.tools.upgrade.gui.util.DialogListener;
import com.sun.enterprise.util.i18n.StringManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public class ClusterDetailsPanel
extends JPanel {
    private StringManager stringManager = StringManager.getManager((String)"com.sun.enterprise.tools.upgrade.gui");
    private ClusterFilesTableModel clusterFilesTableModel = null;
    private JTable clusterFilesTable = null;
    private JScrollPane clusterFilesTableScrollPane = null;
    private JPanel clusterFilesPanel = null;
    private JPanel addRemoveEditHomeInterfacePanel = null;
    private JButton addClusterFileButton = null;
    private JButton removeClusterFileButton = null;
    private JFileChooser fileChooser = null;
    private Vector dialogListeners = new Vector();

    public ClusterDetailsPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.getClusterFilesPanel(), constraints);
        this.getClusterFilesTableScrollPane().setViewportView(this.getClusterFilesTable());
        this.getClusterFilesTable().setModel(this.getClusterFilesTableModel());
        this.getClusterFilesTable().createDefaultColumnsFromModel();
    }

    private JPanel getClusterFilesPanel() {
        if (this.clusterFilesPanel == null) {
            this.clusterFilesPanel = new JPanel();
            this.clusterFilesPanel.setName("clusterFilesPanel");
            this.clusterFilesPanel.setLayout(new GridBagLayout());
            JLabel tableTitleLabel = new JLabel();
            tableTitleLabel.setText(this.stringManager.getString("upgrade.gui.clusterPanel.tableTitleName"));
            GridBagConstraints labelConstraints = new GridBagConstraints();
            labelConstraints.gridx = 0;
            labelConstraints.gridy = 0;
            labelConstraints.gridwidth = 3;
            labelConstraints.fill = 0;
            labelConstraints.insets = new Insets(10, 10, 5, 0);
            this.clusterFilesPanel.add((Component)tableTitleLabel, labelConstraints);
            GridBagConstraints constraintsClusterScrollPane1 = new GridBagConstraints();
            constraintsClusterScrollPane1.gridx = 0;
            constraintsClusterScrollPane1.gridy = 1;
            constraintsClusterScrollPane1.gridwidth = 2;
            constraintsClusterScrollPane1.fill = 1;
            constraintsClusterScrollPane1.weightx = 1.0;
            constraintsClusterScrollPane1.weighty = 1.0;
            constraintsClusterScrollPane1.insets = new Insets(5, 10, 5, 0);
            this.clusterFilesPanel.add((Component)this.getClusterFilesTableScrollPane(), constraintsClusterScrollPane1);
            GridBagConstraints constraintsaddRemoveEditHomeInterfacePanel1 = new GridBagConstraints();
            constraintsaddRemoveEditHomeInterfacePanel1.gridx = 2;
            constraintsaddRemoveEditHomeInterfacePanel1.gridy = 1;
            constraintsaddRemoveEditHomeInterfacePanel1.fill = 3;
            constraintsaddRemoveEditHomeInterfacePanel1.weighty = 1.0;
            constraintsaddRemoveEditHomeInterfacePanel1.insets = new Insets(5, 0, 5, 0);
            this.clusterFilesPanel.add((Component)this.getaddRemoveEditHomeInterfacePanel(), constraintsaddRemoveEditHomeInterfacePanel1);
        }
        return this.clusterFilesPanel;
    }

    private JTable getClusterFilesTable() {
        if (this.clusterFilesTable == null) {
            this.clusterFilesTable = new JTable();
            this.clusterFilesTable.setName("clusterFilesTable");
            this.getClusterFilesTableScrollPane().setColumnHeaderView(this.clusterFilesTable.getTableHeader());
            this.getClusterFilesTableScrollPane().getViewport().setScrollMode(2);
            this.clusterFilesTable.setAutoResizeMode(2);
            this.clusterFilesTable.setAutoCreateColumnsFromModel(true);
            this.clusterFilesTable.setAutoResizeMode(2);
            this.clusterFilesTable.setAutoCreateColumnsFromModel(true);
            ListSelectionModel rowSM = this.clusterFilesTable.getSelectionModel();
            rowSM.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    if (e.getValueIsAdjusting()) {
                        return;
                    }
                    ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                    ClusterDetailsPanel.this.enableDisableRemoveButton(ClusterDetailsPanel.this.clusterFilesTable, ClusterDetailsPanel.this.getremoveClusterFileButton());
                }
            });
            final DefaultCellEditor editor = (DefaultCellEditor)this.clusterFilesTable.getDefaultEditor(String.class);
            editor.getComponent().addKeyListener(new KeyAdapter(){

                public void keyReleased(KeyEvent ke) {
                    try {
                        ClusterDetailsPanel.this.getClusterFilesTableModel().setValueAt(((JTextField)editor.getComponent()).getText().trim(), ClusterDetailsPanel.this.clusterFilesTable.getEditingRow(), 0);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
        return this.clusterFilesTable;
    }

    private JScrollPane getClusterFilesTableScrollPane() {
        if (this.clusterFilesTableScrollPane == null) {
            this.clusterFilesTableScrollPane = new JScrollPane();
            this.clusterFilesTableScrollPane.setName("getClusterFilesTable");
            this.clusterFilesTableScrollPane.setVerticalScrollBarPolicy(22);
            this.clusterFilesTableScrollPane.setHorizontalScrollBarPolicy(32);
            this.clusterFilesTableScrollPane.setMaximumSize(new Dimension(21, 20));
            this.clusterFilesTableScrollPane.setPreferredSize(new Dimension(21, 20));
            this.clusterFilesTableScrollPane.setMinimumSize(new Dimension(21, 20));
            this.clusterFilesTableScrollPane.setViewportView(this.getClusterFilesTable());
        }
        return this.clusterFilesTableScrollPane;
    }

    private JPanel getaddRemoveEditHomeInterfacePanel() {
        if (this.addRemoveEditHomeInterfacePanel == null) {
            this.addRemoveEditHomeInterfacePanel = new JPanel();
            this.addRemoveEditHomeInterfacePanel.setName("addRemoveEditHomeInterfacePanel");
            this.addRemoveEditHomeInterfacePanel.setLayout(new GridBagLayout());
            GridBagConstraints constraintsaddClusterFileButton = new GridBagConstraints();
            constraintsaddClusterFileButton.gridx = 0;
            constraintsaddClusterFileButton.gridy = 0;
            constraintsaddClusterFileButton.insets = new Insets(10, 5, 5, 5);
            this.addRemoveEditHomeInterfacePanel.add((Component)this.getaddClusterFileButton(), constraintsaddClusterFileButton);
            GridBagConstraints constraintsremoveClusterFileButton = new GridBagConstraints();
            constraintsremoveClusterFileButton.gridx = 0;
            constraintsremoveClusterFileButton.gridy = 1;
            constraintsremoveClusterFileButton.insets = new Insets(5, 5, 5, 5);
            this.addRemoveEditHomeInterfacePanel.add((Component)this.getremoveClusterFileButton(), constraintsremoveClusterFileButton);
        }
        return this.addRemoveEditHomeInterfacePanel;
    }

    private JButton getaddClusterFileButton() {
        if (this.addClusterFileButton == null) {
            this.addClusterFileButton = new JButton();
            this.addClusterFileButton.setName("addClusterFileButton");
            this.addClusterFileButton.setText(this.stringManager.getString("upgrade.gui.clusterPanel.addButtonText"));
            this.addClusterFileButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ClusterDetailsPanel.this.addClusterFileAction();
                }
            });
        }
        return this.addClusterFileButton;
    }

    private JButton getremoveClusterFileButton() {
        if (this.removeClusterFileButton == null) {
            this.removeClusterFileButton = new JButton();
            this.removeClusterFileButton.setName("removeClusterFileButton");
            this.removeClusterFileButton.setText(this.stringManager.getString("upgrade.gui.clusterPanel.deleteButtonText"));
            this.removeClusterFileButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ClusterDetailsPanel.this.removeClusterFileAction();
                }
            });
        }
        return this.removeClusterFileButton;
    }

    public ClusterFilesTableModel getClusterFilesTableModel() {
        if (this.clusterFilesTableModel == null) {
            this.clusterFilesTableModel = new ClusterFilesTableModel(this);
        }
        return this.clusterFilesTableModel;
    }

    public void addClusterFileAction() {
        int returnedValue = this.getfileChooser().showOpenDialog(this);
        if (returnedValue == 0) {
            this.getClusterFilesTableModel().addClusterFile(String.valueOf(this.getfileChooser().getSelectedFile()));
        }
    }

    private JFileChooser getfileChooser() {
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser();
            this.fileChooser.setName("fileChooser");
            this.fileChooser.setBounds(668, 49, 500, 300);
            this.fileChooser.setDialogTitle(this.stringManager.getString("upgrade.gui.certpanel.chooseFile"));
        }
        return this.fileChooser;
    }

    public void removeClusterFileAction() {
        int i;
        int[] rows = this.getClusterFilesTable().getSelectedRows();
        String[] rowPropNames = new String[rows.length];
        int option = JOptionPane.showConfirmDialog(this, this.stringManager.getString("upgrade.gui.clusterPanel.removeConfirmMsg"), this.stringManager.getString("upgrade.gui.clusterPanel.removeConfirmTitle"), 0, 3);
        if (option == 1) {
            return;
        }
        for (i = 0; i < rows.length; ++i) {
            rowPropNames[i] = this.getClusterFilesTableModel().getClusterFile(rows[i]);
        }
        for (i = 0; i < rows.length; ++i) {
            this.getClusterFilesTableModel().removeClusterFile(rowPropNames[i]);
        }
        this.getClusterFilesTable().clearSelection();
        this.enableDisableRemoveButton(this.getClusterFilesTable(), this.getremoveClusterFileButton());
    }

    public void enableDisableRemoveButton(JTable table, JButton removeButton) {
        if (table.getSelectionModel().isSelectionEmpty()) {
            removeButton.setEnabled(false);
        } else if (table.getSelectedRowCount() <= 1) {
            removeButton.setEnabled(true);
        }
    }

    public void addDialogListener(DialogListener listener) {
        this.dialogListeners.addElement(listener);
    }

    public void removeDialogListener(DialogListener listener) {
        this.dialogListeners.removeElement(listener);
    }

    private void processDialogEvent() {
        DialogEvent de = new DialogEvent(this, 7);
        for (int i = 0; i < this.dialogListeners.size(); ++i) {
            ((DialogListener)this.dialogListeners.elementAt(i)).dialogProcessed(de);
        }
    }

    class ClusterFilesTableModel
    extends AbstractTableModel {
        private Vector clusterFiles = new Vector(0);
        private String[] columnNames = null;
        private ClusterDetailsPanel clusterDetailsPanel;
        private StringManager stringManager = StringManager.getManager((String)"com.sun.enterprise.tools.upgrade.gui");

        public ClusterFilesTableModel(ClusterDetailsPanel cdp) {
            this.clusterDetailsPanel = cdp;
            this.columnNames = new String[]{this.stringManager.getString("upgrade.gui.clusterPanel.tableColumnName")};
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        public int getRowCount() {
            return this.clusterFiles.size();
        }

        public boolean isCellEditable(int row, int col) {
            return col == 0;
        }

        public void setValueAt(Object value, int row, int col) {
            if (value instanceof String && row < this.clusterFiles.size()) {
                this.clusterFiles.setElementAt(value, row);
            }
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        public Object getValueAt(int row, int col) {
            String rowEle = (String)this.clusterFiles.elementAt(row);
            String ret = "";
            switch (col) {
                case 0: {
                    ret = rowEle;
                }
            }
            return ret;
        }

        public Vector getClusterFiles() {
            return this.clusterFiles;
        }

        public void setClusterFiles(Vector v) {
            this.clusterFiles = v;
        }

        public void addClusterFile(String ele) {
            if (ele != null && this.getClusterFile(ele) == null) {
                this.clusterFiles.addElement(ele);
            }
            this.fireTableDataChanged();
            this.clusterDetailsPanel.processDialogEvent();
        }

        public void removeClusterFile(String ele) {
            if (ele != null) {
                this.clusterFiles.removeElement(ele);
            }
            this.fireTableDataChanged();
            this.clusterDetailsPanel.processDialogEvent();
        }

        public String getClusterFile(int rowNo) {
            if (rowNo < this.clusterFiles.size()) {
                return (String)this.clusterFiles.elementAt(rowNo);
            }
            return null;
        }

        public String getClusterFile(String propName) {
            String ele1 = null;
            boolean found = false;
            if (propName != null) {
                for (int i = 0; i < this.clusterFiles.size(); ++i) {
                    ele1 = (String)this.clusterFiles.elementAt(i);
                    if (!propName.equals(ele1)) continue;
                    found = true;
                    break;
                }
            }
            if (found) {
                return ele1;
            }
            return null;
        }
    }
}

