/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.upgrade.transform;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;

public class AttributeExtracter {
    private String fileName;
    private static AttributeExtracter attrExtracter;
    private HashMap attributeMap;

    private AttributeExtracter(String fileName) {
        this.fileName = fileName;
        this.attributeMap = new HashMap();
    }

    public static AttributeExtracter getExtracter(String fileName) {
        if (attrExtracter == null) {
            attrExtracter = new AttributeExtracter(fileName);
        }
        return attrExtracter;
    }

    public List getAttributeList(String elementName) {
        if (this.attributeMap.get(elementName) != null) {
            return (List)this.attributeMap.get(elementName);
        }
        ArrayList<String> attrList = new ArrayList<String>();
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(this.fileName)));
            String readLine = null;
            while ((readLine = reader.readLine()) != null) {
                String attrLine = this.getAttributeLine(elementName, readLine);
                if (attrLine == null) continue;
                if (attrLine.length() > 0 && !attrLine.trim().equals("")) {
                    attrList.add(this.getAttributeFromLine(attrLine));
                }
                this.extractAttributes(reader, attrList);
            }
            this.attributeMap.put(elementName, attrList);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return attrList;
    }

    private String getAttributeLine(String elementName, String line) {
        String atLine;
        StringTokenizer stk;
        if (line.startsWith("<!ATTLIST") && (stk = new StringTokenizer(atLine = line.substring("<!ATTLIST".length()).trim())).nextToken().equals(elementName)) {
            return atLine.substring(elementName.length());
        }
        return null;
    }

    private String getAttributeFromLine(String attrLine) {
        StringTokenizer stk = new StringTokenizer(attrLine);
        return stk.nextToken();
    }

    private void extractAttributes(BufferedReader reader, List attrList) throws Exception {
        for (int i = 0; i < 50; ++i) {
            String attrLine = reader.readLine().trim();
            attrList.add(this.getAttributeFromLine(attrLine.trim()));
            if (attrLine.endsWith(">")) break;
        }
    }

    public static void main(String[] args) {
    }
}

