/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mfwk.agent.appserv.delegate;

import com.sun.mfwk.CMM_MBean;
import com.sun.mfwk.MfDelegate;
import com.sun.mfwk.MfMonitoringState;
import com.sun.mfwk.MfStatesManager;
import com.sun.mfwk.agent.appserv.connection.ConnectionRegistry;
import com.sun.mfwk.agent.appserv.delegate.AttributeHandler;
import com.sun.mfwk.agent.appserv.delegate.HandlerException;
import com.sun.mfwk.agent.appserv.logging.LogDomains;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public abstract class AbstractDelegate
implements MfDelegate {
    public CMM_MBean object = null;
    public MBeanServerConnection mbs = null;
    public ObjectName instrumentedObjectName = null;
    public String serverName = null;
    public String domainName = null;
    private Map mapper = null;
    private Integer monitoringState = MfMonitoringState.STATE_CREATED;
    private ArrayList managementChainStates = new ArrayList();
    private Boolean managementChainActivated = Boolean.FALSE;

    public AbstractDelegate() {
        this.mapper = new HashMap();
    }

    public void addMappingEntry(String CMM_Attribute, String mapping_Attribute, ObjectName peer, AttributeHandler handler) {
        this.mapper.put(CMM_Attribute, new RemoteAttribute(mapping_Attribute, peer, handler));
    }

    public void addMappingEntry(String CMM_Attribute, String mapping_Attribute, ObjectName peer) {
        this.mapper.put(CMM_Attribute, new RemoteAttribute(mapping_Attribute, peer));
    }

    public void addDefaultMappingEntry(String CMM_Attribute, Object defaultValue) {
        this.mapper.put(CMM_Attribute, defaultValue);
    }

    public Object getAttribute(String attribute) throws HandlerException, AttributeNotFoundException, MBeanException, ReflectionException {
        Object value = this.mapper.get(attribute);
        if (value instanceof RemoteAttribute) {
            RemoteAttribute ra = (RemoteAttribute)value;
            try {
                if (ra.handler != null) {
                    return ra.handler.handleAttribute(ra.peer, ra.attribute, this.mbs);
                }
                return this.mbs.getAttribute(ra.peer, ra.attribute);
            }
            catch (InstanceNotFoundException e) {
                LogDomains.getLogger().log(Level.WARNING, "InstanceNotFoundException while trying to get attribute " + ra.attribute + " from MBean " + ra.peer, e);
                throw new MBeanException(e);
            }
            catch (IOException e) {
                LogDomains.getLogger().fine("Found stale connection while trying to get attribute " + ra.attribute + " from MBean " + ra.peer + ". Server name: " + this.serverName);
                if (this.serverName == null) {
                    throw new MBeanException(e);
                }
                try {
                    ConnectionRegistry r = ConnectionRegistry.getInstance();
                    this.mbs = r.getConnection(this.serverName, this.domainName);
                    LogDomains.getLogger().fine("Refreshed connection for server: " + this.serverName);
                    if (ra.handler != null) {
                        return ra.handler.handleAttribute(ra.peer, ra.attribute, this.mbs);
                    }
                    return this.mbs.getAttribute(ra.peer, ra.attribute);
                }
                catch (Exception ex) {
                    LogDomains.getLogger().log(Level.WARNING, "Exception while trying to get attribute " + ra.attribute + " from MBean " + ra.peer + ". Connection refresh attempt failed.", e);
                    throw new MBeanException(ex);
                }
            }
        }
        if (value != null) {
            return value;
        }
        return "Not_Supported";
    }

    public AttributeList getAttributes(String[] attributes) throws HandlerException, AttributeNotFoundException, MBeanException, ReflectionException, InstanceNotFoundException, IOException {
        if (attributes == null) {
            throw new IllegalArgumentException();
        }
        AttributeList attributeList = new AttributeList();
        for (int i = 0; i < attributes.length; ++i) {
            attributeList.add(new Attribute(attributes[i], this.getAttribute(attributes[i])));
        }
        return attributeList;
    }

    public Set queryNames(ObjectName pattern) {
        try {
            return this.mbs.queryNames(pattern, null);
        }
        catch (IOException e) {
            LogDomains.getLogger().fine("Found stale connection for server: " + this.serverName);
            try {
                if (this.serverName != null) {
                    ConnectionRegistry r = ConnectionRegistry.getInstance();
                    this.mbs = r.getConnection(this.serverName, this.domainName);
                    LogDomains.getLogger().fine("Refreshed connection for server: " + this.serverName);
                    return this.mbs.queryNames(pattern, null);
                }
            }
            catch (Exception ex) {
                System.err.println("Exception: " + ex);
            }
        }
        catch (Exception e) {
            System.err.println("Error: " + e);
        }
        return null;
    }

    public void initialize(Object[] params) throws Exception {
        CMM_MBean object = null;
        MBeanServerConnection mbs = null;
        ObjectName objectName = null;
        if (params.length != 3) {
            throw new Exception("Invalid Parameters");
        }
        if (!(params[0] instanceof CMM_MBean)) {
            throw new Exception("Invalid Parameters");
        }
        this.object = object = (CMM_MBean)params[0];
        if (!(params[1] instanceof MBeanServerConnection)) {
            throw new Exception("Invalid Parameters");
        }
        this.mbs = mbs = (MBeanServerConnection)params[1];
        if (!(params[2] instanceof ObjectName)) {
            throw new Exception("Invalid Paramaters");
        }
        this.instrumentedObjectName = objectName = (ObjectName)params[2];
    }

    public Object invoke(String action, Object[] parameters, String[] signatures) throws IOException, MBeanException, ReflectionException, InstanceNotFoundException {
        return null;
    }

    public void refresh() throws Exception {
    }

    public Class getCMMInterface() {
        return this.object.getCMMInterface();
    }

    public void setAttribute(Attribute attribute) throws AttributeNotFoundException {
        String name = attribute.getName();
        if (name.equals("MonitoringState")) {
            this.setMonitoringState((Integer)attribute.getValue());
            return;
        }
    }

    public void setOffLine(boolean isOffLine) {
    }

    public Map getAttributeMappings() {
        return this.mapper;
    }

    private synchronized void setMonitoringState(Integer state) {
        if (this.monitoringState != state) {
            Integer oldValue = this.monitoringState;
            this.monitoringState = state;
            MfStatesManager.sendNotification((String)"MonitoringState", (Object)oldValue, (Object)this.monitoringState, (String)this.object.getInstanceID());
            if (this.getCMMInterface().getName().equals("com.sun.cmm.CMM_Capabilities")) {
                ArrayList<String> setState = new ArrayList<String>();
                ArrayList oldList = this.managementChainStates;
                setState.add(MfMonitoringState.toString((Integer)state));
                this.managementChainStates.clear();
                this.managementChainStates.add(setState);
                this.object.sendAttributeChangeNotification("ManagementChainStates", (Object)oldList, (Object)this.managementChainStates);
                this.setManagementChainActivated();
            }
        }
    }

    private synchronized void setManagementChainActivated() {
        boolean isActivated = true;
        String status = null;
        Iterator iterator = this.managementChainStates.iterator();
        while (iterator.hasNext() && isActivated) {
            ArrayList list = (ArrayList)iterator.next();
            if (list.isEmpty()) continue;
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext() && isActivated) {
                status = (String)iterator2.next();
                if (status.equals("Initialized")) continue;
                isActivated = false;
            }
        }
        Boolean newValue = new Boolean(isActivated);
        if (!newValue.equals(this.managementChainActivated)) {
            this.object.sendAttributeChangeNotification("ManagementChainActivated", (Object)this.managementChainActivated, (Object)newValue);
            this.managementChainActivated = newValue;
        }
    }

    private class RemoteAttribute {
        String attribute = null;
        ObjectName peer = null;
        AttributeHandler handler = null;

        public RemoteAttribute(String attribute, ObjectName peer) {
            this(attribute, peer, null);
        }

        public RemoteAttribute(String attribute, ObjectName peer, AttributeHandler handler) {
            this.attribute = attribute;
            this.peer = peer;
            this.handler = handler;
        }

        public String toString() {
            return "Attribute: " + this.attribute + " ObjectName: " + this.peer;
        }
    }
}

