/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mfwk.agent.appserv.discovery;

import com.sun.mfwk.agent.appserv.discovery.ASMBeanDiscoveryService;
import java.util.HashSet;
import java.util.Set;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

class ASMBeanDiscoveryServiceImpl
implements ASMBeanDiscoveryService {
    MBeanServerConnection connection;

    public ASMBeanDiscoveryServiceImpl(MBeanServerConnection connection) {
        this.connection = connection;
    }

    public Set discoverASMBeans() throws Exception {
        ObjectName monitorPattern = new ObjectName("com.sun.appserv:*,category=monitor");
        Set<ObjectName> set = this.connection.queryNames(monitorPattern, null);
        ObjectName runtimePattern = new ObjectName("com.sun.appserv:*,j2eeType=J2EEServer,category=runtime");
        set.addAll(this.connection.queryNames(runtimePattern, null));
        ObjectName jvmRuntimePattern = new ObjectName("com.sun.appserv:*,j2eeType=JVM,category=runtime");
        set.addAll(this.connection.queryNames(jvmRuntimePattern, null));
        ObjectName clusterPattern = new ObjectName("com.sun.appserv:*,type=cluster,category=config");
        set.addAll(this.connection.queryNames(clusterPattern, null));
        ObjectName instanceRefPattern = new ObjectName("com.sun.appserv:*,type=server-ref");
        set.addAll(this.connection.queryNames(instanceRefPattern, null));
        return set;
    }

    public Set discoverASMBeans(String server) throws Exception {
        ObjectName monitorPattern = new ObjectName("com.sun.appserv:*,category=monitor,server=" + server);
        Set<ObjectName> set = this.connection.queryNames(monitorPattern, null);
        ObjectName runtimePattern = new ObjectName("com.sun.appserv:*,j2eeType=J2EEServer,category=runtime,name=" + server);
        set.addAll(this.connection.queryNames(runtimePattern, null));
        ObjectName jvmRuntimePattern = new ObjectName("com.sun.appserv:*,j2eeType=JVM,category=runtime,J2EEServer=" + server);
        set.addAll(this.connection.queryNames(jvmRuntimePattern, null));
        ObjectName clusterPattern = new ObjectName("com.sun.appserv:*,type=cluster,category=config");
        set.addAll(this.connection.queryNames(clusterPattern, null));
        return set;
    }

    public Set discoverASMBeans(ObjectName root) throws Exception {
        HashSet mbeans = new HashSet();
        return this.discover(root, mbeans);
    }

    public Set discoverClusterMBeans() throws Exception {
        ObjectName clusterPattern = new ObjectName("com.sun.appserv:*,type=cluster,category=config");
        return this.connection.queryNames(clusterPattern, null);
    }

    private Set discover(ObjectName objectName, HashSet mbeans) throws Exception {
        mbeans.add(objectName);
        MBeanInfo mbeanInfo = this.connection.getMBeanInfo(objectName);
        MBeanOperationInfo[] operations = mbeanInfo.getOperations();
        for (int j = 0; j < operations.length; ++j) {
            if (!operations[j].getName().equals("getChildren")) continue;
            ObjectName[] children = (ObjectName[])this.connection.invoke(objectName, "getChildren", null, null);
            for (int i = 0; i < children.length; ++i) {
                this.discover(children[i], mbeans);
            }
            break;
        }
        return mbeans;
    }
}

