/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mfwk.agent.appserv.modeler;

import com.sun.appserv.management.client.AppserverConnectionSource;
import com.sun.appserv.management.client.TLSParams;
import com.sun.appserv.management.client.TrustAnyTrustManager;
import java.util.Map;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.j2ee.statistics.Statistic;
import javax.net.ssl.X509TrustManager;

public class MonitorTreeCrawler {
    public static final String USER_PROPERTY = "jmx.user";
    public static final String PASSWORD_PROPERTY = "jmx.password";
    public static final String HOST_PROPERTY = "jmx.host";
    public static final String PORT_PROPERTY = "jmx.port";
    public static final String SECURE_PROPERTY = "jmx.usetls";

    public static void main(String[] args) {
        String user = System.getProperty(USER_PROPERTY);
        if (args.length > 0) {
            user = args[0];
        }
        String password = System.getProperty(PASSWORD_PROPERTY);
        if (args.length > 1) {
            password = args[1];
        }
        String host = System.getProperty(HOST_PROPERTY);
        if (args.length > 2) {
            host = args[2];
        }
        String port = System.getProperty(PORT_PROPERTY);
        if (args.length > 3) {
            port = args[3];
        }
        boolean useTls = Boolean.getBoolean(SECURE_PROPERTY);
        if (args.length > 4) {
            useTls = "true".equalsIgnoreCase(args[4]);
        }
        TLSParams tlsParams = null;
        if (useTls) {
            tlsParams = new TLSParams((X509TrustManager[])TrustAnyTrustManager.getInstanceArray(), null);
        }
        String monitoringRoot = null;
        if (args.length > 5) {
            monitoringRoot = args[5];
        }
        AppserverConnectionSource src = new AppserverConnectionSource("sun-as-rmi", host, Integer.parseInt(port), user, password, tlsParams, (Map)null);
        try {
            MBeanServerConnection connection = src.getMBeanServerConnection(true);
            if (monitoringRoot == null) {
                MonitorTreeCrawler.crawlMonitoringTree(connection);
            } else {
                MonitorTreeCrawler.crawlMonitoringTree(connection, new ObjectName(monitoringRoot));
            }
        }
        catch (Exception ex) {
            System.out.println("Exception: " + ex.getMessage());
            ex.printStackTrace();
        }
    }

    public static void crawlMonitoringTree(MBeanServerConnection connection) throws Exception {
        System.out.println("Getting all data");
        MonitorTreeCrawler.crawlMonitoringTree(connection, new ObjectName("com.sun.appserv:type=http-service,category=monitor,server=server"));
        MonitorTreeCrawler.crawlMonitoringTree(connection, new ObjectName("com.sun.appserv:type=jvm,category=monitor,server=server"));
        MonitorTreeCrawler.crawlMonitoringTree(connection, new ObjectName("com.sun.appserv:type=orb,category=monitor,server=server"));
        MonitorTreeCrawler.crawlMonitoringTree(connection, new ObjectName("com.sun.appserv:type=thread-pools,category=monitor,server=server"));
        MonitorTreeCrawler.crawlMonitoringTree(connection, new ObjectName("com.sun.appserv:type=transaction-service,category=monitor,server=server"));
        MonitorTreeCrawler.crawlMonitoringTree(connection, new ObjectName("com.sun.appserv:type=resources,category=monitor,server=server"));
        MonitorTreeCrawler.crawlMonitoringTree(connection, new ObjectName("com.sun.appserv:type=applications,category=monitor,server=server"));
    }

    public static void crawlMonitoringTree(MBeanServerConnection connection, ObjectName objectName) throws Exception {
        System.out.println("Getting Stats for" + objectName);
        MonitorTreeCrawler.getStats(connection, objectName);
        System.out.println("== End of Stats for == " + objectName);
        MBeanInfo mbeanInfo = connection.getMBeanInfo(objectName);
        MBeanOperationInfo[] operations = mbeanInfo.getOperations();
        for (int j = 0; j < operations.length; ++j) {
            if (!operations[j].getName().equals("getChildren")) continue;
            System.out.println("Getting Children of : " + objectName);
            ObjectName[] children = (ObjectName[])connection.invoke(objectName, "getChildren", null, null);
            System.out.println("Number of Children of = " + children.length);
            for (int i = 0; i < children.length; ++i) {
                System.out.println("Child : " + children[i]);
            }
            for (int c = 0; c < children.length; ++c) {
                MonitorTreeCrawler.crawlMonitoringTree(connection, children[c]);
            }
            System.out.println("==============");
            break;
        }
    }

    public static void getStats(MBeanServerConnection connection, ObjectName name) throws Exception {
        Statistic[] stats = (Statistic[])connection.invoke(name, "getStatistics", null, null);
        if (stats != null) {
            System.out.println("Number of stats = " + stats.length);
            for (int k = 0; k < stats.length; ++k) {
                Statistic stat = stats[k];
                System.out.println(stat.getName());
            }
        }
    }
}

