/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mfwk.agent.appserv.relation;

import com.sun.mfwk.agent.appserv.connection.ConnectionRegistry;
import com.sun.mfwk.agent.appserv.logging.LogDomains;
import com.sun.mfwk.agent.appserv.modeler.ObjectNameHelper;
import com.sun.mfwk.agent.appserv.relation.RelationFactory;
import com.sun.mfwk.agent.appserv.relation.RelationMappingHandler;
import com.sun.mfwk.agent.appserv.relation.RelationMappingService;
import com.sun.mfwk.agent.appserv.relation.RelationModeler;
import com.sun.mfwk.agent.appserv.util.Utils;
import com.sun.mfwk.relations.Relation;
import com.sun.mfwk.relations.RelationServiceImpl;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.w3c.dom.Element;

public class BeanHandler
implements RelationMappingHandler {
    public void relationHandler(Element elem, ObjectName ON, RelationMappingService rms, RelationModeler rm) throws Exception {
        String beanType;
        block15: {
            Logger logger = LogDomains.getLogger();
            beanType = null;
            String AS_AppObjectNameTemplate = "com.sun.appserv:application=${application},category=monitor,ejb-module=${ejb-module},name=${ejb},server=${server},type=ejb";
            String AS_StandAloneObjectNameTemplate = "com.sun.appserv:category=monitor,name=${name},server=${server},standalone-ejb-module=${standalone-ejb-module},type=ejb";
            Utils.log(Level.FINEST, " RelationHandler ON = " + ON);
            try {
                String AS_ObjectNameTemplate = AS_StandAloneObjectNameTemplate;
                try {
                    String application = ON.getKeyProperty("application");
                    AS_ObjectNameTemplate = AS_AppObjectNameTemplate;
                }
                catch (Exception ex) {
                    // empty catch block
                }
                String AS_ObjectNameStr = ObjectNameHelper.tokenizeON(ON, AS_ObjectNameTemplate, rm.getContext().getTokens());
                Utils.log(Level.FINEST, " AS Template = " + AS_ObjectNameTemplate);
                Utils.log(Level.FINEST, " AS ObjecName = " + AS_ObjectNameStr);
                ObjectName AS_ObjectName = new ObjectName(AS_ObjectNameStr);
                String server = (String)rms.getProperty("server.name");
                String domain = (String)rms.getProperty("domain.name");
                ConnectionRegistry registry = ConnectionRegistry.getInstance();
                MBeanServerConnection connection = registry.getConnection(server, domain);
                beanType = (String)connection.invoke(AS_ObjectName, "getType", null, null);
                Utils.log(Level.FINE, " beantype = " + beanType);
            }
            catch (MalformedObjectNameException exception) {
                if (logger != null) {
                    logger.log(Level.WARNING, "Error while constructing ObjectName", exception);
                }
            }
            catch (Exception exception) {
                if (logger == null) break block15;
                logger.log(Level.WARNING, "Error - Not able to get the bean type", exception);
            }
        }
        String CMMBeanType = null;
        if ("stateless-session-bean".equals(beanType)) {
            CMMBeanType = "CMM_J2eeStatelessSessionBean";
        } else if ("stateful-session-bean".equals(beanType)) {
            CMMBeanType = "CMM_J2eeStatefulSessionBean";
        } else if ("entity-bean".equals(beanType)) {
            CMMBeanType = "CMM_J2eeEntityBean";
        } else if ("message-driven-bean".equals(beanType)) {
            CMMBeanType = "CMM_J2eeMessageDrivenBean";
        }
        if (CMMBeanType == null) {
            throw new Exception("cannot handle type " + beanType);
        }
        String CMM_ObjectNameTemplate = "com.sun.cmm.as:application=${application},name=${name},type=" + CMMBeanType + ",ejb-module=${ejb-module},domain=${domain.name},server=${server.name}";
        String CMM_ObjectNameStr = ObjectNameHelper.tokenizeON(ON, CMM_ObjectNameTemplate, rm.getContext().getTokens());
        Utils.log(Level.FINEST, " RelationHandler CMM ON = " + CMM_ObjectNameStr);
        RelationFactory rf = new RelationFactory(rm.getContext());
        Relation relation = rf.create(CMM_ObjectNameStr, ON.toString(), rms.getType(elem));
        if (relation != null) {
            Utils.log(Level.FINEST, " Created Relation = " + relation);
            RelationServiceImpl.getRelationService().addRelation(relation);
        }
    }
}

