/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mfwk.agent.appserv.relation;

import com.sun.mfwk.agent.appserv.modeler.ObjectNameHelper;
import com.sun.mfwk.agent.appserv.relation.RelationMappingService;
import com.sun.mfwk.agent.appserv.util.Utils;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

class RelationMappingServiceImpl
implements RelationMappingService {
    private Map env = new HashMap();
    private Document doc = null;
    private NodeList relations = null;
    private static final String RELATION_DESCRIPTOR = "relation";
    private static final String TYPE = "type";
    private static final String NAME = "name";
    private static final String SOURCE = "source";
    private static final String DESTINATION = "destination";
    private static final String HANDLER = "handler-class";
    private static final String CREATE_ANYWAY = "create-anyway";

    public RelationMappingServiceImpl(String server, String domain) throws IOException {
        this("cmm-relation-descriptors.xml", "/opt/SUNWmfwk/lib/", server, domain);
    }

    RelationMappingServiceImpl(String uri, String dLocation, String server, String domain) throws IOException {
        this.env.put("server.name", server);
        this.env.put("domain.name", domain);
        this.doc = Utils.getDocument(uri, dLocation);
        if (this.doc == null) {
            throw new IOException("Unable to read relation xml file for uri :" + uri + " location = " + dLocation);
        }
    }

    public Object getProperty(String key) {
        return this.env.get(key);
    }

    public NodeList getRelations() {
        if (this.relations == null) {
            this.relations = this.doc.getElementsByTagName(RELATION_DESCRIPTOR);
        }
        return this.relations;
    }

    public Collection getRelations(String CMM_ObjectName) {
        Set filteredList = this.filter(this.getRelations(), CMM_ObjectName, SOURCE);
        return this.filter(this.getRelations(), CMM_ObjectName, DESTINATION, filteredList);
    }

    public Collection getSourceRelations(String CMM_ObjectName) {
        return this.filter(this.getRelations(), CMM_ObjectName, SOURCE);
    }

    public Collection getDestinationRelations(String CMM_ObjectName) {
        return this.filter(this.getRelations(), CMM_ObjectName, DESTINATION);
    }

    public String getSource(Element relation) {
        return relation.getAttribute(SOURCE);
    }

    public String getDestination(Element relation) {
        return relation.getAttribute(DESTINATION);
    }

    public String getType(Element relation) {
        return relation.getAttribute(TYPE);
    }

    public String getHandler(Element relation) {
        return relation.getAttribute(HANDLER);
    }

    public boolean getCreateAnyway(Element relation) {
        return Boolean.getBoolean(relation.getAttribute(CREATE_ANYWAY));
    }

    private Set filter(NodeList nodes, String CMM_ObjectName, String attrName) {
        return this.filter(nodes, CMM_ObjectName, attrName, new HashSet());
    }

    private Set filter(NodeList nodes, String CMM_ObjectName, String attrName, Set filteredList) {
        String type = Utils.getStringRegion(CMM_ObjectName, "type=", ",");
        String primary = Utils.getStringRegion(CMM_ObjectName, "primary=", ",");
        String name = Utils.getStringRegion(CMM_ObjectName, "name=", ",");
        Map map = ObjectNameHelper.getKeysAndProperties(CMM_ObjectName);
        if (type != null) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                String xmlName;
                Element elem = (Element)nodes.item(i);
                String xmlObjectName = elem.getAttribute(attrName);
                String xmlType = Utils.getStringRegion(xmlObjectName, "type=", ",");
                if (!type.equals(xmlType)) continue;
                if ("CMM_Capabilities".equals(type)) {
                    String xmlPrimary = Utils.getStringRegion(xmlObjectName, "primary=", ",");
                    if (xmlPrimary == null || !xmlPrimary.equals(primary)) {
                        continue;
                    }
                } else if ("CMM_Service".equals(type) && ((xmlName = Utils.getStringRegion(xmlObjectName, "name=", ",")) == null || (!"http-service".equals(name) && !"transaction-service".equals(name) ? "http-service".equals(xmlName) || "transaction-service".equals(xmlName) : !xmlName.equals(name)))) continue;
                if (!ObjectNameHelper.keysMatch(map, xmlObjectName)) continue;
                Utils.log(Level.FINEST, "cmmObjectName = " + CMM_ObjectName + " xmlObjectName = " + xmlObjectName + " elem = " + elem.getAttribute(attrName) + " type = " + type + " attrName = " + attrName);
                filteredList.add(elem);
            }
        }
        return filteredList;
    }
}

