/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mfwk.agent.appserv.relation;

import com.sun.mfwk.agent.appserv.discovery.CMMMBeanDiscoveryService;
import com.sun.mfwk.agent.appserv.discovery.CMMMBeanDiscoveryServiceFactory;
import com.sun.mfwk.agent.appserv.logging.LogDomains;
import com.sun.mfwk.agent.appserv.modeler.ModelerContext;
import com.sun.mfwk.agent.appserv.modeler.ObjectNameHelper;
import com.sun.mfwk.agent.appserv.relation.RelationFactory;
import com.sun.mfwk.agent.appserv.relation.RelationMappingHandler;
import com.sun.mfwk.agent.appserv.relation.RelationMappingService;
import com.sun.mfwk.agent.appserv.relation.RelationMappingServiceFactory;
import com.sun.mfwk.agent.appserv.util.Utils;
import com.sun.mfwk.relations.InvalidRelationIdException;
import com.sun.mfwk.relations.Relation;
import com.sun.mfwk.relations.RelationServiceImpl;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.w3c.dom.Element;

public class RelationModeler {
    private ModelerContext _context;
    private String DESTINATION = "dest";
    private String SOURCE = "source";

    public RelationModeler(ModelerContext ctx) {
        this._context = ctx;
    }

    public ModelerContext getContext() {
        return this._context;
    }

    public void load(String serverName) throws Exception {
        CMMMBeanDiscoveryService cmmDiscoveryService = CMMMBeanDiscoveryServiceFactory.getInstance().getCMMMBeanDiscoveryService();
        String domainName = this._context.getDomainName();
        Set cmmMBeans = cmmDiscoveryService.discoverCMMMBeans(serverName, domainName);
        cmmMBeans.addAll(cmmDiscoveryService.discoverClusterCMMMBeans());
        cmmMBeans.addAll(cmmDiscoveryService.discoverInstalledProductCMMMBeans());
        this.load(cmmMBeans);
    }

    public void load(Set cmmMBeans) throws Exception {
        Iterator iter = cmmMBeans.iterator();
        while (iter.hasNext()) {
            this.load((ObjectName)iter.next());
        }
    }

    public void load(ObjectName cmmObjectName) throws Exception {
        RelationMappingServiceFactory fac = RelationMappingServiceFactory.getInstance();
        RelationMappingService relationService = fac.getRelationMappingService(this._context.getServerName(), this._context.getDomainName());
        Utils.log(Level.FINEST, "cmmObjectName = " + cmmObjectName);
        this.load(cmmObjectName, relationService.getDestinationRelations(cmmObjectName.toString()), this.DESTINATION, relationService);
        this.load(cmmObjectName, relationService.getSourceRelations(cmmObjectName.toString()), this.SOURCE, relationService);
    }

    private void load(ObjectName cmmObjectName, Collection relations, String type, RelationMappingService relationService) throws Exception {
        RelationFactory rf = new RelationFactory(this._context);
        String cmmObjectNameStr = cmmObjectName.toString();
        for (Element r : relations) {
            try {
                String template;
                String handler = relationService.getHandler(r);
                if ("".equals(handler)) {
                    handler = null;
                }
                if (handler != null) {
                    this.callHandler(r, cmmObjectName, relationService);
                    continue;
                }
                String source = null;
                String dest = null;
                if (this.DESTINATION.equals(type)) {
                    dest = cmmObjectNameStr;
                    template = relationService.getSource(r);
                    try {
                        source = ObjectNameHelper.tokenizeON(cmmObjectName, template, this._context.getTokens());
                        Utils.log(Level.FINEST, "IN DEST Template = " + template);
                        Utils.log(Level.FINEST, "IN DEST dest = " + dest);
                    }
                    catch (NoSuchFieldException e) {
                        continue;
                    }
                }
                if (this.SOURCE.equals(type)) {
                    source = cmmObjectNameStr;
                    template = relationService.getDestination(r);
                    try {
                        dest = ObjectNameHelper.tokenizeON(cmmObjectName, template, this._context.getTokens());
                        Utils.log(Level.FINEST, "IN SOURCE Template = " + template);
                    }
                    catch (NoSuchFieldException e) {
                        continue;
                    }
                }
                if (this.isProcessed(source, dest, relationService.getType(r))) continue;
                Utils.log(Level.FINE, "Creating relations for dest = " + dest + " source = " + source);
                Relation relation = rf.create(source, dest, relationService.getType(r), relationService.getCreateAnyway(r));
                if (relation == null) continue;
                RelationServiceImpl.getRelationService().addRelation(relation);
            }
            catch (Exception e) {
                LogDomains.getLogger().log(Level.SEVERE, "Error while instrumenting relation", e);
            }
        }
    }

    private boolean isProcessed(String source, String dest, String type) {
        Relation[] relations = RelationServiceImpl.getRelationService().getRelations(source, type, true);
        for (int i = 0; i < relations.length; ++i) {
            if (!dest.equals(relations[i].getDestinationInstanceID())) continue;
            return true;
        }
        return false;
    }

    private void callHandler(Element elem, ObjectName ON, RelationMappingService relationService) {
        try {
            Class<?> handlerClass = Class.forName(relationService.getHandler(elem));
            RelationMappingHandler handler = (RelationMappingHandler)handlerClass.newInstance();
            handler.relationHandler(elem, ON, relationService, this);
        }
        catch (Exception ex) {
            throw new RuntimeException("Error calling user defined handler", ex);
        }
    }

    public void removeRelations(String CMM_MBean2) {
        RelationServiceImpl relationService = RelationServiceImpl.getRelationService();
        Relation[] activeRelations = relationService.listRelations();
        for (int i = 0; i < activeRelations.length; ++i) {
            Relation relation = activeRelations[i];
            try {
                if (!ObjectName.getInstance(relation.getDestinationInstanceID()).equals(ObjectName.getInstance(CMM_MBean2)) && !ObjectName.getInstance(relation.getSourceInstanceID()).equals(ObjectName.getInstance(CMM_MBean2))) continue;
                try {
                    relationService.removeRelation(relation);
                }
                catch (InvalidRelationIdException ex) {
                    LogDomains.getLogger().log(Level.SEVERE, "Error removing relation", ex);
                }
                continue;
            }
            catch (MalformedObjectNameException ex) {
                LogDomains.getLogger().log(Level.SEVERE, "Error forming ObjectName", ex);
            }
        }
    }
}

