/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.ee.sfsb.store;

import com.sun.ejb.Container;
import com.sun.ejb.base.sfsb.util.EJBServerConfigLookup;
import com.sun.ejb.ee.sfsb.store.EJBModuleStatistics;
import com.sun.ejb.spi.sfsb.store.SFSBBeanState;
import com.sun.ejb.spi.sfsb.store.SFSBStoreManager;
import com.sun.ejb.spi.sfsb.store.SFSBStoreManagerException;
import com.sun.enterprise.web.ServerConfigLookup;
import com.sun.enterprise.web.ShutdownCleanupCapable;
import com.sun.logging.LogDomains;
import java.sql.Connection;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class BaseSFSBStoreManager
implements SFSBStoreManager,
ShutdownCleanupCapable {
    protected Container container = null;
    protected long containerID;
    protected String clusterID = null;
    protected int idleTimeoutInSeconds;
    protected String containerId = null;
    protected EJBModuleStatistics _statistics = new EJBModuleStatistics();
    protected static final Logger _logger = LogDomains.getLogger((String)"javax.enterprise.system.container.ejb");
    protected boolean debug = false;

    public void initSessionStore(Map storeEnv) throws SFSBStoreManagerException {
        if (storeEnv.get("clusterId") != null) {
            String clusId;
            this.clusterID = clusId = (String)storeEnv.get("clusterId");
        }
        if (storeEnv.get("containerId") != null) {
            long contId;
            Long contIdLong = (Long)storeEnv.get("containerId");
            this.containerID = contId = contIdLong.longValue();
        }
        if (storeEnv.get("idleTimeoutInSeconds") != null) {
            int timeout;
            Integer timeoutInt = (Integer)storeEnv.get("idleTimeoutInSeconds");
            this.idleTimeoutInSeconds = timeout = timeoutInt.intValue();
        }
    }

    public void initSessionStore(String clusterId, long containerId, int idleTimeoutInSeconds) {
        if (_logger.isLoggable(Level.FINER)) {
            _logger.entering("BaseSFSBStoreManager", "initSessionStore", new Object[]{clusterId, new Long(containerId), new Integer(idleTimeoutInSeconds)});
        }
        this.clusterID = clusterId;
        this.containerID = containerId;
        this.idleTimeoutInSeconds = idleTimeoutInSeconds;
        if (_logger.isLoggable(Level.FINER)) {
            _logger.exiting("HASFSBStoreManager", "initSessionStore");
        }
    }

    public SFSBBeanState createSFSBBeanState(Object sessionId, long lastAccess, boolean isNew, byte[] state) {
        return new SFSBBeanState(this.getClusterID(), this.containerID, sessionId, lastAccess, isNew, state, (SFSBStoreManager)this);
    }

    public void setContainer(Container ejbContainer) {
        this.container = ejbContainer;
    }

    public Container getContainer() {
        return this.container;
    }

    public String getContainerID() {
        Long longContId = new Long(this.containerID);
        return longContId.toString();
    }

    public String getClusterID() {
        if (this.clusterID == null || this.clusterID.equals("")) {
            ServerConfigLookup lookup = new ServerConfigLookup();
            this.clusterID = lookup.getClusterIdFromConfig();
        }
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "Cluster Id in BaseSFSBStoreManager.getClusterID=" + this.clusterID);
        }
        return this.clusterID;
    }

    public int getIdleTimeoutInSeconds() {
        return this.idleTimeoutInSeconds;
    }

    public EJBModuleStatistics getEJBModuleStatistics() {
        return this._statistics;
    }

    protected boolean isMonitoringEnabled() {
        return EJBServerConfigLookup.isMonitoringEnabled();
    }

    protected void appendStats(StringBuffer sbuf) {
    }

    public void shutdown() {
    }

    public int doShutdownCleanup() {
        return 0;
    }

    public void doCloseCachedConnection() {
    }

    public void putConnection(Connection conn) {
    }

    public void debug(String s) {
        System.out.println(s);
    }
}

