/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.ee.timer.lifecycle;

import com.sun.appserv.server.ServerLifecycle;
import com.sun.appserv.server.ServerLifecycleException;
import com.sun.ejb.ee.timer.lifecycle.EJBTimerPlannedShutdownActionImpl;
import com.sun.ejb.ee.timer.lifecycle.ReadOnlyBeanMessageActionFactoryImpl;
import com.sun.ejb.spi.distributed.DistributedEJBService;
import com.sun.ejb.spi.distributed.DistributedEJBServiceFactory;
import com.sun.enterprise.admin.server.core.AdminService;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.ClusterHelper;
import com.sun.enterprise.ee.cms.core.Action;
import com.sun.enterprise.ee.cms.core.GMSException;
import com.sun.enterprise.ee.cms.core.GMSFactory;
import com.sun.enterprise.ee.cms.core.GMSNotEnabledException;
import com.sun.enterprise.ee.cms.core.GMSNotInitializedException;
import com.sun.enterprise.ee.cms.core.GroupManagementService;
import com.sun.enterprise.ee.cms.core.MessageActionFactory;
import com.sun.enterprise.ee.cms.core.PlannedShutdownActionFactory;
import com.sun.enterprise.server.ServerContext;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EJBLifecycleImpl
implements ServerLifecycle {
    protected static final Logger _logger = LogDomains.getLogger((String)"javax.enterprise.system.container.ejb");
    private static final String GMS_READ_ONLY_COMPONENT_NAME = "__GMS__READ_ONLY_BEAN__";
    private GroupManagementService gms;

    public void onInitialization(ServerContext serverContext) throws ServerLifecycleException {
    }

    public void onStartup(ServerContext serverContext) throws ServerLifecycleException {
    }

    public void onReady(ServerContext serverContext) throws ServerLifecycleException {
        String timerMigrationNotEnabled = "EJBLifeCycle: Automatic  timer migration component not enabled  for standalone server instance";
        String timerMigrationNotEnabledForDAS = "EJBLifeCycle: Automatic  timer migration component not enabled  for DAS instance";
        try {
            block13: {
                AdminService adminService = AdminService.getAdminService();
                if (adminService != null && !adminService.isDas()) {
                    try {
                        Cluster cluster = ClusterHelper.getClusterForInstance((ConfigContext)serverContext.getConfigContext(), (String)serverContext.getInstanceName());
                        if (cluster != null) {
                            try {
                                this.gms = GMSFactory.getGMSModule((String)cluster.getName());
                                _logger.log(Level.INFO, "EJBLifecycle: Got GMS module for: " + cluster.getName());
                            }
                            catch (GMSNotEnabledException gmsNotEnabledEx) {
                                _logger.log(Level.FINE, "EJBLifeCycle: GMS *NOT* Enabled.", gmsNotEnabledEx);
                            }
                            catch (GMSNotInitializedException gmsNotInitializedEx) {
                                _logger.log(Level.SEVERE, "EJBLifeCycle: GMS *NOT* Initialized", gmsNotInitializedEx);
                            }
                            catch (GMSException gmsEx) {
                                _logger.log(Level.SEVERE, "EJBLifeCycle: Could not get GMS module", gmsEx);
                            }
                            break block13;
                        }
                        _logger.log(Level.FINE, "EJBLifeCycle: Automatic  timer migration component not enabled  for standalone server instance");
                    }
                    catch (ConfigException configEx) {
                        _logger.log(Level.FINE, "EJBLifeCycle: Automatic  timer migration component not enabled  for standalone server instance", configEx);
                    }
                    catch (Exception ex) {
                        _logger.log(Level.SEVERE, "EJBLifecycle: Exception getting GMS module", ex);
                    }
                } else {
                    _logger.log(Level.WARNING, "EJBLifeCycle: Automatic  timer migration component not enabled  for DAS instance");
                }
            }
            if (this.gms != null) {
                this.registerEJBTimerComponents();
                this.registerReadOnlyBeanComponents();
            }
        }
        catch (Exception ex) {
            _logger.log(Level.SEVERE, "EJBLifecycle: Exception during registration of listeners", ex);
        }
    }

    public void onShutdown() throws ServerLifecycleException {
    }

    public void onTermination() throws ServerLifecycleException {
    }

    private void registerEJBTimerComponents() {
        this.gms.addActionFactory(new PlannedShutdownActionFactory(){

            public Action produceAction() {
                return new EJBTimerPlannedShutdownActionImpl();
            }
        });
        _logger.log(Level.FINE, "EJBLifecycle: Registered PlannedShutdownNotification...");
        DistributedEJBService distributedEJBService = DistributedEJBServiceFactory.getDistributedEJBService();
        distributedEJBService.setPerformDBReadBeforeTimeout(true);
    }

    private void registerReadOnlyBeanComponents() {
        if (this.gms != null) {
            this.gms.addActionFactory((MessageActionFactory)new ReadOnlyBeanMessageActionFactoryImpl(this.gms, GMS_READ_ONLY_COMPONENT_NAME), GMS_READ_ONLY_COMPONENT_NAME);
            _logger.log(Level.FINE, "EJBLifecycle: Registered ReadOnlyBeanMessageActionFactory...");
        }
    }
}

