/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.hadbmgmt;

import com.sun.enterprise.ee.admin.hadbmgmt.HADBInfo;
import com.sun.enterprise.ee.admin.hadbmgmt.HADBMExecutor;
import com.sun.enterprise.ee.admin.hadbmgmt.HADBSetupException;
import com.sun.enterprise.ee.admin.hadbmgmt.HADBUtils;
import com.sun.enterprise.ee.admin.hadbmgmt.LoggerHelper;
import com.sun.enterprise.ee.admin.hadbmgmt.StringHelper;

public class HADBStopDB {
    private HADBInfo info;

    public HADBStopDB(HADBInfo info) {
        this.info = info;
    }

    public Object[] stopDB() throws HADBSetupException {
        HADBUtils.setPhonyReturnValue(0);
        String[] commands = this.info.getStopCommands();
        HADBMExecutor exec = new HADBMExecutor(this.info.getExecutable(), commands);
        int exitValue = exec.exec();
        if (exitValue != 0) {
            if (exec.isHadbmError(22102)) {
                throw new HADBSetupException("hadbmgmt-res.AlreadyStopped", this.info.getClusterName());
            }
            throw new HADBSetupException("hadbmgmt-res.StopFailed", new Object[]{this.info.getClusterName(), "" + exitValue, exec.getStdout(), exec.getStderr()});
        }
        String s = StringHelper.get("hadbmgmt-res.StopSucceeded", this.info.getClusterName());
        LoggerHelper.fine(s);
        this.info.addMsg(s);
        return this.info.prepMsgs();
    }
}

