/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.hadbmgmt;

import com.sun.enterprise.ee.admin.hadbmgmt.HADBInfo;
import com.sun.enterprise.ee.admin.hadbmgmt.HADBSetupException;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.net.InetAddress;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HADBUtils {
    private static final boolean NO_HADB;
    private static final boolean NO_DELETE;
    private static final boolean NATIVE_SCHEMA;
    private static final boolean USE_IP_ONLY;
    private static int phonyReturnValue;
    private static final boolean PING_WITH_JMX;
    private static final String LOOPBACK = "127.0.0.1";
    static final String[] validCreateAttributes;

    private HADBUtils() {
    }

    static int waitForProcess(Process p, int msec) {
        int ret = 1;
        try {
            ProcessWaiter pt = new ProcessWaiter(p);
            Thread t = new Thread((Runnable)pt, "ProcessWaiter");
            t.start();
            t.join(msec);
            ret = pt.ret;
            if (t.isAlive()) {
                p.destroy();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    static boolean useIP() {
        return USE_IP_ONLY;
    }

    static boolean nativeSchema() {
        return NATIVE_SCHEMA;
    }

    static boolean noDelete() {
        return NO_DELETE;
    }

    static boolean noHADB() {
        return NO_HADB;
    }

    static boolean yesHADB() {
        return !NO_HADB;
    }

    static int getPhonyReturnValue() {
        return phonyReturnValue;
    }

    static void setPhonyReturnValue(int i) {
        phonyReturnValue = i;
    }

    static boolean pingWithJMX() {
        return PING_WITH_JMX;
    }

    static String getIP(String host) throws HADBSetupException {
        try {
            InetAddress add = InetAddress.getByName(host);
            String ip = add.getHostAddress();
            if (ip.equals(LOOPBACK)) {
                add = InetAddress.getLocalHost();
                ip = add.getHostAddress();
            }
            if (ip.equals(LOOPBACK)) {
                throw new HADBSetupException("hadbmgmt-res.BadHostNameGotLoopback");
            }
            return add.getHostAddress();
        }
        catch (Exception e) {
            throw new HADBSetupException("hadbmgmt-res.BadHostName", host);
        }
    }

    static File getPasswordFileDir(HADBInfo info) throws HADBSetupException {
        File f = null;
        String s = System.getProperty("com.sun.aas.instanceRoot") + "/config";
        try {
            f = new File(s);
            if (FileUtils.safeIsDirectory((File)f) && f.canWrite()) {
                return f;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new HADBSetupException("hadbmgmt-res.NoPasswordWritePermission", new Object[]{"com.sun.aas.domainsRoot", s});
    }

    static Hashtable<String, String> props2hash(Properties props) {
        Hashtable<String, String> ht = new Hashtable<String, String>();
        if (props == null) {
            return null;
        }
        if (props.size() <= 0) {
            return ht;
        }
        Set<Map.Entry<Object, Object>> set = props.entrySet();
        for (Map.Entry<Object, Object> entry : set) {
            String key = ((String)entry.getKey()).toLowerCase();
            String value = (String)entry.getValue();
            ht.put(key, value);
        }
        return ht;
    }

    static {
        phonyReturnValue = 0;
        String prop = System.getProperty("hadbnohadb");
        NO_HADB = prop != null && prop.equals("true");
        prop = System.getProperty("hadbmnodeletepasswordfile", "false");
        NO_DELETE = prop != null && prop.equals("true");
        prop = System.getProperty("hadbnativeschema", "false");
        NATIVE_SCHEMA = prop == null || !prop.equals("false");
        prop = System.getProperty("hadbusehostname", "false");
        USE_IP_ONLY = prop == null || !prop.equals("true");
        prop = System.getProperty("hadbpingwithjmx", "false");
        PING_WITH_JMX = prop != null && prop.equals("true");
        validCreateAttributes = new String[]{"ConnectionTrace", "CoreFile", "DataBufferPoolSize", "DataDeviceSize", "DevicePath", "EagerSessionThreshold", "EagerSessionTimeout", "EventBufferSize", "HistoryPath", "InternalLogBufferSize", "LogBufferSize", "MaxTables", "NumberOfDatadevices", "NumberOfLocks", "NumberOfSessions", "PortBase", "RelalgDeviceSize", "SQLTraceMode", "SessionTimeout", "StartRepairDelay", "StatInterval", "SyslogFacility", "SyslogLevel", "SyslogPrefix", "TakeoverTime"};
    }

    private static class ProcessWaiter
    implements Runnable {
        Process p;
        int ret = 1;

        ProcessWaiter(Process p) {
            this.p = p;
        }

        public void run() {
            try {
                this.ret = this.p.waitFor();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

