/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.mbeans;

import com.sun.enterprise.admin.common.JMXFileTransfer;
import com.sun.enterprise.admin.common.ObjectNames;
import com.sun.enterprise.admin.event.AdminEventListenerException;
import com.sun.enterprise.admin.event.MBeanElementChangeEvent;
import com.sun.enterprise.admin.event.MBeanElementChangeEventListener;
import com.sun.enterprise.admin.mbeans.custom.CMBStrings;
import com.sun.enterprise.admin.mbeans.custom.InProcessMBeanElementChangeEventListenerImpl;
import com.sun.enterprise.config.ConfigAdd;
import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.serverbeans.Mbean;
import com.sun.enterprise.ee.admin.clientreg.InstanceRegistry;
import java.io.File;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

public class RemoteMBeanElementChangeEventListenerImpl
extends InProcessMBeanElementChangeEventListenerImpl
implements MBeanElementChangeEventListener {
    final Logger logger = Logger.getLogger("javax.enterprise.system.tools.admin");

    public void handleUpdate(MBeanElementChangeEvent event) throws AdminEventListenerException {
        Object[] objectArray = new Object[2];
        objectArray[0] = event.getElementId();
        objectArray[1] = MBeanElementChangeEvent.EVENT_TYPE;
        this.logger.info(CMBStrings.get((String)"cmb.ee.handleUpdate", (Object[])objectArray));
        super.handleUpdate(event);
    }

    public void handleDelete(MBeanElementChangeEvent event) throws AdminEventListenerException {
        Object[] objectArray = new Object[2];
        objectArray[0] = event.getElementId();
        objectArray[1] = MBeanElementChangeEvent.EVENT_TYPE;
        this.logger.info(CMBStrings.get((String)"cmb.ee.handleDelete", (Object[])objectArray));
        super.handleDelete(event);
    }

    public void handleCreate(MBeanElementChangeEvent event) throws AdminEventListenerException {
        Object[] objectArray = new Object[2];
        objectArray[0] = event.getElementId();
        objectArray[1] = MBeanElementChangeEvent.EVENT_TYPE;
        this.logger.info(CMBStrings.get((String)"cmb.ee.handleCreate", (Object[])objectArray));
        try {
            this.synchronizeMBeanClasses(event);
        }
        catch (Exception e) {
            throw new AdminEventListenerException((Throwable)e);
        }
        super.handleCreate(event);
    }

    private void synchronizeMBeanClasses(MBeanElementChangeEvent event) throws Exception {
        ArrayList list = event.getConfigChangeList();
        ConfigContext rcc = event.getConfigContext();
        for (ConfigAdd added : list) {
            ConfigBean co;
            String xp = added.getXPath();
            if (xp == null || !((co = rcc.exactLookup(xp)) instanceof Mbean)) continue;
            Mbean am = (Mbean)co;
            String icn = am.getImplClassName();
            this.synchronizeClass(icn, rcc);
        }
    }

    private void synchronizeClass(String c, ConfigContext rcc) throws Exception {
        MBeanServerConnection mbsc = InstanceRegistry.getDASConnection(rcc);
        String remLoc = this.getAbsoluteDASMBeanClassLocation(mbsc, c);
        String locLoc = this.getAbsoluteLocalClassFolder(c);
        JMXFileTransfer ftp = new JMXFileTransfer(mbsc);
        File destPath = new File(locLoc);
        if (!destPath.exists()) {
            boolean touched = destPath.mkdirs();
            String msg = touched ? CMBStrings.get((String)"cmb.ee.mkdirGood", (Object[])new Object[]{destPath}) : CMBStrings.get((String)"cmb.ee.mkdirBad", (Object[])new Object[]{destPath});
            this.logger.info(msg);
        }
        ftp.downloadFile(remLoc, locLoc);
        this.logger.info(CMBStrings.get((String)"cmb.ee.downloadClass", (Object[])new Object[]{locLoc}));
        String sbiRemLoc = remLoc.substring(0, remLoc.lastIndexOf(".class")) + "MBean.class";
        try {
            ftp.downloadFile(sbiRemLoc, locLoc);
            this.logger.info(CMBStrings.get((String)"cmb.ee.downloadInterfaceGood", (Object[])new Object[]{sbiRemLoc}));
        }
        catch (Exception e) {
            this.logger.info(CMBStrings.get((String)"cmb.ee.downloadInterfaceBad"));
        }
    }

    private String getAbsoluteDASMBeanClassLocation(MBeanServerConnection mbsc, String cn) throws Exception {
        String dasName = "server";
        String instanceRootPropertyName = "com.sun.aas.instanceRoot";
        ObjectName remSSMBeanON = ObjectNames.getPerInstanceSystemServicesObjectName((String)"server");
        String m = "getHostServerSystemPropertyValue";
        Object[] p = new String[]{"com.sun.aas.instanceRoot"};
        String[] s = new String[]{"java.lang.String"};
        String remoteInstanceRoot = (String)mbsc.invoke(remSSMBeanON, "getHostServerSystemPropertyValue", p, s);
        this.logger.info(CMBStrings.get((String)"cmb.ee.instanceRoot", (Object[])new Object[]{remoteInstanceRoot}));
        String remoteMBeansLocation = remoteInstanceRoot + "/applications/mbeans/";
        this.logger.info(CMBStrings.get((String)"cmb.ee.remoteLocation", (Object[])new Object[]{remoteMBeansLocation}));
        String remoteMBeanPath = remoteMBeansLocation + cn.replace('.', '/') + ".class";
        this.logger.info(CMBStrings.get((String)"cmb.ee.remotePath", (Object[])new Object[]{remoteMBeanPath}));
        return remoteMBeanPath;
    }

    private String getAbsoluteLocalClassFolder(String c) throws Exception {
        String localMBeansLocation = System.getProperty("com.sun.aas.instanceRoot") + "/applications/mbeans/";
        String localDestinationPath = localMBeansLocation + this.cn2dn(c);
        this.logger.info(CMBStrings.get((String)"cmb.ee.copyLocation", (Object[])new Object[]{localDestinationPath}));
        return localDestinationPath;
    }

    private String cn2dn(String fc) throws Exception {
        String p = "";
        String c = fc;
        if (c.indexOf(".class") != -1) {
            c = c.substring(0, c.lastIndexOf(".class"));
        }
        if (c.indexOf(46) != -1) {
            p = c.substring(0, c.lastIndexOf(46));
            p = p.replace('.', '/');
        }
        return p;
    }
}

