/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.cli.commands;

import com.sun.enterprise.cli.commands.S1ASCommand;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.enterprise.deployment.backend.DeploymentStatus;
import com.sun.enterprise.deployment.client.DeploymentFacility;
import com.sun.enterprise.deployment.client.DeploymentFacilityFactory;
import com.sun.enterprise.deployment.client.JESProgressObject;
import com.sun.enterprise.deployment.client.ServerConnectionIdentifier;
import com.sun.enterprise.ee.cli.commands.ListApplicationReferenceCommand;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.Map;
import java.util.Properties;
import javax.enterprise.deploy.spi.Target;

public class CreateApplicationReferenceCommand
extends S1ASCommand {
    private static final String TARGET_OPTION = "target";
    private static final String ENABLED_OPTION = "enabled";
    private static final String VIRTUALSERVERS_OPTION = "virtualservers";
    private static final StringManager _strMgr = StringManager.getManager(ListApplicationReferenceCommand.class);

    public void runCommand() throws CommandException, CommandValidationException {
        this.validateOptions();
        DeploymentFacility df = DeploymentFacilityFactory.getDeploymentFacility();
        ServerConnectionIdentifier conn = this.createServerConnectionIdentifier(this.getHost(), this.getPort(), this.getUser(), this.getPassword());
        df.connect(conn);
        String targetName = this.getOption(TARGET_OPTION);
        String moduleID = (String)this.getOperands().get(0);
        JESProgressObject progressObject = null;
        try {
            Map props = this.createProperties();
            if (df.isConnected()) {
                Target[] targets = df.createTargets(new String[]{targetName});
                if (targets == null) {
                    throw new CommandException(_strMgr.getString("InvalidTarget", new Object[]{targetName}));
                }
                progressObject = df.createAppRef(targets, moduleID, props);
            } else {
                CLILogger.getInstance().printError(this.getLocalizedString("CouldNotConnectToDAS"));
            }
        }
        catch (Exception e) {
            if (e.getLocalizedMessage() != null) {
                CLILogger.getInstance().printDetailMessage(e.getLocalizedMessage());
            }
            throw new CommandException(this.getLocalizedString("CommandUnSuccessful", new Object[]{this.name}), (Throwable)e);
        }
        DeploymentStatus status = df.waitFor(progressObject);
        String statusString = status.getStageStatusMessage();
        if (status != null && status.getStatus() == 1) {
            CLILogger.getInstance().printDetailMessage(this.getLocalizedString("CommandSuccessfulWithMsg", new Object[]{this.name, statusString}));
        } else {
            if (status != null && status.getStatus() == 0) {
                throw new CommandException(this.getLocalizedString("CommandUnSuccessfulWithMsg", new Object[]{this.name, statusString}));
            }
            CLILogger.getInstance().printDetailMessage(this.getLocalizedString("CommandSuccessful", new Object[]{this.name}));
        }
    }

    private Map createProperties() {
        String enabled = this.getOption(ENABLED_OPTION);
        String virtualServers = this.getOption(VIRTUALSERVERS_OPTION);
        Properties props = new Properties();
        CLILogger.getInstance().printDebugMessage("enable");
        if (props != null) {
            props.put("enable", enabled);
        }
        CLILogger.getInstance().printDebugMessage(VIRTUALSERVERS_OPTION);
        if (props != null && virtualServers != null) {
            props.put(VIRTUALSERVERS_OPTION, virtualServers);
        }
        return props;
    }

    public boolean validateOptions() throws CommandValidationException {
        super.validateOptions();
        return true;
    }
}

