/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.cli.commands;

import com.sun.appserv.management.DomainRoot;
import com.sun.appserv.management.client.ProxyFactory;
import com.sun.appserv.management.helper.LBConfigHelper;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.enterprise.ee.cli.commands.BaseHttpLBCommand;
import javax.management.MBeanServerConnection;

public class DeleteHttpLBRefCommand
extends BaseHttpLBCommand {
    private static final String CONFIG_OPTION = "config";
    private static final String LBNAME_OPTION = "lbname";
    private static final String FORCE_OPTION = "force";

    public void runCommand() throws CommandException, CommandValidationException {
        this.validateOptions();
        String target = (String)this.getOperands().get(0);
        String configName = this.getOption(CONFIG_OPTION);
        String lbName = this.getOption(LBNAME_OPTION);
        boolean force = this.getBooleanOption(FORCE_OPTION);
        this.checkConfigAndLBNameOptions(configName, lbName);
        try {
            MBeanServerConnection mbsc = this.getMBeanServerConnection(this.getHost(), this.getPort(), this.getUser(), this.getPassword());
            DomainRoot domainRoot = ProxyFactory.getInstance((MBeanServerConnection)mbsc).getDomainRoot();
            LBConfigHelper lbconfigHelper = new LBConfigHelper(domainRoot);
            lbconfigHelper.removeLBRef(lbName, configName, target, force);
            CLILogger.getInstance().printDetailMessage(this.getLocalizedString("CommandSuccessful", new Object[]{this.name}));
        }
        catch (Exception e) {
            this.displayExceptionMessage(e);
        }
    }
}

