/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.diagnostics;

import com.sun.enterprise.diagnostics.DiagnosticException;
import com.sun.enterprise.diagnostics.PELocalTargetResolver;
import com.sun.enterprise.diagnostics.TargetType;
import com.sun.enterprise.ee.diagnostics.EEConstants;
import com.sun.enterprise.ee.diagnostics.EEExecutionContext;
import com.sun.enterprise.ee.diagnostics.EETargetType;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EELocalTargetResolver
extends PELocalTargetResolver {
    public EELocalTargetResolver(String target, String repositoryDir, List<String> instances, TargetType type) {
        super(target, repositoryDir, true);
        this.type = type;
        if (instances != null) {
            this.instances = instances;
        }
    }

    public boolean validateTarget() throws DiagnosticException {
        this.determineTargetType(this.repositoryDir, this.target);
        return this.type != null;
    }

    protected void setExecutionContext() {
        this.context = EEExecutionContext.LOCAL_EC;
    }

    protected void determineTargetType(String targetDir, String target) throws DiagnosticException {
        if (this.type == null) {
            if (targetDir != null && target != null) {
                String absoluteDir = targetDir + File.separator + target;
                String agentDir = absoluteDir + EEConstants.AGENT_DIR;
                File agentDirObj = new File(agentDir);
                if (agentDirObj.exists()) {
                    this.setTargetType(EETargetType.NODEAGENT);
                } else {
                    String parentDir = targetDir + File.separator + EEConstants.AGENT_DIR;
                    File parentDirObj = new File(parentDir);
                    if (parentDirObj.exists()) {
                        this.setTargetType(EETargetType.INSTANCE);
                    } else if (super.validateTarget()) {
                        this.setTargetType(TargetType.DAS);
                    }
                }
                return;
            }
            throw new DiagnosticException("Targetdir and targetname are null");
        }
    }

    protected void determineRepositoryDetails() {
        if (this.type.equals((Object)EETargetType.INSTANCE)) {
            if (this.repositoryDir.endsWith(File.separator)) {
                this.repositoryDir = this.repositoryDir.substring(0, this.repositoryDir.length() - 1);
            }
            super.determineRepositoryDetails();
        } else {
            super.determineRepositoryDetails();
        }
    }

    protected void determineInstances() {
        if (this.type.equals((Object)EETargetType.NODEAGENT)) {
            String agentDir = this.repositoryDir + File.separator + this.repositoryName;
            File agentDirObj = new File(agentDir);
            this.instances = Arrays.asList(agentDirObj.list(new FilenameFilter(){

                public boolean accept(File aDir, String fileName) {
                    if (aDir != null && fileName != null) {
                        return !fileName.matches("agent") && !fileName.matches("diagnostic-reports") && !fileName.matches("reports_temp");
                    }
                    return false;
                }
            }));
        } else if (this.type.equals((Object)EETargetType.INSTANCE)) {
            this.addInstance(this.target);
        } else if (this.type.equals((Object)EETargetType.DAS)) {
            super.determineInstances();
        }
    }
}

