/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.diagnostics.report.html;

import com.sun.enterprise.admin.server.core.AdminService;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.NodeAgent;
import com.sun.enterprise.config.serverbeans.NodeAgentHelper;
import com.sun.enterprise.config.serverbeans.NodeAgents;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.diagnostics.Data;
import com.sun.enterprise.diagnostics.Defaults;
import com.sun.enterprise.diagnostics.ReportConfig;
import com.sun.enterprise.diagnostics.TargetType;
import com.sun.enterprise.diagnostics.report.html.Element;
import com.sun.enterprise.diagnostics.report.html.HTMLComponent;
import com.sun.enterprise.diagnostics.report.html.HTMLElement;
import com.sun.enterprise.diagnostics.report.html.HTMLReportTemplate;
import com.sun.enterprise.diagnostics.report.html.Link;
import com.sun.enterprise.ee.diagnostics.EEExecutionContext;
import com.sun.enterprise.ee.diagnostics.EETargetType;
import com.sun.logging.LogDomains;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EEHTMLReportTemplate
extends HTMLReportTemplate {
    protected static final String hadb_information = "HADB Information";
    private static final Logger logger = LogDomains.getLogger((String)"javax.enterprise.system.tools.admin");

    public EEHTMLReportTemplate(ReportConfig config, Data dataObj) {
        super(config, dataObj);
    }

    protected void addMiscellaneousInfo() {
        this.addHadbInfo();
    }

    protected void addInstanceSpecificSection(Element element) {
        if (this.config.getExecutionContext().equals((Object)EEExecutionContext.DAS_EC)) {
            if (this.config.getTarget().getType().equals((Object)EETargetType.DOMAIN) || this.config.getTarget().getType().equals((Object)EETargetType.DAS) || this.config.getTarget().getType().equals((Object)EETargetType.CLUSTER)) {
                ArrayList<String> nodeAgents = this.getNodeAgentNames();
                super.addInstanceSpecificSection(element);
                for (String nodeAgentName : nodeAgents) {
                    File file = new File(this.target.getIntermediateReportDir() + File.separator + nodeAgentName);
                    if (!file.exists()) continue;
                    this.addLink(element, "Nodeagent : " + nodeAgentName, nodeAgentName + File.separator + Defaults.REPORT_NAME, 1);
                }
            }
        } else {
            if (this.exists(this.target.getIntermediateReportDir(), "agent")) {
                this.addLink(element, "agent", "." + File.separator + "agent", 1);
            }
            super.addInstanceSpecificSection(element);
        }
    }

    private void addHadbInfo() {
        boolean headerAdded = false;
        if (this.target.getType().equals((Object)EETargetType.CLUSTER) || this.target.getType().equals((Object)EETargetType.DOMAIN)) {
            Iterator iterator = this.dataObjTraverser.getData("hadb info");
            while (iterator.hasNext()) {
                Data data = (Data)iterator.next();
                if (!headerAdded) {
                    this.addTitle(hadb_information, true, true, 0, 0);
                    headerAdded = true;
                }
                Link fileLink = new Link(data.getSource(), data.getSource(), null);
                this.bodyElement.add((HTMLComponent)fileLink);
                this.bodyElement.add((HTMLComponent)new HTMLElement("br"));
            }
        }
    }

    protected void addMonitoringInfo(Element element, String instanceName, int indentation) {
        if (!this.config.getCLIOptions().isLocal()) {
            if (this.config.getExecutionContext().equals((Object)EEExecutionContext.DAS_EC)) {
                if (this.config.getTarget().getType().equals((Object)EETargetType.DOMAIN) || this.config.getTarget().getType().equals((Object)TargetType.DAS)) {
                    this.addLink(element, "Monitoring Information", "MonitoringInformation", indentation);
                }
            } else {
                this.addLink(element, "Monitoring Information", instanceName + File.separator + "MonitoringInformation", indentation);
            }
        }
    }

    private ArrayList<String> getNodeAgentNames() {
        ConfigContext configContext;
        NodeAgent[] nodeagents = null;
        ArrayList<String> list = new ArrayList<String>();
        if (this.config.getTarget().getType().equals((Object)EETargetType.DOMAIN)) {
            try {
                configContext = AdminService.getAdminService().getAdminContext().getAdminConfigContext();
                Domain domain = ServerBeansFactory.getDomainBean((ConfigContext)configContext);
                NodeAgents nodeAgentCollection = domain.getNodeAgents();
                nodeagents = nodeAgentCollection.getNodeAgent();
            }
            catch (Exception e) {}
        } else {
            try {
                configContext = AdminService.getAdminService().getAdminContext().getAdminConfigContext();
                nodeagents = NodeAgentHelper.getNodeAgentsForCluster((ConfigContext)configContext, (String)this.config.getTarget().getName());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (nodeagents != null) {
            for (NodeAgent agent : nodeagents) {
                list.add(agent.getName());
            }
        }
        return list;
    }
}

