/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.nodeagent;

import com.sun.appserv.management.client.AdminRMISSLClientSocketFactory;
import com.sun.appserv.management.client.RedirectException;
import com.sun.enterprise.admin.common.Status;
import com.sun.enterprise.admin.jmx.remote.https.NoCertCheckX509TrustManager;
import com.sun.enterprise.admin.jmx.remote.server.rmi.JmxConnectorServerDriver;
import com.sun.enterprise.admin.jmx.remote.server.rmi.RemoteJmxProtocol;
import com.sun.enterprise.admin.pluggable.ClientPluggableFeatureFactory;
import com.sun.enterprise.admin.pluggable.ClientPluggableFeatureFactoryImpl;
import com.sun.enterprise.admin.server.core.jmx.auth.ASJMXAuthenticator;
import com.sun.enterprise.admin.server.core.jmx.auth.ASLoginDriverImpl;
import com.sun.enterprise.admin.server.core.jmx.auth.LoginDriver;
import com.sun.enterprise.admin.server.core.jmx.nonssl.RMIMultiHomedServerSocketFactory;
import com.sun.enterprise.admin.server.core.jmx.ssl.AdminSslServerSocketFactory;
import com.sun.enterprise.admin.server.core.jmx.ssl.NodeAgentSyncWithDAS_TlsClientEnvSetter;
import com.sun.enterprise.admin.servermgmt.InstanceException;
import com.sun.enterprise.admin.servermgmt.InstancesManager;
import com.sun.enterprise.admin.servermgmt.RepositoryException;
import com.sun.enterprise.admin.servermgmt.RuntimeStatus;
import com.sun.enterprise.admin.servermgmt.RuntimeStatusList;
import com.sun.enterprise.admin.util.IAdminConstants;
import com.sun.enterprise.admin.util.JMXConnectorConfig;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.ConfigFactory;
import com.sun.enterprise.config.serverbeans.AdminService;
import com.sun.enterprise.config.serverbeans.AuthRealm;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.ClusterHelper;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.ConfigAPIHelper;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.config.serverbeans.JmxConnector;
import com.sun.enterprise.config.serverbeans.LogService;
import com.sun.enterprise.config.serverbeans.NodeAgentHelper;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.ee.admin.clientreg.InstanceRegistry;
import com.sun.enterprise.ee.admin.clientreg.MBeanServerConnectionInfo;
import com.sun.enterprise.ee.admin.concurrent.Executor;
import com.sun.enterprise.ee.admin.concurrent.Task;
import com.sun.enterprise.ee.admin.configbeans.NodeAgentsConfigBean;
import com.sun.enterprise.ee.admin.configbeans.PortConflictCheckerConfigBean;
import com.sun.enterprise.ee.admin.servermgmt.AgentConfig;
import com.sun.enterprise.ee.admin.servermgmt.AgentException;
import com.sun.enterprise.ee.admin.servermgmt.AgentManager;
import com.sun.enterprise.ee.admin.servermgmt.DASPropertyReader;
import com.sun.enterprise.ee.admin.servermgmt.EEDomainsManager;
import com.sun.enterprise.ee.admin.servermgmt.EEInstancesManager;
import com.sun.enterprise.ee.admin.servermgmt.InstanceConfig;
import com.sun.enterprise.ee.admin.servermgmt.NodeAgentPropertyReader;
import com.sun.enterprise.ee.nodeagent.BaseNodeAgent;
import com.sun.enterprise.ee.nodeagent.CommunicationExceptionLogUtils;
import com.sun.enterprise.ee.nodeagent.InstanceDirs;
import com.sun.enterprise.ee.nodeagent.InstanceStatus;
import com.sun.enterprise.ee.nodeagent.NodeAgentMBean;
import com.sun.enterprise.ee.nodeagent.ProcessInstance;
import com.sun.enterprise.ee.nodeagent.ProcessInstanceInternal;
import com.sun.enterprise.ee.nodeagent.ProcessManager;
import com.sun.enterprise.ee.synchronization.DASCommunicationException;
import com.sun.enterprise.ee.synchronization.NonMatchingDASContactedException;
import com.sun.enterprise.ee.synchronization.SynchronizationDriver;
import com.sun.enterprise.ee.synchronization.SynchronizationDriverFactory;
import com.sun.enterprise.ee.synchronization.http.HttpUtils;
import com.sun.enterprise.naming.SerialInitContextFactory;
import com.sun.enterprise.security.RealmConfig;
import com.sun.enterprise.security.SecurityUtil;
import com.sun.enterprise.security.store.IdentityManager;
import com.sun.enterprise.server.logging.LogMBean;
import com.sun.enterprise.server.logging.SystemOutandErrHandler;
import com.sun.enterprise.util.SystemPropertyConstants;
import com.sun.enterprise.util.i18n.StringManagerBase;
import com.sun.enterprise.util.io.StreamFlusher;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.security.cert.CertificateNotYetValidException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.AttributeList;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import javax.management.remote.JMXAuthenticator;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXServiceURL;

public class NodeAgent
extends BaseNodeAgent
implements NodeAgentMBean,
IAdminConstants {
    private static final String DOMAIN_XML_DOMAIN_NAME_PROPERTY_NAME = "administrative.domain.name";
    protected static final String MBEAN_SERVER_DOMAIN = "com.sun.appserver.nodeagent";
    private AgentConfig _agentConfig;

    public NodeAgent() throws Exception {
        this(new DASPropertyReader(new AgentConfig()), new NodeAgentPropertyReader(new AgentConfig()), new AgentConfig());
    }

    public NodeAgent(AgentConfig agentConfig) throws Exception {
        this(new DASPropertyReader(agentConfig), new NodeAgentPropertyReader(agentConfig), agentConfig);
        InstanceDirs.initialize(agentConfig);
    }

    public NodeAgent(DASPropertyReader dasReader, NodeAgentPropertyReader naReader) throws Exception {
        this(dasReader, naReader, new AgentConfig());
    }

    public NodeAgent(DASPropertyReader dasReader, NodeAgentPropertyReader naReader, AgentConfig agentConfig) throws Exception {
        InstanceDirs.initialize(System.getProperty("com.sun.aas.instanceRoot"));
        this.setDASPropertyReader(dasReader);
        this.setNodeAgentPropertyReader(naReader);
        this._agentConfig = agentConfig;
        String domainXMLLocation = System.getProperty("com.sun.aas.instanceRoot") + "/config/domain.xml";
        this.setConfigContext(ConfigFactory.createConfigContext((String)domainXMLLocation));
    }

    public void startInstance(String instanceName) throws AgentException {
        this.startInstance(instanceName, true);
    }

    public void stopInstance(String instanceName) throws AgentException {
        this.getLogger().log(Level.INFO, "nodeagent.stoppingInstance", instanceName);
        this.stopInstance(instanceName, false, -1);
    }

    public void stopInstance(String instanceName, int timeout) throws AgentException {
        this.stopInstance(instanceName, true, timeout);
    }

    private void stopInstance(String instanceName, boolean force, int timeout) throws AgentException {
        this.getLogger().log(Level.INFO, "nodeagent.stoppingInstance", instanceName);
        if (!this.instanceExists(instanceName)) {
            throw new AgentException(_strMgr.getString("nodeAgent.instanceDoesNotExist", (Object)instanceName));
        }
        this.checkOnInstanceIsStarted(instanceName);
        try {
            InstanceStatus.getInstance().updateStatus(instanceName, 2);
            if (!ProcessManager.getInstance().processExists(instanceName)) {
                ProcessManager.getInstance().addProcessInstance(instanceName, new ProcessInstanceInternal(instanceName));
            }
            if (!force) {
                ProcessManager.getInstance().stopProcess(instanceName);
            } else {
                ProcessManager.getInstance().stopProcess(instanceName, timeout);
            }
            ProcessManager.getInstance().removeProcessInstance(instanceName);
            InstanceStatus.getInstance().updateStatusFromAdminChannel(instanceName, 3);
        }
        catch (Exception e) {
            InstanceStatus.getInstance().updateStatusFromAdminChannel(instanceName, 0);
            ProcessInstance pInstance = ProcessManager.getInstance().getProcess(instanceName);
            if (pInstance != null) {
                pInstance.setStopping(false);
            }
            StringManagerBase sm = StringManagerBase.getStringManager((String)this.getLogger().getResourceBundleName());
            this.getLogger().log(Level.WARNING, sm.getString("nodeagent.stop.instance.exception", (Object)instanceName), e);
            throw new AgentException(e);
        }
    }

    public void synchronizeWithDAS() throws AgentException {
        this.synchronizeWithDASInternal("na-synchronization-meta-data.xml");
    }

    public void clearRuntimeStatus() {
        RuntimeStatus.clearRuntimeStatus();
    }

    public RuntimeStatus getRuntimeStatus() throws AgentException {
        try {
            AgentManager manager = new AgentManager(this.getNodeAgentConfig());
            return RuntimeStatus.getRuntimeStatus((String)this.getNodeAgentName(), (InstancesManager)manager);
        }
        catch (Exception ex) {
            StringManagerBase sm = StringManagerBase.getStringManager((String)this.getLogger().getResourceBundleName());
            this.getLogger().log(Level.INFO, sm.getString("nodeagent.getStatus.exception", (Object)this.getNodeAgentName()), ex);
            throw new AgentException(ex);
        }
    }

    public void rotateLog() {
        LogMBean.getInstance().rotateNow();
        this.getLogger().log(Level.INFO, "nodeagent.rotateLog");
    }

    public String getLogFilesDirectory(String componentName) throws AgentException {
        String logDir = "";
        try {
            logDir = this.getLogFileForConponent(componentName, null);
            logDir = logDir.substring(0, logDir.lastIndexOf("/"));
            this.getLogger().log(Level.FINE, "Log directory of component " + componentName + " - " + logDir);
        }
        catch (Exception e) {
            throw new AgentException(e);
        }
        return logDir;
    }

    public AttributeList getLogRecordsUsingQuery(String componentName, String logFile, Long fromRecord, Boolean next, Boolean forward, Integer requestedCount, Date fromDate, Date toDate, String logLevel, Boolean onlyLevel, List listOfModules, Properties nameValueMap) throws AgentException {
        try {
            logFile = this.getLogFileForConponent(componentName, logFile);
            this.getLogger().log(Level.FINE, "Querying logfile  - " + logFile);
            return LogMBean.getInstance().getLogRecordsUsingQuery(logFile, fromRecord, next, forward, requestedCount, fromDate, toDate, logLevel, onlyLevel, listOfModules, nameValueMap);
        }
        catch (Exception e) {
            throw new AgentException(e);
        }
    }

    public void dasHasMoved(String newHost, String newPort) throws AgentException, MBeanException {
        try {
            if (!this.haveDASCoordinatesChanged(newHost, newPort)) {
                return;
            }
            StringManagerBase sm = StringManagerBase.getStringManager((String)this.getLogger().getResourceBundleName());
            this._logger.log(Level.INFO, "nodeagent.das_has_moved.info", new Object[]{newHost, newPort});
            this.writeToDASPropertyReader(newHost, newPort);
            this.setJMXConnectorInfo(newHost, newPort);
            this.cleanCachedConnectionToDAS();
        }
        catch (IOException ex) {
            throw new AgentException(ex);
        }
        catch (ConfigException ex) {
            throw new AgentException(ex);
        }
        catch (InstanceException ex) {
            throw new AgentException(ex);
        }
    }

    private void writeToDASPropertyReader(String newHost, String newPort) throws IOException {
        DASPropertyReader dasProperty = this.getDASPropertyReader();
        dasProperty.setPort(newPort);
        dasProperty.setHost(newHost);
        dasProperty.write();
        this.getLogger().log(Level.CONFIG, "nodeagent.changeOfDASValues", new Object[]{newHost + ":" + newPort, newHost});
    }

    private void setJMXConnectorInfo(String newHost, String newPort) throws ConfigException {
        AdminService as = ServerHelper.getAdminServiceForServer((ConfigContext)NodeAgent.getConfigContext(), (String)"server");
        JmxConnector jmxConn = as.getJmxConnectorByName(as.getSystemJmxConnectorName());
        jmxConn.setPort(newPort);
        ElementProperty clientHostname = jmxConn.getElementPropertyByName("client-hostname");
        clientHostname.setValue("client-hostname", (Object)newHost);
        NodeAgent.getConfigContext().flush(true);
    }

    private void cleanCachedConnectionToDAS() throws ConfigException, InstanceException {
        Server das = ServerHelper.getDAS((ConfigContext)NodeAgent.getConfigContext());
        InstanceRegistry.removeInstanceConnection(das.getName());
        try {
            InstanceRegistry.getDASConnection(NodeAgent.getConfigContext());
        }
        catch (InstanceException instanceException) {
            // empty catch block
        }
    }

    private AgentConfig getNodeAgentConfig() {
        return this._agentConfig;
    }

    private void checkOnInstanceIsStarted(String instanceName) throws AgentException {
        boolean wasRunning = InstanceStatus.getInstance().updateStatusIfRunning(instanceName, 2);
        if (!wasRunning) {
            StringManagerBase sm = StringManagerBase.getStringManager((String)this.getLogger().getResourceBundleName());
            String msg = sm.getString("nodeagent.couldNotStopInstance", (Object)instanceName, (Object)InstanceStatus.getInstance().getStatus(instanceName).getStatus().getStatusString());
            this.getLogger().log(Level.WARNING, msg);
        }
    }

    private String getNodeAgentName() {
        return this.getNodeAgentConfig().getRepositoryName();
    }

    protected String getLogFileForConponent(String componentName, String logFile) throws Exception {
        if (componentName != null && !componentName.equals(this.getNodeAgentConfig().getRepositoryName())) {
            LogService logservice;
            if (!this.instanceExists(componentName)) {
                throw new AgentException(_strMgr.getString("nodeAgent.instanceDoesNotExist", (Object)componentName));
            }
            String logFileX = "";
            String logPrefix = this.getNodeAgentConfig().getRepositoryRoot() + "/" + this.getNodeAgentConfig().getRepositoryName() + "/" + componentName + "/";
            boolean bFound = false;
            Config config = ServerHelper.getConfigForServer((ConfigContext)NodeAgent.getConfigContext(), (String)componentName);
            if (config != null && (logservice = config.getLogService()) != null && (logFileX = logservice.getFile()) != null && !logFileX.equals("")) {
                String instanceRoot;
                bFound = true;
                int iPos = (logFile = logFile == null ? logFileX : logFileX.substring(0, logFileX.lastIndexOf("/") + 1) + logFile).indexOf(instanceRoot = System.getProperty("com.sun.aas.instanceRoot"));
                if (iPos == 0) {
                    logFile = logPrefix + logFile.substring(instanceRoot.length() + 1);
                }
            }
            if (!bFound) {
                logFile = logFile == null ? logPrefix + "logs/server.log" : logPrefix + "logs/" + logFile;
            }
        }
        return logFile;
    }

    protected Vector synchronizeWithDASInternal() throws AgentException {
        return this.synchronizeWithDASInternal("na-startup-meta-data.xml");
    }

    private Vector synchronizeWithDASInternal(String url) throws AgentException {
        this.getLogger().log(Level.INFO, "nodeagent.ExecutingSync");
        DASPropertyReader dasEnv = this.getDASPropertyReader();
        SerialInitContextFactory.setInitializeOrbManager((boolean)false);
        if (Boolean.valueOf(dasEnv.isDASSecure()).booleanValue()) {
            String certNickname = "s1as";
            new NodeAgentSyncWithDAS_TlsClientEnvSetter(certNickname).setup();
        }
        Vector createdInstances = null;
        if (this.getNodeAgentPropertyReader().isBound()) {
            long startSync = System.currentTimeMillis();
            try {
                ConfigContext configContext;
                try {
                    SynchronizationDriver sd = SynchronizationDriverFactory.getSynchronizationDriver(System.getProperty("com.sun.aas.instanceRoot"), url, null);
                    sd.synchronize();
                }
                catch (DASCommunicationException de) {
                    new CommunicationExceptionLogUtils(this.getLogger(), Level.SEVERE, dasEnv).handleDASCommunicationException(de);
                }
                catch (NonMatchingDASContactedException ex) {
                    this.stopAgentWithPause();
                }
                catch (Exception se) {
                    this.getLogger().log(Level.FINE, "Synchronization Exception", se);
                }
                File domain_xml_file = new File(System.getProperty("com.sun.aas.instanceRoot") + "/config/domain.xml");
                if (!domain_xml_file.exists()) {
                    this.getLogger().log(Level.SEVERE, "nodeagent.initialSyncFailed");
                    this.stopAgentWithPause();
                }
                if (domain_xml_file.exists()) {
                    try {
                        this.validateAdminUserAndPassword();
                    }
                    catch (Exception ae) {
                        this.stopAgentWithPause();
                    }
                }
                if ((configContext = NodeAgent.getConfigContext()).isFileChangedExternally()) {
                    configContext.refresh();
                }
                String instanceRoot = System.getProperty("com.sun.aas.instanceRoot");
                System.setProperty("javax.net.ssl.keyStore", instanceRoot + SystemPropertyConstants.JKS_KEYSTORE);
                System.setProperty("javax.net.ssl.trustStore", instanceRoot + SystemPropertyConstants.JKS_TRUSTSTORE);
                if (this.getNodeAgentConfigBean(NodeAgent.getConfigContext()) == null) {
                    this.getLogger().log(Level.WARNING, "nodeagent.hasBeenDeleted");
                    this.reconcileNodeConfiguration();
                    this.getDASPropertyReader().clearProperties();
                    this.getDASPropertyReader().write();
                    this.setNodeAgentBindStatus("DELETED");
                    File file = null;
                    for (int ii = 0; ii < LOCAL_DAS_SYNC_FILES.length; ++ii) {
                        file = new File(System.getProperty("com.sun.aas.instanceRoot") + LOCAL_DAS_SYNC_FILES[ii]);
                        file.delete();
                    }
                    System.exit(0);
                }
                this.updateDASConnectionInfo();
                this.init();
                createdInstances = this.reconcileNodeConfiguration();
            }
            catch (Exception e) {
                this.getLogger().log(Level.WARNING, "nodeagent.synchronization.Exception", e);
                throw new AgentException(e);
            }
        } else {
            this.getLogger().log(Level.FINE, "Error on Synchronization, NodeAgent is not bound");
            throw new AgentException(_strMgr.getString("nodeAgent.unboundSyncError"));
        }
        return createdInstances;
    }

    private void ensureInstanceIsStopped(String instanceName, boolean synchronizeInstance) throws AgentException {
        boolean wasStopped;
        int newStatus = 1;
        if (synchronizeInstance) {
            newStatus = 7;
        }
        if (!(wasStopped = InstanceStatus.getInstance().updateStatusIfStopped(instanceName, newStatus))) {
            StringManagerBase sm = StringManagerBase.getStringManager((String)this.getLogger().getResourceBundleName());
            String msg = sm.getString("nodeagent.couldNotStartInstance", (Object)instanceName, (Object)InstanceStatus.getInstance().getStatus(instanceName).getStatus().getStatusString());
            this.getLogger().log(Level.WARNING, msg);
            throw new AgentException(msg);
        }
    }

    protected void startInstance(String instanceName, boolean synchronizeInstance) throws AgentException {
        this.getLogger().log(Level.INFO, "nodeagent.startingInstance", instanceName);
        if (this.bDebug) {
            System.out.println("Starting instance " + instanceName + " with synch flag set to " + synchronizeInstance);
        }
        if (!this.instanceExists(instanceName)) {
            throw new AgentException(_strMgr.getString("nodeAgent.instanceDoesNotExist", (Object)instanceName));
        }
        this.ensureInstanceIsStopped(instanceName, synchronizeInstance);
        if (synchronizeInstance) {
            try {
                InstanceStatus.getInstance().updateStatus(instanceName, 7);
                this.getLogger().log(Level.FINE, "NodeAgent synchronizing for instance", instanceName);
                this.synchronizeInstanceWithDAS(instanceName);
            }
            catch (AgentException ae) {
                InstanceStatus.getInstance().updateStatusFromAdminChannel(instanceName, 3);
                throw ae;
            }
        }
        try {
            InstanceStatus.getInstance().updateStatus(instanceName, 1);
            ProcessManager.getInstance().addProcessInstance(instanceName, new ProcessInstanceInternal(instanceName));
            ProcessManager.getInstance().startProcess(instanceName);
            InstanceStatus.getInstance().updateStatusFromAdminChannel(instanceName, 0);
        }
        catch (Exception e) {
            InstanceStatus.getInstance().updateStatusFromAdminChannel(instanceName, 3);
            StringManagerBase sm = StringManagerBase.getStringManager((String)this.getLogger().getResourceBundleName());
            this.getLogger().log(Level.WARNING, sm.getString("nodeagent.start.instance.exception", (Object)instanceName), e);
            throw new AgentException(e);
        }
    }

    private com.sun.enterprise.config.serverbeans.NodeAgent getNodeAgentConfigBean(ConfigContext configCtxt) throws ConfigException {
        Domain domain = ConfigAPIHelper.getDomainConfigBean((ConfigContext)configCtxt);
        return domain.getNodeAgents().getNodeAgentByName(this.getNodeAgentName());
    }

    Vector reconcileNodeConfiguration() throws AgentException {
        this.getLogger().log(Level.FINE, "Reconciling existing Node Configuration with configuration that is in domain.xml");
        Vector<String> createdInstances = new Vector<String>();
        try {
            Domain domain = ConfigAPIHelper.getDomainConfigBean((ConfigContext)NodeAgent.getConfigContext());
            Server[] servers = domain.getServers().getServer();
            InstanceConfig instanceConfig = new InstanceConfig(InstanceDirs.getInstanceRoot());
            EEInstancesManager eeInstancesManager = new EEInstancesManager(instanceConfig);
            HashMap hmInstances = this.getInstancesAndStatus(instanceConfig, eeInstancesManager);
            Iterator<Object> serverIt = null;
            String instanceName2 = null;
            int status = 0;
            com.sun.enterprise.config.serverbeans.NodeAgent nodeController = this.getNodeAgentConfigBean(NodeAgent.getConfigContext());
            if (nodeController != null) {
                Properties props = null;
                ElementProperty elementProperty = null;
                Cluster cluster = null;
                String domainName = "DomainPropertyNotFound";
                String clusterArg = "";
                for (int ii = 0; ii < servers.length; ++ii) {
                    if (!instanceConfig.getRepositoryName().equals(servers[ii].getNodeAgentRef())) continue;
                    if (this.instanceExists(servers[ii].getName())) {
                        this.getLogger().log(Level.INFO, "nodeagent.instance.exists", servers[ii].getName());
                    } else {
                        this.getLogger().log(Level.INFO, "nodeagent.create.instance", servers[ii].getName());
                        instanceConfig.setInstanceName(servers[ii].getName());
                        props = new Properties();
                        elementProperty = domain.getElementPropertyByName(DOMAIN_XML_DOMAIN_NAME_PROPERTY_NAME);
                        if (elementProperty != null) {
                            domainName = elementProperty.getValue();
                        }
                        this.getLogger().log(Level.INFO, "domain for instance - " + domainName);
                        props.setProperty("DOMAIN_NAME", domainName);
                        if (ServerHelper.isServerClustered((ConfigContext)NodeAgent.getConfigContext(), (String)servers[ii].getName())) {
                            try {
                                cluster = ClusterHelper.getClusterForInstance((ConfigContext)NodeAgent.getConfigContext(), (String)servers[ii].getName());
                                if (cluster != null) {
                                    clusterArg = "-Dcom.sun.aas.clusterName=\"" + cluster.getName() + "\"";
                                }
                            }
                            catch (ConfigException ce) {
                                this.getLogger().log(Level.FINEST, "Server isn't part of cluster", ce);
                            }
                        }
                        props.setProperty("CLUSTER_NAME", clusterArg);
                        eeInstancesManager.setOverridingProperties(props);
                        eeInstancesManager.createInstance();
                        createdInstances.add(servers[ii].getName());
                    }
                    hmInstances.remove(servers[ii].getName());
                }
            }
            for (String instanceName2 : hmInstances.keySet()) {
                status = ((Status)hmInstances.get(instanceName2)).getStatusCode();
                if (this.bDebug) {
                    System.out.println("Delete Server =" + instanceName2 + " with status:" + status);
                }
                this.getLogger().log(Level.INFO, "nodeagent.delete.instance", instanceName2);
                instanceConfig.setInstanceName(instanceName2);
                if (status != 3) {
                    try {
                        this.stopInstance(instanceName2);
                    }
                    catch (AgentException e) {
                        StringManagerBase sm = StringManagerBase.getStringManager((String)this.getLogger().getResourceBundleName());
                        this.getLogger().log(Level.INFO, sm.getString("nodeagent.stop.instance.exception", (Object)instanceName2), (Throwable)((Object)e));
                    }
                }
                eeInstancesManager.deleteInstance(false);
            }
            for (String instanceName2 : createdInstances) {
                try {
                    this.synchronizeInstanceWithDAS(instanceName2);
                }
                catch (AgentException ae) {}
            }
        }
        catch (Exception e) {
            throw new AgentException(e);
        }
        return createdInstances;
    }

    protected boolean instanceExists(String iName) throws AgentException {
        boolean match = false;
        Iterator serverIt = null;
        String instanceName2 = null;
        try {
            HashMap hmInstances = this.getInstancesAndStatus();
            for (String instanceName2 : hmInstances.keySet()) {
                if (!instanceName2.equals(iName)) continue;
                match = true;
                break;
            }
        }
        catch (RepositoryException e) {
            throw new AgentException(e);
        }
        return match;
    }

    protected HashMap getInstancesAndStatus() throws RepositoryException {
        InstanceConfig instanceConfig = new InstanceConfig(InstanceDirs.getInstanceRoot());
        EEInstancesManager eeInstancesManager = new EEInstancesManager(instanceConfig);
        return this.getInstancesAndStatus(instanceConfig, eeInstancesManager);
    }

    protected HashMap getInstancesAndStatus(InstanceConfig instanceConfig, EEInstancesManager eeInstancesManager) throws RepositoryException {
        HashMap<String, Status> hmInstances = new HashMap<String, Status>();
        RuntimeStatusList rtstatusList = eeInstancesManager.getRuntimeStatus(instanceConfig);
        RuntimeStatus rtstatus = null;
        for (int i = 0; i < rtstatusList.size(); ++i) {
            rtstatus = rtstatusList.getStatus(i);
            hmInstances.put(rtstatus.getName(), rtstatus.getStatus());
        }
        return hmInstances;
    }

    public void localRendezvousWithDAS() throws Exception {
        File[] domains;
        this.getLogger().log(Level.FINE, "Attempting to Rendezvous with local DAS...");
        AgentConfig agentConfig = this.getNodeAgentConfig();
        File root = new File(new File(agentConfig.getRepositoryRoot()).getParentFile(), "domains");
        NodeAgentPropertyReader naReader = this.getNodeAgentPropertyReader();
        DASPropertyReader dasReader = this.getDASPropertyReader();
        ConfigContext goodConfigContext = null;
        boolean tooMany = false;
        String dasHost2 = dasReader.getHost();
        String dasPort2 = dasReader.getPort();
        if (root.exists() && (domains = root.listFiles()) != null) {
            for (int i = 0; i < domains.length; ++i) {
                File domainXml = new File(new File(domains[i], "config"), "domain.xml");
                this.getLogger().log(Level.FINE, "Looking for " + domainXml.getAbsolutePath());
                if (!domainXml.exists()) continue;
                ConfigContext configContext = ConfigFactory.createConfigContext((String)domainXml.getAbsolutePath());
                String dasName = ServerHelper.getDAS((ConfigContext)configContext).getName();
                Config dasConfig = ServerHelper.getConfigForServer((ConfigContext)configContext, (String)dasName);
                JMXConnectorConfig dasInfo = ServerHelper.getJMXConnectorInfo((ConfigContext)configContext, (String)dasName);
                String dasPort = dasConfig.getHttpService().getHttpListenerById("admin-listener").getPort();
                String dasHost = dasInfo.getHost();
                this.getLogger().log(Level.FINE, "dasHost: " + dasHost + " dasPort: " + dasPort + " dasHost2: " + dasHost2 + " dasPort2: " + dasPort2);
                if (!dasPort.equals(dasPort2) || !dasHost.equals(dasHost2) && !PortConflictCheckerConfigBean.isLocalHost(dasHost2)) continue;
                if (goodConfigContext != null) {
                    tooMany = true;
                    break;
                }
                goodConfigContext = configContext;
                this.getLogger().log(Level.INFO, "nodeagent.attemptingRendezvousedWithDAS", domainXml.getAbsolutePath());
            }
        }
        if (tooMany) {
            throw new AgentException(_strMgr.getString("nodeAgent.attemptLocalRendezvous.TooManyLocalDomains", (Object)(dasHost2 + ":" + dasPort2), (Object)root.getAbsolutePath()));
        }
        if (goodConfigContext == null) {
            throw new AgentException(_strMgr.getString("nodeAgent.attemptLocalRendezvous.NoLocalDomains", (Object)(dasHost2 + ":" + dasPort2), (Object)root.getAbsolutePath()));
        }
        NodeAgentsConfigBean ncb = new NodeAgentsConfigBean(goodConfigContext);
        String retDasString = ncb.rendezvousWithDAS(naReader.getHost(), naReader.getPort(), this.getNodeAgentName(), naReader.getProtocol(), naReader.getClientHost());
        goodConfigContext.flush();
        this.markAsBound(retDasString);
    }

    public void rendezvousWithDAS() throws Exception {
        this.getLogger().log(Level.FINE, "Attempting to Rendezvous with DAS...");
        DASPropertyReader dasReader = null;
        String reportingUrl = null;
        try {
            NodeAgentPropertyReader naReader = this.getNodeAgentPropertyReader();
            String agentName = this.getNodeAgentName();
            dasReader = this.getDASPropertyReader();
            ObjectName objname = new ObjectName("com.sun.appserv:type=node-agents,category=config");
            int port = Integer.parseInt(dasReader.getPort());
            String jmxProtocol = null;
            Boolean isDASSecure = new Boolean(dasReader.isDASSecure());
            jmxProtocol = isDASSecure != false ? "s1ashttps" : "s1ashttp";
            JMXServiceURL url = new JMXServiceURL(jmxProtocol, dasReader.getHost(), port);
            reportingUrl = url.toString();
            this.getLogger().log(Level.INFO, "nodeagent.attemptingRendezvousedWithDAS", url);
            JMXConnector conn = JMXConnectorFactory.connect(url, this.initEnvironment(url));
            MBeanServerConnection serverConn = conn.getMBeanServerConnection();
            Object[] params = new Object[]{naReader.getHost(), naReader.getPort(), agentName, naReader.getProtocol(), naReader.getClientHost()};
            String[] signature = new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String"};
            Object oret = serverConn.invoke(objname, "rendezvousWithDAS", params, signature);
            if (oret == null) {
                this.getLogger().log(Level.SEVERE, "nodeagent.invalidRendezvous");
                this.getLogger().log(Level.WARNING, "nodeAgent.stopping.agent");
                System.exit(1);
            }
            reportingUrl = dasReader.getJMXURL();
            if (this.bDebug) {
                System.err.println("BACK FROM HTTP CONNECT " + (String)oret);
            }
            this.markAsBound((String)oret);
            this.getLogger().log(Level.INFO, "nodeagent.rendezvousedWithDAS", dasReader.getJMXURL());
        }
        catch (RedirectException e) {
            this.getLogger().log(Level.SEVERE, _strMgr.getString("nodeAgent.invalidRedirectAttempted"));
            throw e;
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "nodeagent.failedRendezvousWithDAS", reportingUrl + " == " + e.toString());
            this.getLogger().log(Level.FINE, "nodeagent.rendezvous.with.das.Exception", e);
            Throwable cause = e.getCause();
            if (cause instanceof CertificateNotYetValidException) {
                this.getLogger().log(Level.WARNING, "nodeagent.CertificateNotYetValid", reportingUrl + " == " + e.toString());
            }
            throw e;
        }
    }

    private void markAsBound(String dasRetString) throws IOException {
        int iPos = dasRetString.indexOf("|");
        String port = dasRetString.substring(0, iPos);
        String securityFlag = dasRetString.substring(iPos + 1);
        DASPropertyReader dasReader = this.getDASPropertyReader();
        dasReader.setPort(port);
        dasReader.setIsDASSecure(securityFlag);
        dasReader.write();
        this.setNodeAgentBindStatus("BOUND");
    }

    private Map initEnvironment(JMXServiceURL serviceUrl) {
        HashMap<String, String> env = new HashMap<String, String>();
        String PKGS = "com.sun.enterprise.admin.jmx.remote.protocol";
        env.put("jmx.remote.protocol.provider.pkgs", "com.sun.enterprise.admin.jmx.remote.protocol");
        env.put("USER", IdentityManager.getUser());
        env.put("PASSWORD", IdentityManager.getPassword());
        env.put("com.sun.enterprise.as.http.auth", "BASIC");
        Boolean doNotConfirmCert = new Boolean(this.getNodeAgentPropertyReader().doNotConfirmServerCert());
        if (doNotConfirmCert.booleanValue()) {
            if (this.bDebug) {
                System.out.println("do not confirm server certificate");
            }
            NoCertCheckX509TrustManager tm = new NoCertCheckX509TrustManager((Object)serviceUrl);
            env.put("TRUST_MANAGER_KEY", (String)tm);
        } else if (this.bDebug) {
            System.out.println("confirm server certificate");
        }
        return env;
    }

    protected void configureLogger() {
        try {
            String logFileDefault;
            this.getLogger().log(Level.FINE, "Configuring Logger...");
            String logFile = logFileDefault = System.getProperty("com.sun.aas.instanceRoot") + File.separator + "logs/server.log";
            if (this.getNodeAgentPropertyReader().isBound()) {
                LogService logService;
                com.sun.enterprise.config.serverbeans.NodeAgent nodeController = this.getNodeAgentConfigBean(NodeAgent.getConfigContext());
                if (nodeController != null && (logService = nodeController.getLogService()) != null) {
                    logFile = logService.getFile();
                    if (logFile == null) {
                        logFile = logFileDefault;
                    }
                    logFile = System.getProperty(logFile);
                    String logHandler = logService.getLogHandler();
                    String logLevel = logService.getModuleLogLevels().getNodeAgent();
                    Handler[] handlers = this.getLogger().getHandlers();
                    if (this.bDebug) {
                        System.out.println("Log config number of handlers that currently exist:" + handlers.length + " - " + logFile + " - " + logHandler + " - " + logLevel);
                    }
                    this.registerLogger(Level.parse(logLevel), logFile);
                    this.configureSynchronizationLogger(logService.getModuleLogLevels().getSynchronization());
                }
            } else {
                this.registerLogger(Level.INFO, logFile);
            }
            String verboseMode = System.getProperty("com.sun.aas.verboseMode", "false");
            if (this.bDebug) {
                System.out.println("******* Redirecting stdout & stderr to : " + logFile);
            }
            if (logFile != null && !verboseMode.equals("true")) {
                new SystemOutandErrHandler();
            }
        }
        catch (Exception e) {
            this.getLogger().info("nodeagent.noLogger");
        }
    }

    private void initializeSecurity(JmxConnector jmxConnector, com.sun.enterprise.config.serverbeans.NodeAgent nodeController) throws Exception {
        SecurityUtil.getSecuritySupport();
        String realmName = jmxConnector.getAuthRealmName();
        RealmConfig.createRealms((String)realmName, (AuthRealm[])new AuthRealm[]{nodeController.getAuthRealm()});
    }

    private String getObjectName() {
        return ":type=NodeAgent,name=" + this.getNodeAgentName() + ",category=config";
    }

    protected void registerJmxConnector(String protocol, String host, String port) throws Exception {
        if (this.bDebug) {
            System.out.println(this.getClass().getName() + ": Trying to start jmx connector:" + "service:jmx:" + protocol + "://" + host + ":" + port);
        }
        ConfigContext configContext = NodeAgent.getConfigContext();
        JmxConnector connector = NodeAgentHelper.getNodeAgentSystemConnector((ConfigContext)configContext, (String)this.getNodeAgentName());
        int iPort = Integer.parseInt(port);
        JmxConnectorServerDriver dr = new JmxConnectorServerDriver();
        dr.setAuthentication(true);
        dr.setAuthenticator(this.createJMXAuthenticator(connector));
        dr.setMBeanServer(this._server);
        dr.setBindAddress(connector.getAddress());
        dr.setPort(iPort);
        dr.setProtocol(RemoteJmxProtocol.instance((String)protocol));
        this.handleSsl(dr, connector);
        dr.setLogger(this._logger);
        dr.setRmiRegistrySecureFlag(false);
        JMXConnectorServer serverEnd = dr.startConnectorServer();
        this.getLogger().log(Level.INFO, "NodeAgent url  = service:jmx:" + connector.getProtocol() + "://" + connector.getAddress() + ":" + connector.getPort());
        this.registerMBean(serverEnd, ":name=JmxConnectorServer,port=" + port);
        if (this.bDebug) {
            this.query();
        }
    }

    private JMXAuthenticator createJMXAuthenticator(JmxConnector connector) throws ConfigException {
        ASJMXAuthenticator authenticator = new ASJMXAuthenticator();
        authenticator.setRealmName(connector.getAuthRealmName());
        authenticator.setLoginDriver((LoginDriver)new ASLoginDriverImpl());
        return authenticator;
    }

    private void handleSsl(JmxConnectorServerDriver dr, JmxConnector connector) {
        boolean ssl = connector.isSecurityEnabled();
        if (this.bDebug) {
            System.out.println("DEBUG MESSAGE: SSL Status for System Jmx Connector: " + ssl);
        }
        dr.setSsl(ssl);
        RMIMultiHomedServerSocketFactory sf = null;
        if (ssl) {
            sf = new AdminSslServerSocketFactory(connector.getSsl(), connector.getAddress());
            AdminRMISSLClientSocketFactory cf = new AdminRMISSLClientSocketFactory();
            dr.setRmiClientSocketFactory((RMIClientSocketFactory)cf);
        } else {
            sf = new RMIMultiHomedServerSocketFactory(connector.getAddress());
        }
        dr.setRmiServerSocketFactory((RMIServerSocketFactory)sf);
    }

    protected void configureAgent() throws Exception {
        this.getLogger().log(Level.FINEST, "Configuring Agent...");
        if (this._server == null) {
            this._server = MBeanServerFactory.createMBeanServer(MBEAN_SERVER_DOMAIN);
            this.registerMBean(this, this.getObjectName());
        }
        ObjectName nameSearch = new ObjectName(this._server.getDefaultDomain() + ":name=JmxConnectorServer,*");
        Set<ObjectName> ls = this._server.queryNames(nameSearch, null);
        Iterator<ObjectName> it = ls.iterator();
        ObjectName objectName2 = null;
        String currPort = null;
        Vector<ObjectName> vtCurrent = new Vector<ObjectName>();
        while (it.hasNext()) {
            objectName2 = it.next();
            if (this.bDebug) {
                System.out.println("*** currently registered connectors: " + objectName2);
            }
            currPort = objectName2.getKeyProperty("port");
            vtCurrent.add(objectName2);
        }
        if (this.getNodeAgentPropertyReader().isBound()) {
            JmxConnector jmxConnector;
            com.sun.enterprise.config.serverbeans.NodeAgent nodeController = this.getNodeAgentConfigBean(NodeAgent.getConfigContext());
            if (nodeController != null && (jmxConnector = nodeController.getJmxConnector()) != null) {
                this.initializeSecurity(jmxConnector, nodeController);
                if (!this.isPortRegistered(vtCurrent, jmxConnector.getPort())) {
                    this.registerJmxConnector(jmxConnector.getProtocol(), jmxConnector.getAddress(), jmxConnector.getPort());
                }
            }
        } else if (!this.isPortRegistered(vtCurrent, this.getNodeAgentPropertyReader().getPort())) {
            this.registerJmxConnector(this.getNodeAgentPropertyReader().getProtocol(), this.getNodeAgentPropertyReader().getHost(), this.getNodeAgentPropertyReader().getPort());
        }
        for (ObjectName objectName2 : vtCurrent) {
            if (this.bDebug) {
                System.out.println("Removing JmxConnectorServer - " + objectName2);
            }
            this._server.invoke(objectName2, "stop", new Object[0], new String[0]);
            this._server.unregisterMBean(objectName2);
        }
    }

    protected void postStartupProcessing(String startInstancesOverride, boolean syncInstancesOverride) throws Exception {
        if (this.getNodeAgentPropertyReader().isBound()) {
            com.sun.enterprise.config.serverbeans.NodeAgent nodeController = this.getNodeAgentConfigBean(NodeAgent.getConfigContext());
            if (this.bDebug) {
                String defaultStartup = null;
                if (nodeController != null) {
                    defaultStartup = String.valueOf(nodeController.isStartServersInStartup());
                }
                System.out.println("Node Agent PostStartUpProcessing: domain.xml startup attibute = " + defaultStartup + " startup override = " + startInstancesOverride);
            }
            if (startInstancesOverride == null) {
                startInstancesOverride = "NOTSET";
            }
            if (startInstancesOverride.equals("NOTSET") && nodeController != null && nodeController.isStartServersInStartup() || startInstancesOverride.toLowerCase().equals("true")) {
                Server[] servers = ServerHelper.getServersOfANodeAgent((ConfigContext)NodeAgent.getConfigContext(), (String)this.getNodeAgentName());
                Task[] tasks = new StartServerTask[servers.length];
                for (int ii = 0; ii < servers.length; ++ii) {
                    tasks[ii] = new StartServerTask(servers[ii].getName(), syncInstancesOverride);
                }
                Executor e = new Executor(tasks);
                e.run();
            }
        }
    }

    protected void shutdownProcessing() throws Exception {
        com.sun.enterprise.config.serverbeans.NodeAgent nodeController;
        if (this.getNodeAgentPropertyReader().isBound() && (nodeController = this.getNodeAgentConfigBean(NodeAgent.getConfigContext())) != null) {
            HashMap hmInstances = this.getInstancesAndStatus();
            Iterator serverIt = hmInstances.keySet().iterator();
            String instanceName = null;
            Status instanceStatus = null;
            ArrayList<String> runningInstances = new ArrayList<String>();
            while (serverIt.hasNext()) {
                instanceName = (String)serverIt.next();
                instanceStatus = (Status)hmInstances.get(instanceName);
                if (this.bDebug) {
                    System.out.println("Shutdown processing, seeing if need to shutdown - " + instanceName + " with status " + instanceStatus);
                }
                if (instanceStatus == null || instanceStatus.getStatusCode() != 0) continue;
                if (this.bDebug) {
                    System.out.println("Shutdown processing, shutting down - " + instanceName);
                }
                this.getLogger().log(Level.FINE, "NodeAgent Shutdown processing, Shutting down instance - " + instanceName);
                runningInstances.add(instanceName);
            }
            String[] servers = runningInstances.toArray(new String[runningInstances.size()]);
            Task[] tasks = new StopServerTask[servers.length];
            for (int ii = 0; ii < servers.length; ++ii) {
                tasks[ii] = new StopServerTask(servers[ii]);
            }
            Executor e = new Executor(tasks);
            e.run();
        }
    }

    protected int synchronizeInstanceWithDAS(String instance) throws AgentException {
        int iret = 1;
        String sxRet = "FAILED!";
        if (this.isInstanceStarted(instance)) {
            this.getLogger().log(Level.FINE, "Returning from synchronizeInstanceWithDAS as instance is already running");
            return 90;
        }
        String instanceSyncJvmOptions = "";
        try {
            com.sun.enterprise.config.serverbeans.NodeAgent nodeagent = this.getNodeAgentConfigBean(NodeAgent.getConfigContext());
            ElementProperty instanceSyncJvmOptionsProperty = nodeagent.getElementPropertyByName("INSTANCE-SYNC-JVM-OPTIONS");
            if (instanceSyncJvmOptionsProperty != null) {
                instanceSyncJvmOptions = instanceSyncJvmOptionsProperty.getValue();
            }
        }
        catch (ConfigException ce) {
            this.getLogger().log(Level.WARNING, "nodeagent.synchronization.Exception", ce);
        }
        long startSync = System.currentTimeMillis();
        try {
            InstanceConfig instanceConfig = new InstanceConfig(InstanceDirs.getRepositoryName(), InstanceDirs.getRepositoryRoot(), instance);
            String iRoot = instanceConfig.getRepositoryRoot() + File.separator + instanceConfig.getRepositoryName() + File.separator + instance;
            if (this.bDebug) {
                System.out.println("*** SYNCHRONIZE INSTANCE: " + iRoot);
            }
            String installRoot = System.getProperty("com.sun.aas.installRoot");
            ArrayList<String> ar = new ArrayList<String>();
            ar.add(System.getProperty("com.sun.aas.javaRoot") + File.separator + "bin" + File.separator + "java");
            if (instanceSyncJvmOptions != null && !instanceSyncJvmOptions.equals("")) {
                ar.add(instanceSyncJvmOptions);
            }
            String logFileDefault = System.getProperty("com.sun.aas.instanceRoot") + File.separator + "logs/server.log";
            ar.add("-Djava.util.logging.manager=com.sun.enterprise.server.logging.ServerLogManager");
            ar.add("-Dcom.sun.aas.installRoot=" + installRoot);
            ar.add("-Dcom.sun.aas.agentRoot=" + System.getProperty("com.sun.aas.instanceRoot"));
            ar.add("-Dcom.sun.aas.agentName=" + System.getProperty("com.sun.aas.instanceName"));
            ar.add("-Dcom.sun.aas.agentCertNickname=" + ServerHelper.getCertNickname((ConfigContext)NodeAgent.getConfigContext(), (String)"server"));
            this.setKeyAndTrustStoresForInstanceSync(ar);
            ar.add("-Dcom.sun.aas.defaultLogFile=" + logFileDefault);
            ar.add("-Dcom.sun.aas.instanceRoot=" + iRoot);
            ar.add("-Dcom.sun.aas.configRoot=" + System.getProperty("com.sun.aas.configRoot"));
            ar.add("-Dcom.sun.aas.instanceName=" + instance);
            ar.add("-Dcom.sun.appserv.pluggable.features=com.sun.enterprise.ee.server.pluggable.EEPluggableFeatureImpl");
            ar.add("-Dcom.sun.aas.promptForIdentity=true");
            ar.add("-cp");
            String fs = File.separator;
            String fps = File.pathSeparator;
            ar.add(installRoot + fs + "lib" + fs + "appserv-admin.jar" + fps + installRoot + fs + "lib" + fs + "appserv-rt.jar" + fps + installRoot + fs + "lib" + fs + "javaee.jar" + fps + installRoot + fs + "lib" + fs + "appserv-se.jar" + fps + installRoot + fs + "lib" + fs + "appserv-ee.jar");
            ar.add("com.sun.enterprise.ee.synchronization.SynchronizationMain");
            String synUrl = HttpUtils.getSynchronizationURL(NodeAgent.getConfigContext());
            if (synUrl != null) {
                ar.add(synUrl);
            }
            String[] command = new String[ar.size()];
            command = ar.toArray(command);
            if (this.getLogger().isLoggable(Level.FINE)) {
                StringBuffer sb = new StringBuffer();
                for (int ii = 0; ii < command.length; ++ii) {
                    sb.append(command[ii] + " ");
                }
                this.getLogger().log(Level.FINE, sb.toString());
            }
            Process process = Runtime.getRuntime().exec(command);
            IdentityManager.writeToOutputStream((OutputStream)process.getOutputStream());
            StreamFlusher sfOut = new StreamFlusher(process.getInputStream(), (OutputStream)System.err);
            StreamFlusher sfErr = new StreamFlusher(process.getErrorStream(), (OutputStream)System.err);
            sfOut.start();
            sfErr.start();
            iret = process.waitFor();
            Level sLoglevel = Level.SEVERE;
            if (iret == 0) {
                sxRet = "SUCCEEDED!";
                sLoglevel = Level.INFO;
            }
            this.getLogger().log(sLoglevel, "nodeagent.syncStatus", new Object[]{instance, sxRet, String.valueOf(System.currentTimeMillis() - startSync)});
        }
        catch (Exception e) {
            this.getLogger().log(Level.WARNING, "nodeagent.synchronization.Exception", e);
            throw new AgentException(e);
        }
        return iret;
    }

    private boolean isInstanceStarted(String instance) {
        try {
            HashMap h = this.getInstancesAndStatus();
            Status s = (Status)h.get(instance);
            if (s.getStatusCode() == 0 || s.getStatusCode() == 2 || s.getStatusCode() == 1) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    protected void updateDASConnectionInfo() throws Exception {
        Server das;
        MBeanServerConnectionInfo dasInfo = InstanceRegistry.getDASConnectionInfo(NodeAgent.getConfigContext());
        boolean bWrite = false;
        DASPropertyReader dasProperty = this.getDASPropertyReader();
        if (!(dasProperty.getProtocol().equals(dasInfo.getProtocol()) && dasProperty.getPort().equals(dasInfo.getPort()) && dasProperty.getHost().equals(dasInfo.getHost()))) {
            dasProperty.setProtocol(dasInfo.getProtocol());
            dasProperty.setPort(dasInfo.getPort());
            dasProperty.setHost(dasInfo.getHost());
            bWrite = true;
            this.getLogger().log(Level.CONFIG, "nodeagent.changeOfDASValues", new Object[]{dasInfo.getHost() + ":" + dasInfo.getPort(), dasInfo.getHost()});
        }
        if ((das = ServerHelper.getDAS((ConfigContext)NodeAgent.getConfigContext())) != null) {
            String dasName = das.getName();
            JmxConnector dasConnector = ServerHelper.getServerSystemConnector((ConfigContext)NodeAgent.getConfigContext(), (String)dasName);
            if (dasConnector != null) {
                String jmxConnSecure = String.valueOf(dasConnector.isSecurityEnabled());
                if (!String.valueOf(dasProperty.isDASSecure()).equals(jmxConnSecure)) {
                    dasProperty.setIsDASSecure(jmxConnSecure);
                    bWrite = true;
                }
            }
        }
        if (bWrite) {
            dasProperty.write();
        }
    }

    protected void validateAdminUserAndPassword() throws AgentException {
        AgentConfig ac = this.getAgentConfig();
        this.setPasswords(ac);
        AgentManager am = this.getAgentManager(ac);
        am.validateAdminUserAndPassword(ac);
    }

    private AgentConfig getAgentConfig() {
        String myName = System.getProperty("com.sun.aas.instanceName");
        String myPath = this.getMyPath();
        AgentConfig ac = new AgentConfig(myName, myPath);
        return ac;
    }

    private String getMyPath() {
        String path = System.getProperty("com.sun.aas.instanceRoot");
        File f = new File(path);
        String parent = new File(f.getParent()).getParent();
        return parent;
    }

    private AgentManager getAgentManager(AgentConfig agentConfig) {
        EEDomainsManager domainsManager = (EEDomainsManager)this.getFeatureFactory().getDomainsManager();
        return domainsManager.getAgentManager(agentConfig);
    }

    private void setPasswords(AgentConfig ac) {
        String mp = IdentityManager.getMasterPassword();
        ac.put("agent.masterpassword", mp);
        System.setProperty("javax.net.ssl.keyStorePassword", mp);
        System.setProperty("javax.net.ssl.trustStorePassword", mp);
        ac.put("agent.das.user", IdentityManager.getUser());
        ac.put("agent.das.password", IdentityManager.getPassword());
    }

    private ClientPluggableFeatureFactory getFeatureFactory() {
        String featurePropClass = System.getProperty("com.sun.appserv.admin.pluggable.features", null);
        ClientPluggableFeatureFactoryImpl featureFactoryImpl = new ClientPluggableFeatureFactoryImpl(this.getLogger());
        ClientPluggableFeatureFactory featureFactory = (ClientPluggableFeatureFactory)featureFactoryImpl.getInstance(featurePropClass);
        return featureFactory;
    }

    private void configureSynchronizationLogger(String level) {
        Level ll = Level.INFO;
        try {
            ll = Level.parse(level);
        }
        catch (Exception e) {
            this.getLogger().log(Level.FINE, "Exception: " + e.getMessage());
        }
        Logger syncLogger = Logger.getLogger("javax.ee.enterprise.system.tools.synchronization");
        this.getLogger().log(Level.FINE, "Setting synchronization loglevel to " + ll);
        syncLogger.setLevel(ll);
    }

    private void setKeyAndTrustStoresForInstanceSync(ArrayList ar) throws AgentException {
        String configDir = System.getProperty("com.sun.aas.instanceRoot") + File.separator + "config";
        File nssFile = new File(configDir, "key3.db");
        if (!nssFile.exists()) {
            if (System.getProperty("javax.net.ssl.keyStore") == null) {
                StringManagerBase sm = StringManagerBase.getStringManager((String)this.getLogger().getResourceBundleName());
                String msg = sm.getString("nodeagent.noKeyStoreFoundForInstanceSync");
                this.getLogger().log(Level.SEVERE, msg);
                throw new AgentException(msg);
            }
            ar.add("-Djavax.net.ssl.keyStore=" + System.getProperty("javax.net.ssl.keyStore"));
            ar.add("-Djavax.net.ssl.trustStore=" + System.getProperty("javax.net.ssl.trustStore"));
            ar.add("-Djavax.net.ssl.keyStorePassword=" + System.getProperty("javax.net.ssl.keyStorePassword"));
            ar.add("-Djavax.net.ssl.trustStorePassword=" + System.getProperty("javax.net.ssl.trustStorePassword"));
        } else {
            ar.add("-Dcom.sun.aas.nssRoot=" + System.getProperty("com.sun.aas.nssRoot"));
            ar.add("-Dcom.sun.appserv.nss.db=" + System.getProperty("com.sun.appserv.nss.db"));
            ar.add("-Dcom.sun.appserv.nss.db.password=" + System.getProperty("com.sun.appserv.nss.db.password"));
        }
    }

    public static void main(String[] args) {
        try {
            int numArgs = args.length;
            int port = 9900;
            if (numArgs == 1) {
                port = Integer.parseInt(args[0]);
            } else if (numArgs != 0) {
                System.out.println("USAGE: Server <port");
            }
            NodeAgent nas = new NodeAgent();
            nas.run(null, false);
            System.exit(0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private boolean haveDASCoordinatesChanged(String newHost, String newPort) throws ConfigException {
        AdminService as = ServerHelper.getAdminServiceForServer((ConfigContext)NodeAgent.getConfigContext(), (String)"server");
        JmxConnector jmxConn = as.getJmxConnectorByName(as.getSystemJmxConnectorName());
        if (!jmxConn.getPort().equals(newPort)) {
            return true;
        }
        ElementProperty clientHostname = jmxConn.getElementPropertyByName("client-hostname");
        return !newHost.equals(clientHostname.getValue());
    }

    class StopServerTask
    extends Task {
        private static final long TIMEOUT_IN_MILLIS = 120000L;
        private String _serverName;

        public StopServerTask(String serverName) {
            super(120000L);
            this._serverName = serverName;
        }

        public void run() {
            try {
                NodeAgent.this.stopInstance(this._serverName);
            }
            catch (AgentException agentException) {
                // empty catch block
            }
        }
    }

    class StartServerTask
    extends Task {
        private static final long TIMEOUT_IN_MILLIS = 600000L;
        private String _serverName;
        private boolean _syncInstance;

        public StartServerTask(String serverName, boolean syncInstance) {
            super(600000L);
            this._serverName = serverName;
            this._syncInstance = syncInstance;
        }

        public void run() {
            try {
                NodeAgent.this.startInstance(this._serverName, this._syncInstance);
            }
            catch (AgentException agentException) {
                // empty catch block
            }
        }
    }
}

