/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.selfmanagement.actions;

import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.ee.selfmanagement.actions.DiskActionMBean;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.util.FileUtil;
import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.Comparator;
import javax.management.Notification;
import javax.management.NotificationListener;

public class DiskAction
implements NotificationListener,
DiskActionMBean {
    private final String JMX_MONITOR_COUNTER_THRESHOLD = "jmx.monitor.counter.threshold";
    private boolean serverLogFilter = false;
    private boolean serverAccessLogFilter = false;
    private boolean asadminAccessLogFilter = false;

    public void setServerLogFilter(boolean fil) {
        this.serverLogFilter = fil;
    }

    public void setAsadminAccessLogFilter(boolean fil) {
        this.asadminAccessLogFilter = fil;
    }

    public void setServerAccessLogFilter(boolean fil) {
        this.serverAccessLogFilter = fil;
    }

    public synchronized void handleNotification(Notification notification, Object handback) {
        try {
            boolean result = false;
            if (notification != null && notification.getType().equals("jmx.monitor.counter.threshold")) {
                this.doFunction();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void doFunction() {
        int j;
        ConfigContext ctx = ApplicationServer.getServerContext().getConfigContext();
        Domain svr = null;
        try {
            svr = ServerBeansFactory.getDomainBean((ConfigContext)ctx);
        }
        catch (ConfigException ex) {
            // empty catch block
        }
        String logsDir = svr.getLogRoot();
        if (logsDir == null) {
            logsDir = FileUtil.getAbsolutePath((String)(".." + File.separator + "logs"));
        }
        String accessLogs = FileUtil.getAbsolutePath((String)(logsDir + File.separator + "access"));
        File logFileDir = new File(logsDir);
        File accessLogDir = new File(accessLogs);
        boolean logDeleted = false;
        if (this.serverLogFilter) {
            FileFilter serverLogFil = new FileFilter(){

                public boolean accept(File pathname) {
                    if (!pathname.isDirectory()) {
                        String name = pathname.getName().toLowerCase();
                        return name.startsWith("server.log");
                    }
                    return false;
                }
            };
            File[] logFiles = this.getSortedFileList(logFileDir.listFiles(serverLogFil));
            logDeleted = false;
            if (logFiles != null && logFiles.length > 0) {
                for (int i = 0; i < logFiles.length - 1; ++i) {
                    logDeleted = logFiles[i].delete();
                }
            }
        }
        if (this.asadminAccessLogFilter) {
            FileFilter asadminAccessLogFil = new FileFilter(){

                public boolean accept(File pathname) {
                    if (!pathname.isDirectory()) {
                        String name = pathname.getName().toLowerCase();
                        return name.startsWith("__asadmin_access");
                    }
                    return false;
                }
            };
            File[] asadminAccessLogs = this.getSortedFileList(accessLogDir.listFiles(asadminAccessLogFil));
            logDeleted = false;
            if (asadminAccessLogs != null && asadminAccessLogs.length > 0) {
                for (j = 0; j < asadminAccessLogs.length - 1; ++j) {
                    logDeleted = asadminAccessLogs[j].delete();
                }
            }
        }
        if (this.serverAccessLogFilter) {
            FileFilter serverAccessLogFil = new FileFilter(){

                public boolean accept(File pathname) {
                    if (!pathname.isDirectory()) {
                        String name = pathname.getName().toLowerCase();
                        return name.startsWith("server_access");
                    }
                    return false;
                }
            };
            File[] serverAccessLogs = this.getSortedFileList(accessLogDir.listFiles(serverAccessLogFil));
            logDeleted = false;
            if (serverAccessLogs != null && serverAccessLogs.length > 0) {
                for (j = 0; j < serverAccessLogs.length - 1; ++j) {
                    logDeleted = serverAccessLogs[j].delete();
                }
            }
        }
    }

    private File[] getSortedFileList(File[] files) {
        Arrays.sort(files, new Comparator(){

            public int compare(Object o1, Object o2) {
                File f1 = (File)o1;
                File f2 = (File)o2;
                return (int)(f1.lastModified() - f2.lastModified());
            }
        });
        return files;
    }
}

