/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.selfmanagement.actions;

import com.sun.enterprise.Switch;
import com.sun.enterprise.admin.server.core.AdminService;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.ResourceHelper;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.ee.selfmanagement.actions.BoundedCircularQueue;
import com.sun.enterprise.ee.selfmanagement.actions.JdbcPoolMgmtActionMBean;
import com.sun.enterprise.ee.selfmanagement.actions.JdbcWorkerThread;
import com.sun.enterprise.resource.MonitorableResourcePool;
import com.sun.enterprise.resource.PoolLifeCycle;
import com.sun.enterprise.resource.ResourcePool;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public class JdbcPoolMgmtAction
implements JdbcPoolMgmtActionMBean,
MBeanRegistration,
NotificationListener,
PoolLifeCycle {
    static StringManager sm = StringManager.getManager(JdbcPoolMgmtAction.class);
    static Logger _logger = LogDomains.getLogger((String)"javax.enterprise.system.core.selfmanagement");
    private boolean allPools = false;
    private String poolNames = null;
    private ConcurrentHashMap<String, Integer> poolNameMap = new ConcurrentHashMap(10, 0.75f, 2);
    private ObjectName myObjectName = null;
    private int sampleSize = 5;
    private int sampleInterval = 60;
    private int defaultMaxConnections = 0;
    private ConcurrentHashMap<String, BoundedCircularQueue> createdPools = new ConcurrentHashMap(10, 0.75f, 2);
    private boolean continueWorkerThread = false;

    public void postRegister(Boolean registrationDone) {
        if (registrationDone.booleanValue()) {
            // empty if block
        }
    }

    public void handleNotification(Notification notification, Object handback) {
        if (notification.getType().startsWith("cluster")) {
            this.handleClusterNotification(notification, handback);
        } else if (notification.getType().startsWith("lifecycle")) {
            this.parse();
            Iterator iter = Switch.getSwitch().getPoolManager().getPoolTable().keySet().iterator();
            String poolName = null;
            while (iter.hasNext()) {
                poolName = (String)iter.next();
                this.poolCreated(poolName);
            }
            this.continueWorkerThread = true;
            new JdbcWorkerThread(this.sampleInterval, this, this.sampleSize).start();
            if (_logger.isLoggable(Level.INFO)) {
                _logger.log(Level.INFO, sm.getString("actions.activated", (Object)"Connection Pool Management", (Object)notification));
            }
        }
    }

    private void handleClusterNotification(Notification notification, Object handback) {
        ConfigContext ctx = AdminService.getAdminService().getAdminContext().getAdminConfigContext();
        String poolName = null;
        Iterator iter = (Iterator)((Object)this.createdPools.keys());
        while (iter.hasNext()) {
            poolName = (String)iter.next();
            try {
                String serverName = null;
                if (notification.getUserData() != null) {
                    serverName = (String)((Map)notification.getUserData()).get("com.sun.enterprise.ee.selfmanagement.events.clusterevent.servername");
                }
                if (!ResourceHelper.isJdbcPoolReferenced((ConfigContext)ctx, (String)poolName, serverName)) continue;
                int maxPoolSize = this.calcMaxPoolSize(poolName);
                ResourcePool pool = Switch.getSwitch().getPoolManager().getPool(poolName);
                pool.setMaxPoolSize(maxPoolSize);
                if (!_logger.isLoggable(Level.INFO)) continue;
                _logger.log(Level.INFO, sm.getString("connectionpool.setmaxpoolsize", (Object)poolName, (Object)maxPoolSize));
            }
            catch (ConfigException cex) {
                _logger.log(Level.WARNING, sm.getString("action.internal_error"), cex);
            }
        }
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.myObjectName = name;
        return name;
    }

    public void preDeregister() throws Exception {
        this.continueWorkerThread = false;
    }

    public void postDeregister() {
    }

    boolean continueAction() {
        return this.continueWorkerThread;
    }

    void gatherStats() {
        Iterator iter = (Iterator)((Object)this.createdPools.keys());
        ResourcePool pool = null;
        String poolName = null;
        long connsInUse = 0L;
        while (iter.hasNext()) {
            poolName = (String)iter.next();
            pool = Switch.getSwitch().getPoolManager().getPool(poolName);
            connsInUse = ((MonitorableResourcePool)pool).getNumConnInUse();
            this.createdPools.get(poolName).add(connsInUse);
        }
    }

    void tuneSteadyPoolSize() {
        Iterator iter = (Iterator)((Object)this.createdPools.keys());
        ResourcePool pool = null;
        String poolName = null;
        int steadyPoolSize = 0;
        while (iter.hasNext()) {
            poolName = (String)iter.next();
            pool = Switch.getSwitch().getPoolManager().getPool(poolName);
            steadyPoolSize = (int)this.createdPools.get(poolName).getApprox90thPercentile();
            if (pool.getSteadyPoolSize() == steadyPoolSize) continue;
            if (_logger.isLoggable(Level.INFO)) {
                _logger.log(Level.INFO, sm.getString("connectionpool.setsteadypoolsize", (Object)poolName, (Object)pool.getSteadyPoolSize(), (Object)steadyPoolSize));
            }
            pool.setSteadyPoolSize(steadyPoolSize);
        }
    }

    public void setDefaultMaxConnections(int maxConnections) {
        this.defaultMaxConnections = maxConnections;
    }

    public String getPoolNames() {
        return this.poolNames;
    }

    public void setPoolNames(String poolNames) {
        if (poolNames == null) {
            return;
        }
        this.poolNames = poolNames;
    }

    public void setSampleSize(int size) {
        this.sampleSize = size;
    }

    public void setSampleInterval(int seconds) {
        this.sampleInterval = seconds;
    }

    private void parse() {
        StringTokenizer tokenizer = new StringTokenizer(this.poolNames, ",");
        StringTokenizer subTokenizer = null;
        String poolName = null;
        Integer maxConnections = null;
        while (tokenizer.hasMoreTokens()) {
            poolName = tokenizer.nextToken();
            if ("*".equals(poolName)) {
                this.allPools = true;
                return;
            }
            subTokenizer = new StringTokenizer(poolName, "=");
            if (subTokenizer.hasMoreTokens()) {
                poolName = subTokenizer.nextToken();
                maxConnections = Integer.parseInt(subTokenizer.nextToken());
                this.poolNameMap.put(poolName, maxConnections);
                continue;
            }
            this.poolNameMap.put(poolName, this.defaultMaxConnections);
        }
    }

    private int calcMaxPoolSize(String poolName) {
        int maxConnections = this.poolNameMap.get(poolName);
        ConfigContext ctx = AdminService.getAdminService().getAdminContext().getAdminConfigContext();
        Server[] servers = null;
        try {
            servers = ServerHelper.getServersReferencingJdbcPool((ConfigContext)ctx, (String)poolName);
        }
        catch (ConfigException ex) {
            // empty catch block
        }
        String currentServer = ApplicationServer.getServerContext().getInstanceName();
        int totalWeights = 0;
        int myWeight = 0;
        for (int i = 0; i < servers.length; ++i) {
            if (servers[i].getName().equals(currentServer)) {
                myWeight = Integer.parseInt(servers[i].getLbWeight());
            }
            totalWeights += Integer.parseInt(servers[i].getLbWeight());
        }
        if (totalWeights == 0 || myWeight == 0) {
            return maxConnections;
        }
        return maxConnections * myWeight / totalWeights;
    }

    public void poolDestroyed(String poolName) {
        this.createdPools.remove(poolName);
    }

    public void poolCreated(String poolName) {
        if (this.poolNameMap.get(poolName) == null) {
            return;
        }
        int maxPoolSize = this.calcMaxPoolSize(poolName);
        ResourcePool pool = Switch.getSwitch().getPoolManager().getPool(poolName);
        pool.setSelfManaged(true);
        pool.setMaxPoolSize(maxPoolSize);
        if (_logger.isLoggable(Level.INFO)) {
            _logger.log(Level.INFO, sm.getString("connectionpool.setmaxpoolsize", (Object)poolName, (Object)maxPoolSize));
        }
        if (!pool.isMonitoringEnabled()) {
            pool.setMonitoringEnabledLow();
        }
        this.createdPools.put(poolName, new BoundedCircularQueue(this.sampleSize));
    }
}

