/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.synchronization;

import com.sun.enterprise.ee.synchronization.TextProcess;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.servlet.ServletRequest;

public class SynchronizationRequest
implements Serializable {
    public static final int TIMESTAMP_FILE = 0;
    public static final int TIMESTAMP_MODIFICATION_TIME = 1;
    public static final int TIMESTAMP_NONE = 2;
    public static final int TIMESTAMP_MODIFIED_SINCE = 3;
    private static final transient StringManager _localStrMgr = StringManager.getManager(SynchronizationRequest.class);
    private String _metaFileName;
    private String _targetDirectory;
    private long _timestamp;
    private int _timestampType;
    private String _timestampFileName;
    private String _baseDirectory;
    private String _serverName;
    private String _cacheTimestampFile;
    private Properties _env;
    private boolean _exclude = false;
    private boolean _gcEnabled = false;
    private List _inventory;
    private List _excludePatternList;
    private List _includePatternList;
    private boolean _shallowCopyEnabled = false;
    private Set _clientRepositoryInfo;
    private boolean _clientRepositoryInfoSent = false;
    private static final String COUNT = "_count";
    private static final String KEY = "_key_";
    private static final String VALUE = "_value_";
    private static final String AND = "&";
    private static final String EQUAL = "=";
    public static final String ACTION = "action";
    public static final String SYNCHRONIZE = "synchronize";
    public static final String GET = "get";
    public static final String UTF8 = "UTF-8";

    public SynchronizationRequest(String name, long timestamp, int timestampType) {
        this(name, ".", timestamp, timestampType, null);
    }

    public SynchronizationRequest(String name, String targetDirectory, long timestamp, int timestampType, String timestampFileName) {
        this.init(name, targetDirectory, timestamp, timestampType, timestampFileName);
    }

    private void init(String name, String targetDirectory, long timestamp, int timestampType, String timestampFileName) {
        this._metaFileName = name;
        this._targetDirectory = targetDirectory;
        this._timestamp = timestamp;
        this._timestampType = timestampType;
        this._env = new Properties();
        assert (this._timestampType == 0 || this._timestampType == 1 || this._timestampType == 2 || this._timestampType == 3);
        if (this._timestampType != 0) assert (timestampFileName == null);
        this._timestampFileName = timestampFileName;
        this._inventory = new ArrayList();
        this._excludePatternList = new ArrayList();
        this._includePatternList = new ArrayList();
        this._clientRepositoryInfo = new HashSet();
    }

    public String getFileName() {
        String fn = TextProcess.tokenizeConfig(this._metaFileName, this._serverName, this._env);
        return this.processPath(fn);
    }

    private String processPath(String s) {
        if (s != null) {
            return FileUtils.makeForwardSlashes((String)s);
        }
        return s;
    }

    public String getMetaFileName() {
        return this._metaFileName;
    }

    void setMetaFileName(String file) {
        this._metaFileName = file;
    }

    public Properties getEnvironmentProperties() {
        return this._env;
    }

    void addEnvironmentProperty(String key, String value) {
        assert (key != null);
        assert (value != null);
        this._env.put(key, value);
    }

    public boolean isExclude() {
        return this._exclude;
    }

    void setExclude(boolean b) {
        this._exclude = b;
    }

    public File getFile() {
        return new File(this.getFileName());
    }

    public String getTargetDirectory() {
        String targetDir = TextProcess.tokenizeConfig(this._targetDirectory, this._serverName, this._env);
        return this.processPath(targetDir);
    }

    void setTargetDirectory(String targetDir) {
        this._targetDirectory = targetDir;
    }

    public String getBaseDirectory() {
        String baseDir = TextProcess.tokenizeConfig(this._baseDirectory, this._serverName, this._env);
        return this.processPath(baseDir);
    }

    public void setBaseDirectory(String baseDir) {
        this._baseDirectory = baseDir;
    }

    public long getTimestamp() {
        return this._timestamp;
    }

    public void setTimestamp(long timestamp) {
        this._timestamp = timestamp;
    }

    public int getTimestampType() {
        return this._timestampType;
    }

    public void setTimestampType(int type) {
        this._timestampType = type;
    }

    public String getTimestampFileName() {
        String tsFile = TextProcess.tokenizeConfig(this._timestampFileName, this._serverName, this._env);
        return this.processPath(tsFile);
    }

    void setTimestampFileName(String fileName) {
        this._timestampFileName = fileName;
    }

    public File getTimestampFile() {
        String file = TextProcess.tokenizeConfig(this._timestampFileName, this._serverName, this._env);
        return new File(this.processPath(file));
    }

    public String getServerName() {
        return this._serverName;
    }

    public void setServerName(String serverName) {
        this._serverName = serverName;
    }

    public File getCacheTimestampFile() {
        String file = TextProcess.tokenizeConfig(this._cacheTimestampFile, this._serverName, this._env);
        return new File(this.processPath(file));
    }

    void setCacheTimestampFile(String tsfile) {
        this._cacheTimestampFile = tsfile;
    }

    public boolean isGCEnabled() {
        return this._gcEnabled;
    }

    void setGCEnabled(boolean gcEnabled) {
        if (gcEnabled) {
            // empty if block
        }
        this._gcEnabled = gcEnabled;
    }

    public List getInventory() {
        return this._inventory;
    }

    public void setInventory(List inventory) {
        this._inventory = inventory;
    }

    public List getExcludePatternList() {
        return this._excludePatternList;
    }

    void addToExcludePatternList(List pattern) {
        if (pattern != null) {
            this._excludePatternList.addAll(pattern);
        }
    }

    public List getIncludePatternList() {
        int length = this._includePatternList.size();
        for (int i = 0; i < length; ++i) {
            String p = TextProcess.tokenizeConfig((String)this._includePatternList.get(i), this._serverName, this._env);
            this._includePatternList.set(i, p);
        }
        return this._includePatternList;
    }

    void addToIncludePatternList(List pattern) {
        if (pattern != null) {
            this._includePatternList.addAll(pattern);
        }
    }

    public boolean isShallowCopyEnabled() {
        return this._shallowCopyEnabled;
    }

    void setShallowCopyEnabled(boolean tf) {
        this._shallowCopyEnabled = tf;
    }

    void addToClientRepositoryInfo(Set crInfo) {
        if (crInfo != null) {
            this._clientRepositoryInfo.addAll(crInfo);
            this._clientRepositoryInfoSent = true;
        }
    }

    public Set getClientRepositoryInfo() {
        return this._clientRepositoryInfo;
    }

    public boolean isClientRepositoryInfoSent() {
        return this._clientRepositoryInfoSent;
    }

    private void deserializeCollection(String listName, ServletRequest req, Collection c) throws UnsupportedEncodingException {
        String count = req.getParameter(listName + COUNT);
        if (count != null) {
            int cnt = Integer.parseInt(count);
            for (int i = 0; i < cnt; ++i) {
                String value = req.getParameter(listName + i);
                if (value == null) {
                    String msg = _localStrMgr.getString("missingListElement", (Object)i, (Object)listName);
                    throw new IllegalArgumentException(msg);
                }
                c.add(value);
            }
        }
    }

    private String serializeCollection(Collection c, String listName) throws UnsupportedEncodingException {
        StringBuffer sbuf = new StringBuffer();
        if (c != null) {
            int cnt = 0;
            Iterator itr = c.iterator();
            while (itr.hasNext()) {
                sbuf.append(AND + this.encode(listName + cnt) + EQUAL + this.encode((String)itr.next()));
                ++cnt;
            }
            sbuf.append(AND + this.encode(listName + COUNT) + EQUAL + cnt);
        }
        return sbuf.toString();
    }

    private void deserializeMap(String mapName, ServletRequest req, Map m) throws UnsupportedEncodingException {
        String count = req.getParameter(mapName + COUNT);
        if (count != null) {
            int cnt = Integer.parseInt(count);
            for (int i = 0; i < cnt; ++i) {
                String key = req.getParameter(mapName + KEY + i);
                String val = req.getParameter(mapName + VALUE + i);
                if (key == null || val == null) {
                    String msg = _localStrMgr.getString("missingListElement", (Object)i, (Object)mapName);
                    throw new IllegalArgumentException(msg);
                }
                m.put(key, val);
            }
        }
    }

    private String serializeMap(Map map, String mapName) throws UnsupportedEncodingException {
        StringBuffer sbuf = new StringBuffer();
        if (map != null) {
            int cnt = 0;
            Set eSet = map.entrySet();
            for (Map.Entry e : eSet) {
                sbuf.append(AND + this.encode(mapName + KEY + cnt) + EQUAL + this.encode((String)e.getKey()));
                sbuf.append(AND + this.encode(mapName + VALUE + cnt) + EQUAL + this.encode((String)e.getValue()));
                ++cnt;
            }
            sbuf.append(AND + this.encode(mapName + COUNT) + EQUAL + cnt);
        }
        return sbuf.toString();
    }

    public String getPostData() throws UnsupportedEncodingException {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("action=synchronize");
        if (this._metaFileName != null) {
            sbuf.append("&_metaFileName=" + this.encode(this._metaFileName));
        }
        if (this._targetDirectory != null) {
            sbuf.append("&_targetDirectory=" + this.encode(this._targetDirectory));
        }
        sbuf.append("&_timestamp=" + this._timestamp);
        sbuf.append("&_timestampType=" + this._timestampType);
        if (this._timestampFileName != null) {
            sbuf.append("&_timestampFileName=" + this.encode(this._timestampFileName));
        }
        if (this._baseDirectory != null) {
            sbuf.append("&_baseDirectory=" + this.encode(this._baseDirectory));
        }
        if (this._serverName != null) {
            sbuf.append("&_serverName=" + this.encode(this._serverName));
        }
        if (this._cacheTimestampFile != null) {
            sbuf.append("&_cacheTimestampFile=" + this.encode(this._cacheTimestampFile));
        }
        sbuf.append(this.serializeMap(this._env, "_env"));
        sbuf.append("&_exclude=" + this._exclude);
        sbuf.append("&_gcEnabled=" + this._gcEnabled);
        sbuf.append(this.serializeCollection(this._inventory, "_inventory"));
        sbuf.append(this.serializeCollection(this._excludePatternList, "_excludePatternList"));
        sbuf.append(this.serializeCollection(this._includePatternList, "_includePatternList"));
        sbuf.append("&_shallowCopyEnabled=" + this._shallowCopyEnabled);
        sbuf.append(this.serializeCollection(this._clientRepositoryInfo, "_clientRepositoryInfo"));
        sbuf.append("&_clientRepositoryInfoSent=" + this._clientRepositoryInfoSent);
        return sbuf.toString();
    }

    private String encode(String arg) throws UnsupportedEncodingException {
        String encoded = arg != null ? URLEncoder.encode(arg, UTF8) : arg;
        return encoded;
    }

    public SynchronizationRequest(ServletRequest req) throws UnsupportedEncodingException {
        String gcEnabled;
        String metaFileName = req.getParameter("_metaFileName");
        String targetDirectory = req.getParameter("_targetDirectory");
        String timestamp = req.getParameter("_timestamp");
        long ts = 0L;
        if (timestamp != null) {
            ts = Long.parseLong(timestamp);
        }
        String timestampType = req.getParameter("_timestampType");
        int tsType = 3;
        if (timestampType != null) {
            tsType = Integer.parseInt(timestampType);
        }
        String timestampFileName = req.getParameter("_timestampFileName");
        this.init(metaFileName, targetDirectory, ts, tsType, timestampFileName);
        this._baseDirectory = req.getParameter("_baseDirectory");
        this._serverName = req.getParameter("_serverName");
        this._cacheTimestampFile = req.getParameter("_cacheTimestampFile");
        this.deserializeMap("_env", req, this._env);
        String exclude = req.getParameter("_exclude");
        if (exclude != null) {
            this._exclude = Boolean.parseBoolean(exclude);
        }
        if ((gcEnabled = req.getParameter("_gcEnabled")) != null) {
            this._gcEnabled = Boolean.parseBoolean(gcEnabled);
        }
        this.deserializeCollection("_inventory", req, this._inventory);
        this.deserializeCollection("_excludePatternList", req, this._excludePatternList);
        this.deserializeCollection("_includePatternList", req, this._includePatternList);
        String shallowCopyEnabled = req.getParameter("_shallowCopyEnabled");
        if (shallowCopyEnabled != null) {
            this._shallowCopyEnabled = Boolean.parseBoolean(shallowCopyEnabled);
        }
        this.deserializeCollection("_clientRepositoryInfo", req, this._clientRepositoryInfo);
        String clientRepositoryInfoSent = req.getParameter("_clientRepositoryInfoSent");
        if (clientRepositoryInfoSent != null) {
            this._clientRepositoryInfoSent = Boolean.parseBoolean(clientRepositoryInfoSent);
        }
    }
}

