/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.synchronization.impl;

import com.sun.enterprise.admin.server.core.AdminService;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.ee.synchronization.SynchronizationException;
import com.sun.enterprise.ee.synchronization.api.SecurityServiceMgr;
import com.sun.enterprise.ee.synchronization.impl.SynchronizationClientImpl;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.util.RelativePathResolver;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.i18n.StringManagerBase;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SecurityServiceMgrImpl
implements SecurityServiceMgr {
    private ConfigContext _ctx = null;
    private String _serverName = null;
    private static Logger _logger = Logger.getLogger("javax.ee.enterprise.system.tools.synchronization");
    private static final StringManagerBase _strMgr = StringManagerBase.getStringManager((String)_logger.getResourceBundleName());
    private static final StringManager _localStrMgr = StringManager.getManager(SecurityServiceMgrImpl.class);

    public SecurityServiceMgrImpl(ConfigContext ctx) {
        if (AdminService.getAdminService().isDas()) {
            String msg = _localStrMgr.getString("DasNotSupported");
            throw new RuntimeException(msg);
        }
        this._ctx = ctx;
    }

    public SecurityServiceMgrImpl() {
        if (AdminService.getAdminService().isDas()) {
            String msg = _localStrMgr.getString("DasNotSupported");
            throw new RuntimeException(msg);
        }
    }

    public void setConfigContext(ConfigContext ctx) {
        this._ctx = ctx;
    }

    public void synchronizeKeyFile(String realmName) throws SynchronizationException {
        String dasName = "server";
        SynchronizationClientImpl sc = new SynchronizationClientImpl(dasName);
        _logger.log(Level.FINEST, "synchronization.done.keyfile.connect", dasName);
        try {
            sc.connect();
        }
        catch (IOException ie) {
            String msg = _localStrMgr.getString("ConnectFailedDAS");
            throw new SynchronizationException(msg);
        }
        String serverName = ApplicationServer.getServerContext().getInstanceName();
        if (serverName == null) {
            String msg = _localStrMgr.getString("CurrInstanceError");
            throw new RuntimeException(msg);
        }
        String keylocation = this.getLocation(serverName, realmName);
        _logger.log(Level.FINEST, "synchronization.done.keyfile.getloc", serverName);
        String[] props = new String[]{"com.sun.aas.instanceRoot"};
        String src = RelativePathResolver.unresolvePath((String)keylocation, (String[])props);
        if (src == null) {
            String msg = _localStrMgr.getString("UnresolvePathError", (Object)keylocation);
            throw new RuntimeException(msg);
        }
        _logger.log(Level.FINEST, _strMgr.getString("synchronization.done.keyfile.unresolve", (Object)keylocation, (Object)src));
        sc.get(src, keylocation);
        _logger.log(Level.FINEST, "synchronization.done.keyfile.get", keylocation);
        try {
            sc.disconnect();
        }
        catch (IOException ie) {
            String msg = _localStrMgr.getString("DisConnectFailedDAS");
            throw new SynchronizationException(msg);
        }
        _logger.log(Level.FINE, "synchronization.done.keyfile.download", keylocation);
    }

    private String getLocation(String serverName, String realmName) throws SynchronizationException {
        try {
            if (this._ctx == null) {
                String msg = _localStrMgr.getString("ContextNotSet");
                throw new RuntimeException(msg);
            }
            Config config = ServerHelper.getConfigForServer((ConfigContext)this._ctx, (String)serverName);
            if (config == null) {
                String msg = _localStrMgr.getString("ConfigElementMissing", (Object)serverName);
                throw new RuntimeException(msg);
            }
            return config.getSecurityService().getAuthRealmByName(realmName).getElementPropertyByName("file").getValue();
        }
        catch (ConfigException ce) {
            String msg = _localStrMgr.getString("GetLocationConfigErr");
            throw new RuntimeException(msg);
        }
    }
}

