/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.synchronization.processor;

import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.ee.synchronization.SynchronizationRequest;
import com.sun.enterprise.ee.synchronization.SynchronizationResponse;
import com.sun.enterprise.ee.synchronization.processor.BaseProcessor;
import com.sun.enterprise.ee.synchronization.processor.RequestContext;
import com.sun.enterprise.ee.util.zip.Zipper;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import java.util.zip.ZipOutputStream;

public class ZipProcessor
extends BaseProcessor {
    private boolean _deleteZipOnExit = true;

    public ZipProcessor(RequestContext ctx) throws IOException {
        this._ctx = ctx;
        this._zipFile = ctx.getZipFile();
        this._fout = new FileOutputStream(this._zipFile);
        this._cos = new CheckedOutputStream(new BufferedOutputStream(this._fout), new CRC32());
        this._out = new ZipOutputStream(this._cos);
    }

    public void setDeleteZipOnExitFlag(boolean tf) {
        this._deleteZipOnExit = tf;
    }

    public boolean getDeleteZipOnExitFlag() {
        return this._deleteZipOnExit;
    }

    void initZipper(SynchronizationRequest req, Zipper z) throws ConfigException {
        this.processAlwaysInclude(req, z);
    }

    void postProcess(long zipSize, SynchronizationRequest[] results) throws IOException {
        this._cos.flush();
        long checksum = this._cos.getChecksum().getValue();
        if (zipSize > 0L) {
            this._out.close();
            this._out = null;
        }
        this._response = new SynchronizationResponse(null, results, checksum, this._ctx.getStartTime(), System.currentTimeMillis());
        if (this._zipFile.exists()) {
            this._response.setZipLocation(this._zipFile.getCanonicalPath());
            this._response.setLastModifiedOfZip(this._zipFile.lastModified());
            if (this._deleteZipOnExit) {
                this._zipFile.deleteOnExit();
            }
            try {
                InetAddress host = InetAddress.getLocalHost();
                this._response.setDasHostName(host.getHostName());
            }
            catch (UnknownHostException uhe) {}
        } else {
            _logger.fine("Zip intended for redirect does not exist: " + this._zipFile.getPath());
        }
    }
}

