/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.util.zip;

import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.logging.LogDomains;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class Unzipper {
    protected static final Logger _logger = LogDomains.getLogger((String)"javax.enterprise.system.util");
    protected static final int BUFFER_SIZE = 65536;
    protected final String _targetDirectory;
    protected final List _ignoreList;
    protected static final String _useNio;
    private static StringManager _localStrMgr;

    public Unzipper(String targetDirectory) {
        this._targetDirectory = targetDirectory;
        this._ignoreList = new ArrayList();
    }

    public void ignoreEntry(String entryName) {
        if (entryName != null) {
            this._ignoreList.add(entryName);
        }
    }

    public boolean isIgnoredEntry(String entryName) {
        return this._ignoreList.contains(entryName);
    }

    public long writeZipBytes(byte[] zipBytes) throws IOException {
        return this.writeZipInputStream(new ByteArrayInputStream(zipBytes));
    }

    public long writeZipFile(String zipFileName) throws IOException, FileNotFoundException {
        return this.writeZipInputStream(new FileInputStream(zipFileName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFileWithNIO(ZipInputStream zin, String fileName, long sz) throws IOException {
        ReadableByteChannel rc = null;
        FileOutputStream out = null;
        try {
            long written;
            rc = Channels.newChannel(zin);
            out = new FileOutputStream(fileName);
            FileChannel fc = out.getChannel();
            int attempts = 0;
            for (long count = 0L; count < sz; count += written) {
                written = fc.transferFrom(rc, count, sz);
                if (written == 0L) {
                    if (++attempts <= 100) continue;
                    String msg = _localStrMgr.getString("NioWriteError", (Object)fileName);
                    throw new IOException(msg);
                }
                attempts = 0;
            }
            out.close();
            out = null;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception ex) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFileWithIO(InputStream zin, String fileName) throws IOException {
        OutputStream out = null;
        byte[] buffer = new byte[65536];
        try {
            out = new BufferedOutputStream(new FileOutputStream(fileName));
            int len = 0;
            while ((len = zin.read(buffer, 0, 65536)) >= 0) {
                out.write(buffer, 0, len);
            }
            out.close();
            out = null;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception ex) {}
            }
        }
    }

    public void writeZipEntry(ZipEntry entry, ZipInputStream zin) throws IOException {
        String fileName = this._targetDirectory + File.separator + entry.getName();
        File file = new File(fileName);
        if (entry.isDirectory()) {
            _logger.fine("[Unzipper] Extracting directory: " + fileName);
            if (!file.exists()) {
                _logger.fine("[Unzipper] Creating Directory: " + file);
                Unzipper.safeMkDirs(file);
            }
        } else {
            long size;
            _logger.fine("[Unzipper] Extracting file: " + fileName);
            File parent = file.getParentFile();
            if (parent != null && !parent.exists()) {
                _logger.fine("[Unzipper] Creating Directory: " + parent);
                Unzipper.safeMkDirs(parent);
            }
            if ((size = entry.getSize()) > 65536L) {
                if (_useNio != null && "false".equalsIgnoreCase(_useNio)) {
                    BufferedInputStream in = new BufferedInputStream(zin, 65536);
                    this.writeFileWithIO(in, fileName);
                } else {
                    this.writeFileWithNIO(zin, fileName, size);
                }
            } else {
                BufferedInputStream in = new BufferedInputStream(zin, 65536);
                this.writeFileWithIO(in, fileName);
            }
            file.setLastModified(entry.getTime());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long writeZipInputStream(InputStream in) throws IOException {
        ZipInputStream zin = null;
        FilterInputStream cis = null;
        ZipEntry entry = null;
        try {
            cis = new CheckedInputStream(in, new CRC32());
            zin = new ZipInputStream(cis);
            entry = zin.getNextEntry();
            while (entry != null) {
                if (this.isIgnoredEntry(entry.getName())) {
                    zin.closeEntry();
                    entry = zin.getNextEntry();
                    continue;
                }
                this.writeZipEntry(entry, zin);
                zin.closeEntry();
                entry = zin.getNextEntry();
            }
            zin.close();
            zin = null;
            long l = ((CheckedInputStream)cis).getChecksum().getValue();
            return l;
        }
        finally {
            if (cis != null) {
                try {
                    cis.close();
                }
                catch (Exception ex) {}
            }
            if (zin != null) {
                try {
                    zin.close();
                }
                catch (Exception ex) {}
            }
        }
    }

    static void safeMkDirs(File dir) {
        boolean created = dir.mkdirs();
        if (!created && !dir.exists()) {
            String normalizedTmp;
            File safeDir;
            String tmp = dir.getPath();
            if (tmp.endsWith(File.separator + ".")) {
                tmp = tmp.substring(0, tmp.length() - 2);
            }
            if (!(created = (safeDir = new File(normalizedTmp = Unzipper.normalizePath(tmp))).mkdirs()) && !safeDir.exists()) {
                String msg = _localStrMgr.getString("DirNotCreated", (Object)normalizedTmp);
                throw new RuntimeException(msg);
            }
        }
    }

    public static void usage() {
        System.out.println("usage: zip-file-name directory-name");
        System.exit(1);
    }

    public static void main(String[] argv) {
        try {
            if (argv.length != 2) {
                Unzipper.usage();
            }
            Unzipper z = new Unzipper(argv[1]);
            z.writeZipFile(argv[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static String normalizePath(String path) {
        if (path == null) {
            return path;
        }
        if (File.separatorChar == '\\') {
            if (path.indexOf(47) >= 0) {
                _logger.fine("[Unzipper] Path contains forward slash. Normalizing: " + path);
            }
            path = FileUtils.makeForwardSlashes((String)path);
            path = path.replaceAll("/\\./", "/");
            return path.replace('/', '\\');
        }
        path = FileUtils.makeForwardSlashes((String)path);
        return path.replaceAll(File.separator + "\\." + File.separator, File.separator);
    }

    static {
        String useNioTemp = null;
        try {
            useNioTemp = System.getProperty("com.sun.appserv.zip.nio");
        }
        catch (Exception e) {
            _logger.log(Level.FINE, "[Unzipper] Error while initializing system environment variable: com.sun.appserv.zip.nio", e);
        }
        _useNio = useNioTemp;
        _localStrMgr = StringManager.getManager(Unzipper.class);
    }
}

