/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.web.sessmgmt;

import com.sun.appserv.ha.spi.BackingStoreRegistry;
import com.sun.appserv.ha.util.PersistenceTypeResolver;
import com.sun.enterprise.ee.web.sessmgmt.JxtaStarter;
import com.sun.enterprise.web.ServerConfigLookup;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EEPersistenceTypeResolver
implements PersistenceTypeResolver {
    public static final String FILE_TYPE = "file";
    public static final String MEMORY_TYPE = "memory";
    public static final String HA_TYPE = "ha";
    public static final String REPLICATED_TYPE = "replicated";
    private static final List PREDEFINED_PERSISTENCE_TYPES = Arrays.asList("file", "memory", "ha", "replicated");
    private static final List PREDEFINED_NO_HADB_PERSISTENCE_TYPES = Arrays.asList("file", "memory", "replicated");
    private static final List PREDEFINED_EJB_NO_HADB_PERSISTENCE_TYPES = Arrays.asList("file", "replicated");
    private static final List NON_REPLICATED_PREDEFINED_PERSISTENCE_TYPES = Arrays.asList("file", "memory", "ha");
    private static final List NON_REPLICATED_NO_HADB_PREDEFINED_PERSISTENCE_TYPES = Arrays.asList("file", "memory");
    private static final List NON_REPLICATED_EJB_PREDEFINED_PERSISTENCE_TYPES = Arrays.asList("file", "ha");
    private static final List NON_REPLICATED_NO_HADB_EJB_PREDEFINED_PERSISTENCE_TYPES = Arrays.asList("file");
    private static final Logger _logger = LogDomains.getLogger((String)"javax.enterprise.system.container.web");

    private boolean isReplicatedType(String type) {
        return REPLICATED_TYPE.equals(type);
    }

    private boolean isPredefinedType(String type) {
        return PREDEFINED_PERSISTENCE_TYPES.contains(type);
    }

    private boolean isNonReplicatedPredefinedType(String type) {
        return NON_REPLICATED_PREDEFINED_PERSISTENCE_TYPES.contains(type);
    }

    private boolean isNonReplicatedEjbPredefinedType(String type) {
        return NON_REPLICATED_EJB_PREDEFINED_PERSISTENCE_TYPES.contains(type);
    }

    private boolean checkGMS() {
        JxtaStarter jxtaStarter = JxtaStarter.createInstance();
        return jxtaStarter.checkGMS();
    }

    public boolean isRegisteredType(String type) {
        Collection<String> registeredTypes = this.getRegisteredTypes();
        return registeredTypes.contains(type);
    }

    private Collection<String> getRegisteredTypes() {
        BackingStoreRegistry backingStoreRegistry = BackingStoreRegistry.getInstance();
        Collection registeredTypes = backingStoreRegistry.getRegisteredTypes();
        String[] regTypesArray = registeredTypes.toArray(new String[0]);
        ArrayList<String> regTypesList = new ArrayList<String>();
        for (int i = 0; i < regTypesArray.length; ++i) {
            regTypesList.add(regTypesArray[i]);
        }
        regTypesList.add(REPLICATED_TYPE);
        return regTypesList;
    }

    public String resolvePersistenceType(String persistenceType) {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("Resolving persistenceType:" + persistenceType);
        }
        if (HA_TYPE.equalsIgnoreCase(persistenceType) && !ServerConfigLookup.isHADBInstalled()) {
            return MEMORY_TYPE;
        }
        if (this.isNonReplicatedPredefinedType(persistenceType)) {
            return persistenceType;
        }
        if (!this.isNativeReplicationEnabled()) {
            return MEMORY_TYPE;
        }
        if (this.isReplicatedType(persistenceType)) {
            return persistenceType;
        }
        if (this.isRegisteredType(persistenceType)) {
            return REPLICATED_TYPE;
        }
        return MEMORY_TYPE;
    }

    public String resolvePersistenceTypeForEjb(String persistenceType) {
        if (HA_TYPE.equalsIgnoreCase(persistenceType) && !ServerConfigLookup.isHADBInstalled()) {
            return FILE_TYPE;
        }
        if (this.isNonReplicatedEjbPredefinedType(persistenceType)) {
            return persistenceType;
        }
        if (!this.isNativeReplicationEnabled()) {
            return FILE_TYPE;
        }
        if (this.isReplicatedType(persistenceType)) {
            return persistenceType;
        }
        if (this.isRegisteredType(persistenceType)) {
            return REPLICATED_TYPE;
        }
        return FILE_TYPE;
    }

    private boolean isNativeReplicationEnabled() {
        ServerConfigLookup lookup = new ServerConfigLookup();
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("GMS ENABLED:" + lookup.isGMSEnabled());
            _logger.finest("NATIVE REPLICATION ENABLED:" + lookup.isNativeReplicationEnabledFromConfig());
        }
        return lookup.isGMSEnabled() && lookup.isNativeReplicationEnabledFromConfig();
    }

    public List getWebDefinedPersistenceTypes() {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(this.getNonReplicatedPredefinedPersistenceTypes());
        result.addAll(this.getRegisteredTypes());
        return result;
    }

    private List getNonReplicatedPredefinedPersistenceTypes() {
        if (ServerConfigLookup.isHADBInstalled()) {
            return NON_REPLICATED_PREDEFINED_PERSISTENCE_TYPES;
        }
        return NON_REPLICATED_NO_HADB_PREDEFINED_PERSISTENCE_TYPES;
    }

    public List getEjbDefinedPersistenceTypes() {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(this.getNonReplicatedEjbPredefinedPersistenceTypes());
        result.addAll(this.getRegisteredTypes());
        return result;
    }

    private List getNonReplicatedEjbPredefinedPersistenceTypes() {
        if (ServerConfigLookup.isHADBInstalled()) {
            return NON_REPLICATED_EJB_PREDEFINED_PERSISTENCE_TYPES;
        }
        return NON_REPLICATED_NO_HADB_EJB_PREDEFINED_PERSISTENCE_TYPES;
    }
}

