/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.web.sessmgmt;

import com.sun.enterprise.ee.cms.core.CallBack;
import com.sun.enterprise.ee.cms.core.Signal;
import com.sun.enterprise.ee.web.sessmgmt.JxtaReplicationReceiver;
import com.sun.enterprise.ee.web.sessmgmt.ReplicationHealthChecker;
import com.sun.logging.LogDomains;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FailureSuspectedNotificationEventHandler
implements CallBack {
    private static final Logger _logger = LogDomains.getLogger((String)"javax.enterprise.system.container.web");
    private static HashMap suspectedFailures = new HashMap();

    public void processNotification(Signal notification) {
        String failedPartnerInstance = notification.getMemberToken();
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("Received Suspected Failure Notification: " + failedPartnerInstance);
        }
        FailureSuspectedNotificationEventHandler.checkSuspectedFailureFor(failedPartnerInstance);
    }

    static boolean isSuspectedFailureCredible(String instanceName) {
        long timeNow = System.currentTimeMillis();
        Long suspectedFailureTimeMillis = (Long)suspectedFailures.get(instanceName);
        if (suspectedFailureTimeMillis != null) {
            FailureSuspectedNotificationEventHandler.removeSuspectedFailure(instanceName);
            if (timeNow - suspectedFailureTimeMillis < 6000L) {
                System.out.println("credible suspected failure of " + instanceName);
                return true;
            }
            System.out.println("suspected failure is not pending or more than 6 sec old");
            FailureSuspectedNotificationEventHandler.addSuspectedFailure(instanceName);
            return false;
        }
        System.out.println("Received Suspected Failure Notification: adding suspected failure for" + instanceName);
        FailureSuspectedNotificationEventHandler.addSuspectedFailure(instanceName);
        return false;
    }

    static void addSuspectedFailure(String instanceName) {
        suspectedFailures.put(instanceName, new Long(System.currentTimeMillis()));
    }

    static void removeSuspectedFailure(String instanceName) {
        suspectedFailures.remove(instanceName);
    }

    static void checkSuspectedFailureFor(String instanceName) {
        if (!FailureSuspectedNotificationEventHandler.isSuspectedFailureCredible(instanceName)) {
            return;
        }
        if (!ReplicationHealthChecker.isStopping()) {
            JxtaReplicationReceiver jxtaReplicationReceiver = (JxtaReplicationReceiver)ReplicationHealthChecker.getReplicationReceiver();
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("suspected failure notification causing call to respondToFailure");
            }
            jxtaReplicationReceiver.respondToFailure(instanceName);
        }
    }
}

