/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.web.sessmgmt;

import com.sun.enterprise.ee.web.sessmgmt.RepairAgent;
import com.sun.enterprise.ee.web.sessmgmt.ReplicationHealthChecker;
import com.sun.enterprise.ee.web.sessmgmt.ReplicationManager;
import com.sun.enterprise.ee.web.sessmgmt.ReplicationManagerBase;
import com.sun.enterprise.ee.web.sessmgmt.ReplicationResponseRepository;
import com.sun.enterprise.ee.web.sessmgmt.ReplicationState;
import com.sun.enterprise.web.EmbeddedWebContainer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Manager;
import org.apache.catalina.Valve;
import org.apache.catalina.core.ContainerBase;

public class ReplicationMessageRouter
implements RepairAgent {
    public static final String LOGGER_MEM_REP = "com.sun.enterprise.ee.web.sessmgmt";
    private static final Logger _logger = Logger.getLogger("com.sun.enterprise.ee.web.sessmgmt");
    protected static final ConcurrentHashMap _appId2Container = new ConcurrentHashMap();
    private Set replicationManagerSet = new HashSet();
    private static ReplicationMessageRouter _soleInstance = null;
    protected EmbeddedWebContainer _embedded = null;
    private static final Object _monitor = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ReplicationMessageRouter createInstance() {
        Object object = _monitor;
        synchronized (object) {
            if (_soleInstance == null) {
                _soleInstance = new ReplicationMessageRouter();
            }
        }
        return _soleInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ReplicationMessageRouter createInstance(EmbeddedWebContainer embedded) {
        Object object = _monitor;
        synchronized (object) {
            if (_soleInstance == null) {
                _soleInstance = new ReplicationMessageRouter(embedded);
            } else {
                ReplicationMessageRouter._soleInstance._embedded = embedded;
            }
        }
        return _soleInstance;
    }

    public ReplicationMessageRouter(EmbeddedWebContainer embedded) {
        this._embedded = embedded;
    }

    public ReplicationMessageRouter() {
    }

    public void addReplicationManager(String appid, ReplicationManager container) {
        _appId2Container.put(appid, container);
        this.replicationManagerSet.add(container);
    }

    public ReplicationManager removeReplicationManager(String appid) {
        ReplicationManager removedMgr = (ReplicationManager)_appId2Container.remove(appid);
        this.replicationManagerSet.remove(removedMgr);
        return removedMgr;
    }

    private ReplicationManager getReplicationManager(String appid) {
        return (ReplicationManager)_appId2Container.get(appid);
    }

    public ReplicationManager[] getReplicationManagerArray() {
        ArrayList<ReplicationManager> replicationManagerList = new ArrayList<ReplicationManager>(this.replicationManagerSet.size());
        for (ReplicationManager nextReplicationManager : this.replicationManagerSet) {
            replicationManagerList.add(nextReplicationManager);
        }
        ReplicationManager[] results = null;
        results = new ReplicationManager[this.replicationManagerSet.size()];
        results = replicationManagerList.toArray(results);
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Enumeration getReplicationAppIds(boolean printIt) {
        Enumeration applicationIds = null;
        if (_appId2Container != null) {
            ConcurrentHashMap concurrentHashMap = _appId2Container;
            synchronized (concurrentHashMap) {
                applicationIds = _appId2Container.keys();
            }
        }
        if (printIt) {
            int i = 0;
            while (applicationIds.hasMoreElements()) {
                String nextAppId = (String)applicationIds.nextElement();
                System.out.println("appid-key[" + i + "]= " + nextAppId);
                System.out.println("appid-key-length[" + i + "]= " + nextAppId.length());
                ++i;
            }
        }
        return applicationIds;
    }

    public ReplicationManager findApp(String appName) {
        if (appName == null) {
            return null;
        }
        ReplicationManager mgr = this.getReplicationManager(appName);
        return mgr;
    }

    public void repairApps(long repairStartTime) {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("ReplicationMessageRouter:repairApps");
        }
        this.eagerlyLoadRoutingMap();
        ReplicationManager[] apps = this.getReplicationManagerArray();
        for (int i = 0; i < apps.length && !ReplicationHealthChecker.isStopping(); ++i) {
            ReplicationManager nextMgr = apps[i];
            nextMgr.repair(repairStartTime);
        }
    }

    public void repairApps(long repairStartTime, boolean checkForStopping) {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("ReplicationMessageRouter:repairApps: checkForStopping: " + checkForStopping);
        }
        if (!checkForStopping) {
            this.eagerlyLoadRoutingMap();
        }
        ReplicationManager[] apps = this.getReplicationManagerArray();
        for (int i = 0; !(i >= apps.length || checkForStopping && ReplicationHealthChecker.isStopping()); ++i) {
            ReplicationManager nextMgr = apps[i];
            nextMgr.repair(repairStartTime, checkForStopping);
        }
    }

    public void processMessage(ReplicationState state) {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("ReplicationMessageRouter:processMessage:state=" + state);
        }
        if (state.isReturnMessage() || state.isVoidMethodReturnState()) {
            // empty if block
        }
        if (state.isHCReturnMessage()) {
            this.processResponse(state);
            return;
        }
        this.routeMessageForApp(state.getAppId(), state);
    }

    public void processResponse(ReplicationState message) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("IN" + this.getClass().getName() + ">>processResponse");
        }
        ReplicationResponseRepository.putEntry(message);
    }

    public void routeMessageForApp(String appName, ReplicationState message) {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("ReplicationMessageRouter:routeMessageForApp" + appName);
        }
        ReplicationManager mgr = null;
        mgr = this.findApp(appName);
        if (mgr != null) {
            mgr.processMessage(message);
            return;
        }
        if (this._embedded == null) {
            return;
        }
        boolean continueProcessing = true;
        try {
            Engine[] engines = this._embedded.getEngines();
            for (int h = 0; h < engines.length; ++h) {
                Engine engine = engines[h];
                Container[] hosts = engine.findChildren();
                block3: for (int i = 0; i < hosts.length; ++i) {
                    Container nextHost = hosts[i];
                    Container[] webModules = nextHost.findChildren();
                    for (int j = 0; j < webModules.length; ++j) {
                        Container nextWebModule = webModules[j];
                        Context ctx = (Context)nextWebModule;
                        Manager nextManager = nextWebModule.getManager();
                        if (!(nextManager instanceof ReplicationManager)) continue;
                        String nextAppName = ((ReplicationManagerBase)nextManager).getApplicationId();
                        if (_logger.isLoggable(Level.FINEST)) {
                            _logger.finest("ReplicationMessageRouter:routeMessageForApp:nextAppName = " + nextAppName + ", appName = " + appName);
                        }
                        if (!nextAppName.equals(appName)) continue;
                        if (_logger.isLoggable(Level.FINEST)) {
                            _logger.finest("ReplicationMessageRouter:routeMessageForApp:found our manager:" + nextManager.getClass().getName());
                        }
                        this.addReplicationManager(appName, (ReplicationManager)nextManager);
                        ((ReplicationManager)nextManager).processMessage(message);
                        continueProcessing = false;
                        break;
                    }
                    if (!continueProcessing) break;
                    Valve[] valves = ((ContainerBase)nextHost).getValves();
                    for (int k = 0; k < valves.length; ++k) {
                        Valve nextValve = valves[k];
                        if (_logger.isLoggable(Level.FINEST)) {
                            _logger.finest("ReplicationMessageRouter:routeMessageForApp:VALVE = " + nextValve.getClass().getName());
                        }
                        if (!(nextValve instanceof ReplicationManager)) continue;
                        String nextAppName = ((ReplicationManager)nextValve).getApplicationId();
                        if (_logger.isLoggable(Level.FINEST)) {
                            _logger.finest("ReplicationMessageRouter:routeMessageForApp:nextAppName = " + nextAppName + ", appName = " + appName);
                        }
                        if (!nextAppName.equals(appName)) continue;
                        if (_logger.isLoggable(Level.FINEST)) {
                            _logger.finest("ReplicationMessageRouter:routeMessageForApp:found our manager:" + nextValve.getClass().getName());
                        }
                        this.addReplicationManager(appName, (ReplicationManager)nextValve);
                        ((ReplicationManager)nextValve).processMessage(message);
                        continueProcessing = false;
                        continue block3;
                    }
                }
                if (continueProcessing) {
                    continue;
                }
                break;
            }
        }
        catch (Throwable th) {
            _logger.log(Level.SEVERE, "Exception thrown", th);
        }
    }

    public void eagerlyLoadRoutingMap() {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("ReplicationMessageRouter>>eagerlyLoadRoutingMap");
        }
        Object mgr = null;
        boolean continueProcessing = true;
        try {
            Engine[] engines = this._embedded.getEngines();
            for (int h = 0; h < engines.length; ++h) {
                Engine engine = engines[h];
                Container[] hosts = engine.findChildren();
                for (int i = 0; i < hosts.length; ++i) {
                    Container nextHost = hosts[i];
                    Container[] webModules = nextHost.findChildren();
                    for (int j = 0; j < webModules.length; ++j) {
                        Container nextWebModule = webModules[j];
                        Context ctx = (Context)nextWebModule;
                        Manager nextManager = nextWebModule.getManager();
                        if (!(nextManager instanceof ReplicationManager)) continue;
                        String nextAppName = ((ReplicationManagerBase)nextManager).getApplicationId();
                        if (_logger.isLoggable(Level.FINEST)) {
                            _logger.finest("ReplicationMessageRouter:eagerlyLoadRoutingMap:nextAppName = " + nextAppName);
                        }
                        if (_logger.isLoggable(Level.FINEST)) {
                            _logger.finest("ReplicationMessageRouter:eagerlyLoadRoutingMap:found our manager:" + nextManager.getClass().getName());
                        }
                        this.addReplicationManager(nextAppName, (ReplicationManager)nextManager);
                    }
                    if (!continueProcessing) break;
                    Valve[] valves = ((ContainerBase)nextHost).getValves();
                    for (int k = 0; k < valves.length; ++k) {
                        Valve nextValve = valves[k];
                        if (_logger.isLoggable(Level.FINEST)) {
                            _logger.finest("ReplicationMessageRouter:eagerlyLoadRoutingMap:VALVE = " + nextValve.getClass().getName());
                        }
                        if (!(nextValve instanceof ReplicationManager)) continue;
                        String nextAppName = ((ReplicationManager)nextValve).getApplicationId();
                        if (_logger.isLoggable(Level.FINEST)) {
                            _logger.finest("ReplicationMessageRouter:eagerlyLoadRoutingMap:found our manager:" + nextValve.getClass().getName());
                        }
                        this.addReplicationManager(nextAppName, (ReplicationManager)nextValve);
                    }
                }
                if (continueProcessing) {
                    continue;
                }
                break;
            }
        }
        catch (Throwable th) {
            _logger.log(Level.SEVERE, "Exception thrown", th);
        }
    }

    public void processQueryMessage(ReplicationState message, String returnInstance) {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("ReplicationMessageRouter:processQueryMessage");
        }
        this.routeQueryMessageForApp(message.getAppId(), message, returnInstance);
    }

    public void routeQueryMessageForApp(String appName, ReplicationState message, String returnInstance) {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("ReplicationMessageRouter:routeQueryMessageForApp" + appName);
        }
        if (this._embedded == null) {
            return;
        }
        ReplicationManager mgr = null;
        mgr = this.findApp(appName);
        if (mgr != null) {
            mgr.processQueryMessage(message, returnInstance);
            return;
        }
        boolean continueProcessing = true;
        try {
            Engine[] engines = this._embedded.getEngines();
            for (int h = 0; h < engines.length; ++h) {
                Engine engine = engines[h];
                Container[] hosts = engine.findChildren();
                block3: for (int i = 0; i < hosts.length; ++i) {
                    Container nextHost = hosts[i];
                    Container[] webModules = nextHost.findChildren();
                    for (int j = 0; j < webModules.length; ++j) {
                        Container nextWebModule = webModules[j];
                        Context ctx = (Context)nextWebModule;
                        Manager nextManager = nextWebModule.getManager();
                        if (!(nextManager instanceof ReplicationManager)) continue;
                        String nextAppName = ((ReplicationManagerBase)nextManager).getApplicationId();
                        if (_logger.isLoggable(Level.FINEST)) {
                            _logger.finest("ReplicationMessageRouter:routeQueryMessageForApp:nextAppName = " + nextAppName + ", appName = " + appName);
                        }
                        if (!nextAppName.equals(appName)) continue;
                        if (_logger.isLoggable(Level.FINEST)) {
                            _logger.finest("ReplicationMessageRouter:routeQueryMessageForApp:found our manager:" + nextManager.getClass().getName());
                        }
                        this.addReplicationManager(appName, (ReplicationManager)nextManager);
                        ((ReplicationManager)nextManager).processQueryMessage(message, returnInstance);
                        continueProcessing = false;
                        break;
                    }
                    if (!continueProcessing) break;
                    Valve[] valves = ((ContainerBase)nextHost).getValves();
                    for (int k = 0; k < valves.length; ++k) {
                        Valve nextValve = valves[k];
                        if (_logger.isLoggable(Level.FINEST)) {
                            _logger.finest("ReplicationMessageRouter:routeQueryMessageForApp:VALVE = " + nextValve.getClass().getName());
                        }
                        if (!(nextValve instanceof ReplicationManager)) continue;
                        String nextAppName = ((ReplicationManager)nextValve).getApplicationId();
                        if (_logger.isLoggable(Level.FINEST)) {
                            _logger.finest("ReplicationMessageRouter:routeQueryMessageForApp:nextAppName = " + nextAppName + ", appName = " + appName);
                        }
                        if (!nextAppName.equals(appName)) continue;
                        if (_logger.isLoggable(Level.FINEST)) {
                            _logger.finest("ReplicationMessageRouter:routeQueryMessageForApp:found our manager:" + nextValve.getClass().getName());
                        }
                        this.addReplicationManager(appName, (ReplicationManager)nextValve);
                        ((ReplicationManager)nextValve).processQueryMessage(message, returnInstance);
                        continueProcessing = false;
                        continue block3;
                    }
                }
                if (continueProcessing) {
                    continue;
                }
                break;
            }
        }
        catch (Throwable th) {
            _logger.log(Level.SEVERE, "Exception thrown", th);
        }
    }
}

