/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.monitor.callflow;

import com.sun.enterprise.admin.monitor.callflow.TraceOnHelper;
import com.sun.enterprise.admin.monitor.callflow.TransferObject;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CallflowProducerQueue {
    private static final Logger logger = Logger.getLogger("javax.enterprise.system.tools.admin");
    boolean traceOn = false;
    int qSize = 10;
    private String name;
    double THRESHOLD_PERCENTAGE = 0.8;
    long threshold = 8L;
    AtomicInteger CURRENT_SIZE = new AtomicInteger(0);
    AtomicBoolean NOTIFIED_CONSUMER = new AtomicBoolean(false);
    AtomicLong entriesProcessed = new AtomicLong(0L);
    ConcurrentLinkedQueue<TransferObject> producerQ = new ConcurrentLinkedQueue();
    private BlockingQueue<CallflowProducerQueue> consumerQ;

    public static CallflowProducerQueue getInstance(BlockingQueue<CallflowProducerQueue> consumerQ, String name, int qSize) {
        return new CallflowProducerQueue(consumerQ, name, qSize);
    }

    private CallflowProducerQueue(BlockingQueue<CallflowProducerQueue> consumerQ, String name, int qSize) {
        this.consumerQ = consumerQ;
        this.name = name;
        this.qSize = qSize;
        this.traceOn = TraceOnHelper.isTraceOn();
    }

    public void add(TransferObject to) {
        this.producerQ.add(to);
        int current = this.CURRENT_SIZE.incrementAndGet();
        if (this.traceOn) {
            logger.log(Level.INFO, "Callflow:CallflowProducerQ.add : " + this.name + " adding row ; QSize = " + current + " ThresholdSize = " + this.threshold);
        }
        if ((long)current >= this.threshold) {
            this.flush();
        }
    }

    public TransferObject[] getAndRemoveAll() {
        int current = this.CURRENT_SIZE.get();
        if (current == 0) {
            return null;
        }
        TransferObject[] to = new TransferObject[current];
        for (int i = 0; i < current; ++i) {
            to[i] = this.producerQ.poll();
        }
        long numOfEntries = this.CURRENT_SIZE.longValue();
        this.CURRENT_SIZE.set(this.CURRENT_SIZE.get() - current);
        this.NOTIFIED_CONSUMER.set(false);
        this.entriesProcessed.addAndGet(numOfEntries);
        if (this.traceOn) {
            logger.log(Level.INFO, "Callflow: CallflowProducerQ.getAndRemoveAll:" + this.name + " Old Q Size = " + current + " New Q Size = " + this.CURRENT_SIZE.get() + " Notified ConsumerQ reset to false." + " Entries Processed so far = " + this.entriesProcessed.longValue());
        }
        return to;
    }

    public void flush() {
        if (this.CURRENT_SIZE.get() <= 0) {
            return;
        }
        boolean notified = this.NOTIFIED_CONSUMER.get();
        if (!notified) {
            try {
                this.consumerQ.put(this);
                this.NOTIFIED_CONSUMER.set(true);
                if (this.traceOn) {
                    logger.log(Level.INFO, "Callflow: CallflowProducerQ.flush:" + this.name + " notifying ConsumerQ ");
                }
            }
            catch (InterruptedException interruptedException) {}
        } else if (this.traceOn) {
            logger.log(Level.INFO, "Callflow: CallflowProducerQ.flush : " + this.name + " " + "ConsumerPreviouslyNotified? " + notified + " Not renotifying the consumer.");
        }
    }

    public void setQSize(int size) {
        this.qSize = size;
        this.calculateThreshold();
    }

    public int getQSize() {
        return this.qSize;
    }

    public int getCurrentSize() {
        return this.CURRENT_SIZE.intValue();
    }

    private void calculateThreshold() {
        this.threshold = Math.round(this.THRESHOLD_PERCENTAGE * (double)this.qSize);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getEntriesProcessed() {
        return this.entriesProcessed.longValue();
    }
}

