/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.monitor.jndi;

import com.sun.enterprise.util.i18n.StringManager;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;

public class JndiMBeanHelper {
    private InitialContext context;
    private static final Logger logger = Logger.getLogger("javax.enterprise.system.tools.admin");
    private static final StringManager sm = StringManager.getManager(JndiMBeanHelper.class);
    private final String SYSTEM_SUBCONTEXT = "__SYSTEM";

    public JndiMBeanHelper() {
        this.initialize();
    }

    void initialize() {
        try {
            this.context = new InitialContext();
        }
        catch (NamingException e) {
            logger.log(Level.WARNING, e.getMessage(), e);
        }
    }

    ArrayList getJndiEntriesByContextPath(String contextPath) throws NamingException {
        ArrayList names = new ArrayList();
        NamingEnumeration<NameClassPair> ee = null;
        if (contextPath == null) {
            contextPath = "";
        }
        try {
            ee = this.context.list(contextPath);
        }
        catch (NameNotFoundException e) {
            String msg = sm.getString("monitor.jndi.context_notfound", new Object[]{contextPath});
            logger.log(Level.WARNING, msg);
            NamingException ne = new NamingException(msg);
            System.out.println("Exception print: " + ne);
            throw ne;
        }
        names = this.toNameClassPairArray(ee);
        return names;
    }

    ArrayList toNameClassPairArray(NamingEnumeration ee) throws NamingException {
        ArrayList names = new ArrayList();
        while (ee.hasMore()) {
            Object o = ee.next();
            if (o.toString().indexOf("__SYSTEM") != -1) continue;
            names.add(o);
        }
        return names;
    }
}

