/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.util;

import com.sun.enterprise.admin.util.Assert;
import com.sun.enterprise.admin.util.IStringSource;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class PropertiesStringSource
implements IStringSource {
    private Properties mProperties;

    public PropertiesStringSource(Properties p) {
        this.initialize(p);
    }

    public PropertiesStringSource(InputStream is) throws IOException {
        this.initialize(is);
    }

    public PropertiesStringSource(File f) throws IOException {
        this.initialize(f);
    }

    public PropertiesStringSource(String filename) throws IOException {
        this.initialize(filename);
    }

    public String getString(String key) {
        Assert.assertit(this.mProperties != null, "invalid state:  mProperties is null");
        return this.mProperties.getProperty(key);
    }

    protected PropertiesStringSource() {
    }

    protected void initialize(Properties properties) {
        this.mProperties = properties;
    }

    protected void initialize(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        this.initialize(fis);
    }

    protected void initialize(String filename) throws IOException {
        this.initialize(new File(filename));
    }

    protected void initialize(InputStream is) throws IOException {
        this.mProperties = new Properties();
        this.mProperties.load(is);
    }
}

