/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.wsmgmt.registry;

import com.sun.appserv.management.DomainRoot;
import com.sun.appserv.management.client.ProxyFactory;
import com.sun.appserv.management.config.ConnectorConnectionPoolConfig;
import com.sun.appserv.management.config.ConnectorResourceConfig;
import com.sun.appserv.management.config.DomainConfig;
import com.sun.appserv.management.config.EJBModuleConfig;
import com.sun.appserv.management.config.J2EEApplicationConfig;
import com.sun.appserv.management.config.ModuleConfig;
import com.sun.appserv.management.config.RegistryLocationConfig;
import com.sun.appserv.management.config.ResourceAdapterConfig;
import com.sun.appserv.management.config.WebModuleConfig;
import com.sun.appserv.management.config.WebServiceEndpointConfig;
import com.sun.enterprise.admin.common.MBeanServerFactory;
import com.sun.enterprise.util.io.FileUtils;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigHelper {
    private static final Logger _logger = Logger.getLogger("javax.enterprise.system.tools.admin");
    private static final String POOL_SUFFIX = "__pool";
    private static final String DEFAULT_JAXR_RAR = "jaxr-ra";
    private static final String ignore_ra = "jmsra";
    public static final String UDDI_PROPERTY = "com.sun.appserv.registry.uddi";
    public static final String EBXML_PROPERTY = "com.sun.appserv.registry.ebxml";
    public static final String APPSERVER_UDDI = "AppserverUDDI";
    public static final String APPSERVER_EBXML = "AppserverEBXML";
    public static final String JAXR_REGISTRY_TYPE = "javax.xml.registry.ConnectionFactory";
    private static final String UDDI_JAXR_REGISTRY_TYPE = "com.sun.connector.jaxr.JaxrConnectionFactory";
    private static final String LifeCycleManagerURL = "LifeCycleManagerURL";
    private static final String QueryManagerURL = "QueryManagerURL";
    private Map webServiceInfoMap = null;
    private static final String INSTANCE_PORT_MBEAN_NAME = "com.sun.appserv:type=http-listener,id=http-listener-1,config=server-config,category=config";

    private ConfigHelper(Map webServiceInfo) {
        this.webServiceInfoMap = webServiceInfo;
    }

    private ConfigHelper() {
    }

    public static ConfigHelper getInstanceToUpdateConfig(Map webServiceInfo) {
        return new ConfigHelper(webServiceInfo);
    }

    public static ConfigHelper getInstanceToDeleteRegistryResources() {
        return new ConfigHelper();
    }

    public static ConfigHelper getInstanceToQueryRegistryLocations() {
        return new ConfigHelper();
    }

    void addToConfig(String webServiceName, Map<String, String> published) {
        if (this.webServiceInfoMap == null) {
            _logger.fine("ConfigHelper.addToConfig : Incorrect webServiceName ");
            return;
        }
        DomainConfig dc = this.getDomainConfig();
        String appId = (String)this.webServiceInfoMap.get("AppID");
        Boolean isStandAlone = (Boolean)this.webServiceInfoMap.get("IsAppStandAloneModule");
        String appName = appId;
        String pureWebServiceName = this.dropAppNameFromWebServiceName(webServiceName);
        String underScoredWebServiceName = this.convertHashesToUnderScores(webServiceName);
        WebServiceEndpointConfig wsec = null;
        if (!isStandAlone.booleanValue()) {
            Map<String, J2EEApplicationConfig> map = dc.getJ2EEApplicationConfigMap();
            J2EEApplicationConfig appConfig = map.get(appName);
            if (appConfig == null) {
                _logger.log(Level.FINE, "Could not find an application with  name = " + appName);
            } else {
                Map<String, WebServiceEndpointConfig> wsmap = appConfig.getWebServiceEndpointConfigMap();
                wsec = wsmap.get(pureWebServiceName);
                if (wsec == null) {
                    wsec = appConfig.createWebServiceEndpointConfig(pureWebServiceName, null);
                    wsec.setJBIEnabled(false);
                }
                for (String jndiname : published.keySet()) {
                    appConfig.createProperty(jndiname + "__" + underScoredWebServiceName, published.get(jndiname));
                }
            }
        } else {
            String type = (String)this.webServiceInfoMap.get("ServiceImplType");
            if (type.equals("EJB")) {
                Map<String, EJBModuleConfig> map = dc.getEJBModuleConfigMap();
                EJBModuleConfig ejbConfig = map.get(appName);
                if (ejbConfig == null) {
                    _logger.log(Level.FINE, "Could not find a ejb module with  name = " + appName);
                } else {
                    Map<String, WebServiceEndpointConfig> ejbmap = ejbConfig.getWebServiceEndpointConfigMap();
                    wsec = ejbmap.get(pureWebServiceName);
                    if (wsec == null) {
                        wsec = ejbConfig.createWebServiceEndpointConfig(pureWebServiceName, null);
                        wsec.setJBIEnabled(false);
                    }
                    for (String jndiname : published.keySet()) {
                        ejbConfig.createProperty(jndiname + "__" + underScoredWebServiceName, published.get(jndiname));
                    }
                }
            } else if (type.equals("SERVLET")) {
                Map<String, WebModuleConfig> map = dc.getWebModuleConfigMap();
                WebModuleConfig webConfig = map.get(appName);
                if (webConfig == null) {
                    _logger.log(Level.FINE, "Could not find a web module with  name = " + appName);
                } else {
                    Map<String, WebServiceEndpointConfig> webmap = webConfig.getWebServiceEndpointConfigMap();
                    wsec = webmap.get(pureWebServiceName);
                    if (wsec == null) {
                        wsec = webConfig.createWebServiceEndpointConfig(pureWebServiceName, null);
                        wsec.setJBIEnabled(false);
                    }
                    for (String jndiname : published.keySet()) {
                        webConfig.createProperty(jndiname + "__" + underScoredWebServiceName, published.get(jndiname));
                    }
                }
            }
        }
        if (wsec != null) {
            String[] registryLocations = new String[published.size()];
            registryLocations = published.keySet().toArray(registryLocations);
            this.populateWebServiceEndpointConfig(wsec, registryLocations);
        }
    }

    void populateWebServiceEndpointConfig(WebServiceEndpointConfig wsec, String[] registryLocations) {
        for (String jndi : registryLocations) {
            wsec.createRegistryLocationConfig(jndi);
        }
    }

    void deleteFromConfig(String webServiceName, String[] registryLocations) {
        if (this.webServiceInfoMap == null) {
            _logger.fine("ConfigHelper.deletFromConfig : Incorrect webServiceName. Exiting! ");
            return;
        }
        DomainConfig dc = this.getDomainConfig();
        String appId = (String)this.webServiceInfoMap.get("AppID");
        Boolean isStandAlone = (Boolean)this.webServiceInfoMap.get("IsAppStandAloneModule");
        String pureWebServiceName = this.dropAppNameFromWebServiceName(webServiceName);
        String underScoredWebServiceName = this.convertHashesToUnderScores(webServiceName);
        WebServiceEndpointConfig wsec = null;
        if (!isStandAlone.booleanValue()) {
            Map<String, J2EEApplicationConfig> appMap = dc.getJ2EEApplicationConfigMap();
            J2EEApplicationConfig config = appMap.get(appId);
            Map<String, WebServiceEndpointConfig> wsecMap = config.getWebServiceEndpointConfigMap();
            wsec = wsecMap.get(pureWebServiceName);
            for (int i = 0; i < registryLocations.length; ++i) {
                String jndiname = registryLocations[i];
                config.removeProperty(jndiname + "__" + underScoredWebServiceName);
            }
        } else {
            String jndiname;
            ModuleConfig config;
            String type = (String)this.webServiceInfoMap.get("ServiceImplType");
            if (type.equals("EJB")) {
                Map<String, EJBModuleConfig> ejbMap = dc.getEJBModuleConfigMap();
                config = ejbMap.get(appId);
                Map<String, WebServiceEndpointConfig> wsecMap = config.getWebServiceEndpointConfigMap();
                wsec = wsecMap.get(pureWebServiceName);
                for (int i = 0; i < registryLocations.length; ++i) {
                    jndiname = registryLocations[i];
                    config.removeProperty(jndiname + "__" + underScoredWebServiceName);
                }
            } else if (type.equals("SERVLET")) {
                Map<String, WebModuleConfig> webMap = dc.getWebModuleConfigMap();
                config = webMap.get(appId);
                Map<String, WebServiceEndpointConfig> wsecMap = config.getWebServiceEndpointConfigMap();
                wsec = wsecMap.get(pureWebServiceName);
                for (int i = 0; i < registryLocations.length; ++i) {
                    jndiname = registryLocations[i];
                    config.removeProperty(jndiname + "__" + underScoredWebServiceName);
                }
            }
        }
        if (wsec != null) {
            for (String jndiName : registryLocations) {
                wsec.removeRegistryLocationConfig(jndiName);
            }
        }
    }

    private String dropAppNameFromWebServiceName(String webServiceName) {
        String[] split = webServiceName.split("#");
        StringBuffer buf = new StringBuffer();
        for (int i = 1; i < split.length; ++i) {
            buf.append(split[i]);
            if (i >= split.length - 1) continue;
            buf.append("#");
        }
        return buf.toString();
    }

    String[] listRegistryLocations() {
        DomainConfig dc = this.getDomainConfig();
        ArrayList<String> jndinames = new ArrayList<String>();
        Map<String, ConnectorConnectionPoolConfig> ccpcMap = dc.getConnectorConnectionPoolConfigMap();
        Map<String, ConnectorResourceConfig> crcMap = dc.getConnectorResourceConfigMap();
        for (String poolName : ccpcMap.keySet()) {
            ConnectorConnectionPoolConfig ccpc = ccpcMap.get(poolName);
            String connectionDefnName = ccpc.getConnectionDefinitionName();
            if (!JAXR_REGISTRY_TYPE.equals(connectionDefnName) && !UDDI_JAXR_REGISTRY_TYPE.equals(connectionDefnName)) continue;
            for (String resourceName : crcMap.keySet()) {
                ConnectorResourceConfig crc = crcMap.get(resourceName);
                if (!poolName.equals(crc.getPoolName())) continue;
                jndinames.add(crc.getJNDIName());
            }
        }
        String[] retValue = new String[jndinames.size()];
        retValue = jndinames.toArray(retValue);
        return retValue;
    }

    public void removeRegistryConnectionResources(String jndiNameOfRegistry) {
        DomainConfig dc = this.getDomainConfig();
        Map<String, ConnectorResourceConfig> crcMap = dc.getConnectorResourceConfigMap();
        ConnectorResourceConfig crc = crcMap.get(jndiNameOfRegistry);
        String poolName = crc != null ? crc.getPoolName() : null;
        dc.removeConnectorResourceConfig(jndiNameOfRegistry);
        if (poolName != null) {
            dc.removeConnectorConnectionPoolConfig(poolName);
        }
    }

    public void addRegistryConnectionResources(String jndiName, String description, String type, Map<String, String> properties) {
        DomainConfig dc = this.getDomainConfig();
        String registryType = null;
        if (type == "uddi") {
            registryType = UDDI_PROPERTY;
        } else if (type == "ebxml") {
            registryType = EBXML_PROPERTY;
        }
        if (registryType == null) {
            Object[] params = new Object[]{UDDI_PROPERTY, EBXML_PROPERTY};
            _logger.log(Level.WARNING, "registry.specify_registry_type", params);
            throw new RuntimeException("Registry Type has to be com.sun.appserv.registry.uddi or com.sun.appserv.registry.ebxml");
        }
        Map<String, ResourceAdapterConfig> raConfMap = dc.getResourceAdapterConfigMap();
        String resourceAdapterName = null;
        for (String ra : raConfMap.keySet()) {
            ResourceAdapterConfig rac = raConfMap.get(ra);
            if (!rac.existsProperty(registryType)) continue;
            resourceAdapterName = rac.getResourceAdapterName();
            break;
        }
        if (resourceAdapterName == null && (resourceAdapterName = this.getSystemConnectorResources(registryType)) == null) {
            String msg = "Cannot locate JAXR Resource Adapter to add Connection pool and Connector Resource. Please add connector resource of type " + registryType;
            _logger.log(Level.SEVERE, "registry.deploy_registry_connector_resource", registryType);
            throw new RuntimeException(msg);
        }
        String poolName = FileUtils.makeFriendlyFileName(jndiName) + POOL_SUFFIX;
        String connectorDefinitionName = JAXR_REGISTRY_TYPE;
        if (registryType.equals(UDDI_PROPERTY)) {
            Properties props = new Properties();
            for (String property : properties.keySet()) {
                String propValue = properties.get(property);
                if (LifeCycleManagerURL.equals(property) || QueryManagerURL.equals(property)) {
                    if (!propValue.endsWith("/")) {
                        propValue = propValue + "/";
                    }
                    props.put(property, propValue);
                    continue;
                }
                if (property.equalsIgnoreCase("username")) {
                    props.put("UserName", propValue);
                    continue;
                }
                if (property.equalsIgnoreCase("password")) {
                    props.put("UserPassword", propValue);
                    continue;
                }
                props.put(property, propValue);
            }
            connectorDefinitionName = UDDI_JAXR_REGISTRY_TYPE;
            this.createConnectorConnectionPoolMBean(resourceAdapterName, connectorDefinitionName, poolName, props);
        } else {
            HashMap<String, String> optional = new HashMap<String, String>();
            for (String property : properties.keySet()) {
                optional.put("property." + property, properties.get(property));
            }
            dc.createConnectorConnectionPoolConfig(poolName, resourceAdapterName, connectorDefinitionName, optional);
        }
        dc.createConnectorResourceConfig(jndiName, poolName, null);
    }

    private void createConnectorConnectionPoolMBean(String resourceAdapterName, String connectorDefinitionName, String poolName, Properties props) {
        try {
            MBeanServer server = MBeanServerFactory.getMBeanServer();
            ObjectName obj = new ObjectName("com.sun.appserv:type=resources,category=config");
            AttributeList attrlist = new AttributeList();
            attrlist.add(new Attribute("name", poolName));
            attrlist.add(new Attribute("resource-adapter-name", resourceAdapterName));
            attrlist.add(new Attribute("connection-definition-name", connectorDefinitionName));
            Object[] params = new Object[]{attrlist, props, "server"};
            String[] signature = new String[]{"javax.management.AttributeList", "java.util.Properties", "java.lang.String"};
            server.invoke(obj, "createConnectorConnectionPool", params, signature);
        }
        catch (Exception e) {
            _logger.log(Level.WARNING, "cannot create connection pool for resource adapter =" + resourceAdapterName, e);
        }
    }

    private String getSystemConnectorResources(String type) {
        String[] systemResources = null;
        MBeanServer server = MBeanServerFactory.getMBeanServer();
        try {
            ObjectName objName = new ObjectName("com.sun.appserv:type=resources,category=config");
            systemResources = (String[])server.invoke(objName, "getSystemConnectorsAllowingPoolCreation", null, null);
            for (int i = 0; i < systemResources.length; ++i) {
                if (ignore_ra.equals(systemResources[i])) continue;
                AttributeList attrList = new AttributeList();
                attrList.add(new Attribute("resource-adapter-name", systemResources[i]));
                if (UDDI_PROPERTY.equals(type)) {
                    attrList.add(new Attribute("connection-definition-name", UDDI_JAXR_REGISTRY_TYPE));
                } else {
                    attrList.add(new Attribute("connection-definition-name", JAXR_REGISTRY_TYPE));
                }
                Object[] params = new Object[]{attrList};
                String[] types = new String[]{"javax.management.AttributeList"};
                Properties properties = (Properties)server.invoke(new ObjectName("com.sun.appserv:type=resources,category=config"), "getMCFConfigProps", params, types);
                Enumeration<?> propertyNames = properties.propertyNames();
                while (propertyNames.hasMoreElements()) {
                    String name = (String)propertyNames.nextElement();
                    if (!(UDDI_PROPERTY.equals(type) ? name.equals(APPSERVER_UDDI) : EBXML_PROPERTY.equals(type) && name.equals(APPSERVER_EBXML))) continue;
                    return systemResources[i];
                }
            }
        }
        catch (Exception e) {
            _logger.log(Level.FINE, "Cannot locate system connector resources");
        }
        return null;
    }

    private DomainConfig getDomainConfig() {
        MBeanServer server = MBeanServerFactory.getMBeanServer();
        DomainRoot domainRoot = ProxyFactory.getInstance(server).getDomainRoot();
        DomainConfig domainConfig = domainRoot.getDomainConfig();
        return domainConfig;
    }

    public String getInstancePort() {
        MBeanServer server = MBeanServerFactory.getMBeanServer();
        String port = null;
        try {
            port = (String)server.getAttribute(new ObjectName(INSTANCE_PORT_MBEAN_NAME), "port");
        }
        catch (MalformedObjectNameException ex) {
            _logger.log(Level.WARNING, "Incorrect Object name to extract port from domain xml", ex);
        }
        catch (MBeanException mbe) {
            _logger.log(Level.WARNING, "MBeanServer returned an exception whilebeing queried for port on http-listener ", mbe);
        }
        catch (AttributeNotFoundException anfe) {
            _logger.log(Level.WARNING, "Cannot find attribute on MBean com.sun.appserv:type=http-listener,id=http-listener-1,config=server-config,category=config", anfe);
        }
        catch (InstanceNotFoundException infe) {
            _logger.log(Level.WARNING, " Cannot find MBean instance com.sun.appserv:type=http-listener,id=http-listener-1,config=server-config,category=config", infe);
        }
        catch (ReflectionException re) {
            _logger.log(Level.WARNING, " Cannot invoke MBean instance com.sun.appserv:type=http-listener,id=http-listener-1,config=server-config,category=config", re);
        }
        return port;
    }

    public String[] listAlreadyPublishedRegistryLocations(String webServiceName, String[] registryLocations) {
        String[] prePublished = null;
        if (this.webServiceInfoMap == null) {
            _logger.fine("ConfigHelper.addToConfig : Incorrect webServiceName ");
            return prePublished;
        }
        DomainConfig dc = this.getDomainConfig();
        String appId = (String)this.webServiceInfoMap.get("AppID");
        Boolean isStandAlone = (Boolean)this.webServiceInfoMap.get("IsAppStandAloneModule");
        String appName = appId;
        String pureWebServiceName = this.dropAppNameFromWebServiceName(webServiceName);
        WebServiceEndpointConfig wsec = null;
        if (!isStandAlone.booleanValue()) {
            Map<String, J2EEApplicationConfig> map = dc.getJ2EEApplicationConfigMap();
            J2EEApplicationConfig appConfig = map.get(appName);
            if (appConfig == null) {
                _logger.log(Level.FINE, "Could not find an application with  name = " + appName);
            } else {
                Map<String, WebServiceEndpointConfig> wsmap = appConfig.getWebServiceEndpointConfigMap();
                wsec = wsmap.get(pureWebServiceName);
            }
        } else {
            Map<String, ModuleConfig> map;
            String type = (String)this.webServiceInfoMap.get("ServiceImplType");
            if (type.equals("EJB")) {
                map = dc.getEJBModuleConfigMap();
                EJBModuleConfig ejbConfig = map.get(appName);
                if (ejbConfig == null) {
                    _logger.log(Level.FINE, "Could not find a ejb module with  name = " + appName);
                } else {
                    Map<String, WebServiceEndpointConfig> ejbmap = ejbConfig.getWebServiceEndpointConfigMap();
                    wsec = ejbmap.get(pureWebServiceName);
                }
            } else if (type.equals("SERVLET")) {
                map = dc.getWebModuleConfigMap();
                WebModuleConfig webConfig = (WebModuleConfig)map.get(appName);
                if (webConfig == null) {
                    _logger.log(Level.FINE, "Could not find a web module with  name = " + appName);
                } else {
                    Map<String, WebServiceEndpointConfig> webmap = webConfig.getWebServiceEndpointConfigMap();
                    wsec = webmap.get(pureWebServiceName);
                }
            }
        }
        if (wsec != null) {
            Map<String, RegistryLocationConfig> regMap = wsec.getRegistryLocationConfigMap();
            prePublished = new String[regMap.size()];
            int i = 0;
            for (String regLoc : regMap.keySet()) {
                RegistryLocationConfig rlc = regMap.get(regLoc);
                prePublished[i++] = new String(rlc.getConnectorResourceJNDIName());
            }
        }
        return prePublished;
    }

    String getOrganizationName(String webServiceName, String registryLocation) {
        String organization = null;
        if (this.webServiceInfoMap == null) {
            _logger.fine("ConfigHelper.addToConfig : Incorrect webServiceName ");
            return null;
        }
        DomainConfig dc = this.getDomainConfig();
        String appId = (String)this.webServiceInfoMap.get("AppID");
        Boolean isStandAlone = (Boolean)this.webServiceInfoMap.get("IsAppStandAloneModule");
        String appName = appId;
        String underScoredWebServiceName = this.convertHashesToUnderScores(webServiceName);
        if (!isStandAlone.booleanValue()) {
            Map<String, J2EEApplicationConfig> map = dc.getJ2EEApplicationConfigMap();
            J2EEApplicationConfig appConfig = map.get(appName);
            if (appConfig == null) {
                _logger.log(Level.FINE, "Could not find an application with  name = " + appName);
            } else {
                organization = appConfig.getPropertyValue(registryLocation + "__" + underScoredWebServiceName);
            }
        } else {
            String type = (String)this.webServiceInfoMap.get("ServiceImplType");
            if (type.equals("EJB")) {
                Map<String, EJBModuleConfig> map = dc.getEJBModuleConfigMap();
                EJBModuleConfig ejbConfig = map.get(appName);
                if (ejbConfig == null) {
                    _logger.log(Level.FINE, "Could not find a ejb module with  name = " + appName);
                } else {
                    organization = ejbConfig.getPropertyValue(registryLocation + "__" + underScoredWebServiceName);
                }
            } else if (type.equals("SERVLET")) {
                Map<String, WebModuleConfig> map = dc.getWebModuleConfigMap();
                WebModuleConfig webConfig = map.get(appName);
                if (webConfig == null) {
                    _logger.log(Level.FINE, "Could not find a web module with  name = " + appName);
                } else {
                    organization = webConfig.getPropertyValue(registryLocation + "__" + underScoredWebServiceName);
                }
            }
        }
        return organization;
    }

    private String convertHashesToUnderScores(String hashed) {
        String returnValue = hashed.replaceAll("#", "__");
        return returnValue;
    }

    public String[] checkForDuplicateRegistries(String[] jndi) {
        if (jndi.length <= 1) {
            return null;
        }
        String[] duplicate = null;
        for (int i = 0; i < jndi.length; ++i) {
            for (int j = i + 1; j < jndi.length; ++j) {
                if (!jndi[i].equals(jndi[j])) continue;
                duplicate = new String[]{jndi[i]};
                _logger.log(Level.SEVERE, "Duplicate Registry Jndi Names. Will not publish the same web service twice to the same registry. Remove one jndi name (" + jndi[i] + ")");
                return duplicate;
            }
        }
        if (duplicate == null) {
            DomainConfig dc = this.getDomainConfig();
            Map<String, ConnectorResourceConfig> crcMap = dc.getConnectorResourceConfigMap();
            for (int i = 0; i < jndi.length; ++i) {
                ConnectorResourceConfig crc = crcMap.get(jndi[i]);
                String pool = crc.getPoolName();
                for (int j = i + 1; j < jndi.length; ++j) {
                    ConnectorResourceConfig crcNew = crcMap.get(jndi[j]);
                    if (!pool.equals(crcNew.getPoolName())) continue;
                    duplicate = new String[]{jndi[i], jndi[j]};
                    _logger.log(Level.SEVERE, "Registry Jndi Names point to the same registry. Will not publish the same web service twice to the same registry. Remove one duplicate of  (" + jndi[i] + ")" + " or (" + jndi[j] + ")");
                    return duplicate;
                }
            }
        }
        return null;
    }
}

