/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.backup;

import com.sun.enterprise.config.backup.BackupException;
import com.sun.enterprise.config.backup.BackupFilenameManager;
import com.sun.enterprise.config.backup.BackupRequest;
import com.sun.enterprise.config.backup.BackupRestoreManager;
import com.sun.enterprise.config.backup.Status;
import com.sun.enterprise.config.backup.StringHelper;
import com.sun.enterprise.config.backup.ZipStorage;
import com.sun.enterprise.config.backup.util.FileUtils;
import java.io.File;

public class BackupManager
extends BackupRestoreManager {
    Status status;

    public BackupManager(BackupRequest req) throws BackupException {
        super(req);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String backup() throws BackupException {
        String mesg = StringHelper.get("backup-res.SuccessfulBackup");
        String statusString = this.writeStatus();
        if (!this.request.terse) {
            mesg = mesg + "\n\n" + statusString;
        }
        try {
            ZipStorage zs = new ZipStorage(this.request);
            zs.store();
            String string = mesg;
            return string;
        }
        finally {
            this.status.delete();
            FileUtils.protect(this.request.backupFile);
        }
    }

    void init() throws BackupException {
        super.init();
        if (this.request.backupFile != null) {
            throw new BackupException("backup-res.InternalError", "No backupFilename may be specified for a backup -- it is reserved for restore operations only.");
        }
        if (!FileUtils.safeIsDirectory(this.request.domainDir)) {
            throw new BackupException("backup-res.NoDomainDir", this.request.domainDir);
        }
        File backupDir = new File(this.request.domainDir, "backups");
        backupDir.mkdirs();
        if (!FileUtils.safeIsDirectory(backupDir)) {
            throw new BackupException("backup-res.NoBackupDirCantCreate", backupDir);
        }
        String ts = "" + this.request.timestamp + ".zip";
        BackupFilenameManager bfmgr = new BackupFilenameManager(backupDir);
        this.request.backupFile = bfmgr.next();
    }

    private String writeStatus() {
        this.status = new Status();
        return this.status.write(this.request);
    }
}

