/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans.validation;

import java.io.InputStream;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;

class Schematron {
    private Transformer transformer;

    Schematron(String schemaName) throws TransformerConfigurationException {
        this.transformer = this.getTransformer(schemaName);
    }

    void analyze(Source src, Result result) throws TransformerException {
        this.transformer.transform(src, result);
    }

    private Transformer getTransformer(String schema) throws TransformerConfigurationException {
        InputStream is = this.getClass().getResourceAsStream(schema);
        if (null == is) {
            throw new TransformerConfigurationException("Couldn't construct a transformer to perform validation because I couldn't find the resource named \"" + schema + "\" from " + this.getClass().getName());
        }
        TransformerFactory f = TransformerFactory.newInstance();
        Transformer t = f.newTransformer(new StreamSource(is));
        return t;
    }
}

