/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans.validation.tests;

import com.sun.enterprise.config.ConfigContextEvent;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.ConnectorConnectionPool;
import com.sun.enterprise.config.serverbeans.validation.GenericValidator;
import com.sun.enterprise.config.serverbeans.validation.Result;
import com.sun.enterprise.config.serverbeans.validation.ValidationDescriptor;
import com.sun.enterprise.connectors.ConnectorRuntime;
import java.util.logging.Level;

public class ConnectorConnectionPoolTest
extends GenericValidator {
    int maxPoolSize = 0;

    public ConnectorConnectionPoolTest(ValidationDescriptor desc) {
        super(desc);
    }

    public Result validate(ConfigContextEvent cce) {
        Result result = super.validate(cce);
        String choice = cce.getChoice();
        if (choice.equals("UPDATE")) {
            this.validateAttribute(cce.getName(), (String)cce.getObject(), result);
        }
        return result;
    }

    public void validateAttribute(String name, String value, Result result) {
        if (value == null || value.equals("")) {
            return;
        }
        if (name.equals("connection-definition-name")) {
            // empty if block
        }
    }

    public void validateAttribute(String name, String value, String rarName, Result result) {
        try {
            String[] connDefnNames = ConnectorRuntime.getRuntime().getConnectionDefinitionNames(rarName);
            boolean available = false;
            for (int i = 0; i < connDefnNames.length; ++i) {
                if (!value.equals(connDefnNames[i])) continue;
                available = true;
                break;
            }
            if (!available) {
                result.failed(this.smh.getLocalString(this.getClass().getName() + ".connDefnNotAvl", "Attribute(conndefn={0}) : Invalid Connection Definition Name", new Object[]{value}));
            }
        }
        catch (Exception e) {
            _logger.log(Level.FINE, "domainxmlverifier.exception", e);
        }
    }

    private final ConnectorConnectionPool getConnectorConnectionPool(ConfigContextEvent cce) throws ConfigException {
        return (ConnectorConnectionPool)cce.getValidationTarget();
    }
}

