/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans.validation.tests;

import com.sun.enterprise.config.ConfigContextEvent;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.JmsHost;
import com.sun.enterprise.config.serverbeans.JmsService;
import com.sun.enterprise.config.serverbeans.validation.GenericValidator;
import com.sun.enterprise.config.serverbeans.validation.Result;
import com.sun.enterprise.config.serverbeans.validation.ValidationDescriptor;
import java.util.logging.Level;

public class JmsHostTest
extends GenericValidator {
    private static final char[] illegalChars = new char[]{'*', ',', ':'};

    public JmsHostTest(ValidationDescriptor desc) {
        super(desc);
    }

    public Result validate(ConfigContextEvent cce) {
        Result result = super.validate(cce);
        try {
            if (cce.getChoice().equals("DELETE")) {
                if (this.isReferencedByParent(cce)) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".cannotDeleteReferencedJmsHost", "Jms host (name={0}) can not be removed. It is referenced by its parent jms-service", new Object[]{this.getJmsHost(cce).getName()}));
                }
            } else if (cce.getName().equals("admin-user-name")) {
                this.validateAdminUserName((String)cce.getObject(), result);
            } else if (cce.getName().equals("admin-password")) {
                this.validateAdminUserPassword((String)cce.getObject(), result);
            }
        }
        catch (Exception e) {
            _logger.log(Level.FINE, "domainxmlverifier.exception", e);
        }
        return result;
    }

    private final boolean isReferencedByParent(ConfigContextEvent cce) throws ConfigException {
        JmsHost host = this.getJmsHost(cce);
        JmsService parent = (JmsService)host.parent();
        return parent.getDefaultJmsHost() != null && parent.getDefaultJmsHost().equals(host.getName());
    }

    private void validateAdminUserName(String name, Result result) {
        if (name == null || name.equals("") || name.length() < 1) {
            result.failed(this.smh.getLocalString(this.getClass().getName() + ".blankOrNullString", "Attribute {0} : cannot be null or blank", new Object[]{"admin-user-name"}));
            return;
        }
        if (this.hasIllegalChar(name.toCharArray(), illegalChars)) {
            result.failed(this.smh.getLocalString(this.getClass().getName() + ".stringHasIllegalChars", "Attribute {0} cannot have any of illegal characters {1}", new Object[]{"admin-user-name", new String(illegalChars)}));
        }
    }

    private void validateAdminUserPassword(String name, Result result) {
        if (name == null || name.equals("") || name.length() < 1) {
            result.failed(this.smh.getLocalString(this.getClass().getName() + ".blankOrNullString", "Attribute {0} : cannot be null or blank", new Object[]{"admin-password"}));
            return;
        }
        if (this.hasIllegalChar(name.toCharArray(), illegalChars)) {
            result.failed(this.smh.getLocalString(this.getClass().getName() + ".stringHasIllegalChars", "Attribute {0} cannot have any of illegal characters {1}", new Object[]{"admin-password", new String(illegalChars)}));
        }
    }

    private boolean hasIllegalChar(char[] inputCharArr, char[] illegalCharArr) {
        int inputCharArrLen = inputCharArr.length;
        int illegalCharArrLen = illegalCharArr.length;
        for (int i = 0; i < illegalCharArrLen; ++i) {
            for (int j = 0; j < inputCharArrLen; ++j) {
                if (inputCharArr[j] != illegalCharArr[i]) continue;
                return true;
            }
        }
        return false;
    }

    private final JmsHost getJmsHost(ConfigContextEvent cce) throws ConfigException {
        return (JmsHost)cce.getValidationTarget();
    }
}

