/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.support;

import com.sun.enterprise.management.support.OldTypeToJ2EETypeMapper;
import java.util.HashMap;
import java.util.Map;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class OldTypesBase
implements OldTypeToJ2EETypeMapper {
    final Map<String, String> mOldTypeToJ2EETypeMap = new HashMap<String, String>();
    final Map<String, String> mJ2EETypeToOldTypeMap = new HashMap<String, String>();
    public static final String OLD_TYPE_PROP = "type";

    OldTypesBase() {
        this.initMap();
    }

    void add(String j2eeType, String oldType) {
        this.mOldTypeToJ2EETypeMap.put(oldType, j2eeType);
        this.mJ2EETypeToOldTypeMap.put(j2eeType, oldType);
    }

    abstract void initMap();

    @Override
    public String oldTypeToJ2EEType(String oldType, ObjectName oldObjectName) {
        String j2eeType = null;
        j2eeType = oldType.equals(oldObjectName.getKeyProperty(OLD_TYPE_PROP)) ? this.oldObjectNameToJ2EEType(oldObjectName) : this.mOldTypeToJ2EETypeMap.get(oldType);
        return j2eeType;
    }

    @Override
    public String oldObjectNameToJ2EEType(ObjectName oldObjectName) {
        String oldType = oldObjectName.getKeyProperty(OLD_TYPE_PROP);
        if (oldType == null) {
            System.err.println("no j2eeType for: " + oldObjectName);
            throw new IllegalArgumentException(oldObjectName.toString());
        }
        String j2eeType = null;
        j2eeType = this.mOldTypeToJ2EETypeMap.get(oldType);
        if (j2eeType == null) {
            throw new IllegalArgumentException(oldType);
        }
        assert (j2eeType != null);
        return j2eeType;
    }

    public String oldTypeToJ2EEType(ObjectName objectName) {
        return this.oldTypeToJ2EEType(objectName.getKeyProperty(OLD_TYPE_PROP));
    }

    public String oldTypeToJ2EEType(String oldType) {
        return this.mOldTypeToJ2EETypeMap.get(oldType);
    }

    @Override
    public String j2eeTypeToOldType(String j2eeType) {
        return this.mJ2EETypeToOldTypeMap.get(j2eeType);
    }

    public Map<String, String> oldPropsToNewProps(Map<String, String> oldProps) {
        HashMap<String, String> newProps = new HashMap<String, String>();
        for (String oldProp : oldProps.keySet()) {
            String newProp = this.mOldTypeToJ2EETypeMap.get(oldProp);
            if (newProp == null) continue;
            newProps.put(newProp, oldProps.get(oldProp));
        }
        return newProps;
    }
}

