/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.cli.commands;

import com.sun.enterprise.admin.pluggable.ClientPluggableFeatureFactory;
import com.sun.enterprise.admin.pluggable.ClientPluggableFeatureFactoryImpl;
import com.sun.enterprise.admin.servermgmt.DomainConfig;
import com.sun.enterprise.admin.servermgmt.DomainsManager;
import com.sun.enterprise.admin.servermgmt.RepositoryConfig;
import com.sun.enterprise.admin.servermgmt.RepositoryManager;
import com.sun.enterprise.cli.commands.S1ASCommand;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.enterprise.cli.framework.InputsAndOutputs;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class BaseLifeCycleCommand
extends S1ASCommand {
    private static final String DEFAULT_FEATURES_PROPERTY_CLASS = "com.sun.enterprise.admin.pluggable.PEClientPluggableFeatureImpl";
    protected ClientPluggableFeatureFactory _featureFactory = this.createPluggableFeatureFactory();
    protected static final String DOMAIN = "domain";
    protected static final String DOMAINDIR = "domaindir";
    protected static final String MASTER_PASSWORD = "masterpassword";
    protected static final String NEW_MASTER_PASSWORD = "newmasterpassword";
    protected static final String ADMIN_USER = "adminuser";
    protected static final String ADMIN_PASSWORD = "adminpassword";
    protected static final String PASSWORD = "password";
    protected static final String DEFAULT_MASTER_PASSWORD = "changeit";
    protected static final String ADMIN_PORT = "adminport";
    protected static final String SAVE_MASTER_PASSWORD = "savemasterpassword";
    protected static final char ESCAPE_CHAR = '\\';
    protected static final char EQUAL_SIGN = '=';
    protected static final String DELIMITER = ":";
    protected static final String KILL = "kill";

    protected Logger getLogger() {
        return LogDomains.getLogger((String)"javax.enterprise.system.core");
    }

    protected ClientPluggableFeatureFactory getFeatureFactory() {
        return this._featureFactory;
    }

    private ClientPluggableFeatureFactory createPluggableFeatureFactory() {
        String featurePropClass = System.getProperty("com.sun.appserv.admin.pluggable.features", DEFAULT_FEATURES_PROPERTY_CLASS);
        this.getLogger().log(Level.FINER, "featurePropClass: " + featurePropClass);
        ClientPluggableFeatureFactoryImpl featureFactoryImpl = new ClientPluggableFeatureFactoryImpl(this.getLogger());
        ClientPluggableFeatureFactory featureFactory = (ClientPluggableFeatureFactory)featureFactoryImpl.getInstance(featurePropClass);
        if (featureFactory == null) {
            this.getLogger().log(Level.WARNING, "j2eerunner.pluggable_feature_noinit", featurePropClass);
        }
        return featureFactory;
    }

    protected DomainConfig getDomainConfig(String domainName) throws CommandException {
        try {
            DomainConfig dc = new DomainConfig(domainName, this.getDomainsRoot());
            if (this.getBooleanOption("verbose")) {
                dc.put((Object)"domain.verbose", (Object)Boolean.TRUE);
            }
            if (this.getBooleanOption("debug")) {
                dc.put((Object)"domain.debug", (Object)Boolean.TRUE);
            }
            return dc;
        }
        catch (Exception e) {
            throw new CommandException(e);
        }
    }

    protected Boolean getSaveMasterPassword(String masterPassword) {
        Boolean saveMasterPassword = this.getBooleanOption(SAVE_MASTER_PASSWORD);
        if (masterPassword != null && masterPassword.equals(DEFAULT_MASTER_PASSWORD)) {
            saveMasterPassword = Boolean.TRUE;
        }
        return saveMasterPassword;
    }

    protected String getDomainsRoot() throws CommandException {
        String domainDir = this.getOption(DOMAINDIR);
        if (domainDir == null) {
            domainDir = System.getProperty("com.sun.aas.domainsRoot");
        }
        if (domainDir == null) {
            throw new CommandException(this.getLocalizedString("InvalidDomainPath", new String[]{domainDir}));
        }
        return domainDir;
    }

    protected String getDomainName() throws CommandException {
        String domainName = null;
        if (this.operands.isEmpty()) {
            if (this.getOption(DOMAIN) != null) {
                domainName = this.getOption(DOMAIN);
            } else {
                String[] domains = this.getDomains();
                if (domains.length == 0) {
                    throw new CommandException(this.getLocalizedString("NoDomains", new Object[]{this.getDomainsRoot()}));
                }
                if (domains.length > 1) {
                    throw new CommandException(this.getLocalizedString("NoDefaultDomain", new Object[]{this.getDomainsRoot()}));
                }
                domainName = domains[0];
            }
        } else {
            domainName = (String)this.operands.firstElement();
        }
        CLILogger.getInstance().printDebugMessage("domainName = " + domainName);
        return domainName;
    }

    protected String getAdminUser() throws CommandValidationException {
        String adminUserVal = this.getOption("user");
        if (adminUserVal != null) {
            return adminUserVal;
        }
        adminUserVal = this.getValuesFromASADMINPREFS("user");
        if (adminUserVal != null) {
            return adminUserVal;
        }
        adminUserVal = this.getValuesFromASADMINPREFS(ADMIN_USER);
        if (adminUserVal != null) {
            return adminUserVal;
        }
        if (this.getBooleanOption("interactive")) {
            try {
                InputsAndOutputs.getInstance().getUserOutput().print(this.getLocalizedString("AdminUserPrompt"));
                return InputsAndOutputs.getInstance().getUserInput().getLine();
            }
            catch (IOException ioe) {
                throw new CommandValidationException(this.getLocalizedString("CannotReadOption", new Object[]{"ADMIN_USER"}));
            }
        }
        throw new CommandValidationException(this.getLocalizedString("OptionIsRequired", new Object[]{ADMIN_USER}));
    }

    protected String getMasterPassword(boolean confirmAndValidate) throws CommandValidationException, CommandException {
        return this.getMasterPassword(confirmAndValidate, false);
    }

    protected String getMasterPassword(boolean confirmAndValidate, boolean alwaysPrompt) throws CommandValidationException, CommandException {
        String adminPassword = this.getPassword(ADMIN_PASSWORD, true, false, false, false, null, null, false, false, false, false);
        if (adminPassword != null && !alwaysPrompt) {
            String masterPassword = this.getPassword(MASTER_PASSWORD, false, false, false, false, null, null, false, false, confirmAndValidate, false);
            if (masterPassword == null) {
                return DEFAULT_MASTER_PASSWORD;
            }
            return masterPassword;
        }
        return this.getPassword(MASTER_PASSWORD, "MasterPasswordPrompt", "MasterPasswordConfirmationPrompt", false, false, false, false, null, null, true, confirmAndValidate, confirmAndValidate, false);
    }

    protected String getMasterPassword(RepositoryManager mgr, RepositoryConfig config) throws CommandValidationException, CommandException {
        return this.getPassword(MASTER_PASSWORD, "MasterPasswordPrompt", null, false, false, false, true, mgr, config, true, false, false, false);
    }

    protected String getNewMasterPassword() throws CommandValidationException, CommandException {
        return this.getPassword(NEW_MASTER_PASSWORD, "NewMasterPasswordPrompt", "NewMasterPasswordConfirmationPrompt", false, false, false, false, null, null, true, true, true, false);
    }

    protected HashMap getExtraPasswords(String[] optionNames) throws CommandValidationException, CommandException {
        HashMap<String, String> result = new HashMap<String, String>();
        for (int i = 0; i < optionNames.length; ++i) {
            String optionName = optionNames[i];
            this.NOT_DEPRECATED_PASSWORDFILE_OPTIONS = this.NOT_DEPRECATED_PASSWORDFILE_OPTIONS + "|" + optionName;
            String password = this.getPassword(optionName, "ExtraPasswordPrompt", null, false, false, false, false, null, null, true, false, false, false);
            result.put(optionName, password);
        }
        return result;
    }

    protected String[] getDomains() throws CommandException {
        try {
            DomainsManager mgr = this.getFeatureFactory().getDomainsManager();
            return mgr.listDomains(this.getDomainConfig(null));
        }
        catch (Exception e) {
            throw new CommandException(e.getLocalizedMessage());
        }
    }

    protected boolean isWindows() {
        String osname = System.getProperty("os.name").toLowerCase();
        CLILogger.getInstance().printDebugMessage("osname = " + osname);
        return osname.indexOf("windows") != -1;
    }

    protected boolean isSpaceInPath(String path) {
        return path.indexOf(32) != -1;
    }
}

