/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.cli.commands;

import com.sun.appserv.management.client.prefs.LoginInfo;
import com.sun.appserv.management.client.prefs.LoginInfoStore;
import com.sun.appserv.management.client.prefs.LoginInfoStoreFactory;
import com.sun.enterprise.cli.commands.S1ASCommand;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

public class ChangeAdminPasswordCommand
extends S1ASCommand {
    private static final String ADMIN_PASSWORD = "adminpassword";
    private static final String PASSWORD = "password";
    private static final String INTERACTIVE = "interactive";
    private static final String OLD_ADMIN_PASSWORD = "oldadminpassword";
    private static final String NEW_ADMIN_PASSWORD = "newadminpassword";
    private String newPassword;
    private String oldPassword;

    private String getOldAdminPassword() throws CommandValidationException, CommandException {
        return this.getPassword(OLD_ADMIN_PASSWORD, "OldAdminPasswordPrompt", null, false, false, false, false, null, null, true, false, true, false);
    }

    private String getNewAdminPassword() throws CommandValidationException, CommandException {
        return this.getPassword(NEW_ADMIN_PASSWORD, "NewAdminPasswordPrompt", "NewAdminPasswordConfirmationPrompt", false, false, false, false, null, null, true, true, true, false);
    }

    public boolean validateOptions() throws CommandValidationException {
        super.validateOptions();
        try {
            this.setOption(INTERACTIVE, "true");
            String sUser = this.getUser();
            this.setOption("user", sUser);
            this.oldPassword = this.getOldAdminPassword();
            this.setOption(PASSWORD, this.oldPassword);
            this.newPassword = this.getNewAdminPassword();
            this.setOption(ADMIN_PASSWORD, this.newPassword);
        }
        catch (CommandException ce) {
            throw new CommandValidationException(ce.getLocalizedMessage());
        }
        return true;
    }

    public void runCommand() throws CommandException, CommandValidationException {
        if (!this.validateOptions()) {
            throw new CommandValidationException("Validation is false");
        }
        String host = this.getHost();
        int port = this.getPort();
        String userName = this.getUser();
        MBeanServerConnection mbsc = this.getMBeanServerConnection(host, port, userName, this.oldPassword);
        String objectName = this.getObjectName();
        Object[] params = this.getParamsInfo();
        String operationName = this.getOperationName();
        String[] types = this.getTypesInfo();
        try {
            Object returnValue = mbsc.invoke(new ObjectName(objectName), operationName, params, types);
            this.handleReturnValue(returnValue);
            this.updateLoginFile(userName, host, port);
            CLILogger.getInstance().printDetailMessage(this.getLocalizedString("CommandSuccessful", new Object[]{this.name}));
        }
        catch (Exception e) {
            this.displayExceptionMessage(e);
        }
    }

    private void updateLoginFile(String user, String host, int port) {
        try {
            LoginInfoStore store = LoginInfoStoreFactory.getStore(null);
            if (store.exists(host, port)) {
                store.store(new LoginInfo(host, port, user, this.newPassword), true);
                CLILogger.getInstance().printDetailMessage(this.getLocalizedString("SuccessfullyUpdatedLoginInfo"));
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }
}

