/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.cli.commands;

import com.sun.enterprise.cli.commands.GenericCommand;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

public class CreateManagementRuleCommand
extends GenericCommand {
    private static final String RULE_DESCRIPTION_OPTION = "ruledescription";
    private static final String RULE_ENABLED_OPTION = "ruleenabled";
    private static final String EVENT_TYPE_OPTION = "eventtype";
    private static final String EVENT_LEVEL_OPTION = "eventlevel";
    private static final String EVENT_DESCRIPTION_OPTION = "eventdescription";
    private static final String EVENT_PROPERTIES_OPTION = "eventproperties";
    private static final String RECORD_EVENT_OPTION = "recordevent";
    private static final String ACTION_OPTION = "recordevent";
    private static final String TARGET_OPTION = "target";

    public void runCommand() throws CommandException, CommandValidationException {
        this.validateOptions();
        MBeanServerConnection mbsc = this.getMBeanServerConnection(this.getHost(), this.getPort(), this.getUser(), this.getPassword());
        String config = this.resolveTargetToConfig(mbsc, this.getOption(TARGET_OPTION));
        String objectName = "com.sun.appserv:type=management-rules,config=" + config + ",category=config";
        CLILogger.getInstance().printDebugMessage("ObjectName = " + objectName);
        Object[] params = this.getParamsInfo();
        String operationName = this.getOperationName();
        String[] types = this.getTypesInfo();
        try {
            if (params[0] != null) {
                Object returnValue = mbsc.invoke(new ObjectName(objectName), operationName, params, types);
                this.handleReturnValue(returnValue);
            }
            CLILogger.getInstance().printDetailMessage(this.getLocalizedString("CommandSuccessful", new Object[]{this.name}));
        }
        catch (Exception e) {
            this.displayExceptionMessage(e);
        }
    }

    private String resolveTargetToConfig(MBeanServerConnection mbsc, String target) throws CommandException {
        String objectName = "com.sun.appserv:type=configs,category=config";
        Object[] params = new Object[]{target};
        String operationName = "getConfigNameForTarget";
        String[] types = new String[]{"java.lang.String"};
        try {
            String returnValue = (String)mbsc.invoke(new ObjectName(objectName), "getConfigNameForTarget", params, types);
            return returnValue;
        }
        catch (Exception e) {
            throw new CommandException(e.getLocalizedMessage());
        }
    }
}

