/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.cli.commands;

import com.sun.enterprise.cli.commands.BaseLoggingCommand;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

public class DisplayErrorDistributionCommand
extends BaseLoggingCommand {
    private static final String TARGET_OPTION = "target";

    public void runCommand() throws CommandException, CommandValidationException {
        if (!this.validateOptions()) {
            throw new CommandValidationException("Validation is false");
        }
        MBeanServerConnection mbsc = this.getMBeanServerConnection(this.getHost(), this.getPort(), this.getUser(), this.getPassword());
        String instanceName = this.getOption(TARGET_OPTION);
        this.verifyTargetInstance(mbsc, instanceName);
        String objectName = this.getObjectName();
        String operationName = this.getOperationName();
        long timeStamp = Long.valueOf((String)this.getOperands().get(0));
        try {
            Object[] params = new Object[]{timeStamp, "SEVERE"};
            String[] types = this.getTypesInfo();
            Map returnMap = (Map)mbsc.invoke(new ObjectName(objectName), operationName, params, types);
            Map errorsMap = this.handleErrorDistribution(returnMap, new HashMap(), true);
            params = new Object[]{timeStamp, "WARNING"};
            returnMap = (Map)mbsc.invoke(new ObjectName(objectName), operationName, params, types);
            errorsMap = this.handleErrorDistribution(returnMap, errorsMap, false);
            this.displayErrorDistribution(errorsMap);
        }
        catch (Exception e) {
            this.displayExceptionMessage(e);
        }
        CLILogger.getInstance().printDetailMessage(this.getLocalizedString("CommandSuccessful", new Object[]{this.name}));
    }

    private Map handleErrorDistribution(Map errorMap, Map resultMap, boolean isSevere) {
        Set keySet = errorMap.keySet();
        for (String module : keySet) {
            int[] errorCounts;
            Integer count = (Integer)errorMap.get(module);
            if (count <= 0) continue;
            if (isSevere) {
                errorCounts = new int[]{count, 0};
                resultMap.put(module, errorCounts);
                continue;
            }
            if (resultMap.containsKey(module)) {
                errorCounts = (int[])resultMap.get(module);
                errorCounts[1] = count;
                resultMap.put(module, errorCounts);
                continue;
            }
            errorCounts = new int[]{0, count};
            resultMap.put(module, errorCounts);
        }
        return resultMap;
    }

    private void displayErrorDistribution(Map errorsMap) {
        if (errorsMap.size() <= 0) {
            CLILogger.getInstance().printMessage(this.getLocalizedString("NoElementsToList"));
            return;
        }
        String sTitle = String.format("%1$-9s %2$-14s %3$-40s", this.getLocalizedString("Severity"), this.getLocalizedString("Warning"), this.getLocalizedString("ModuleID"));
        CLILogger.getInstance().printDetailMessage(sTitle);
        CLILogger.getInstance().printDetailMessage("---------------------------------------------------------");
        Set keySet = errorsMap.keySet();
        for (String module : keySet) {
            int[] errorCounts = (int[])errorsMap.get(module);
            String sErrorRecord = String.format("    %1$-8s %2$-8s %3$-40s", errorCounts[0], errorCounts[1], module);
            CLILogger.getInstance().printMessage(sErrorRecord);
        }
    }
}

