/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.cli.commands;

import com.sun.enterprise.cli.commands.S1ASCommand;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.enterprise.cli.framework.InputsAndOutputs;
import java.io.IOException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

public class FileUserCommand
extends S1ASCommand {
    private static final String USER_PASSWORD = "userpassword";
    private static final String FILE_USER_NAME = "fileuser";

    protected String getPasswordOptionName() {
        return USER_PASSWORD;
    }

    protected String getPasswordPrompt() {
        return "FileUserPasswordPrompt";
    }

    protected String getPasswordConfirmationPrompt() {
        return "FileUserPasswordConfirmationPrompt";
    }

    protected boolean confirmPassword() {
        return true;
    }

    protected String getUserOptionName() {
        return FILE_USER_NAME;
    }

    protected String getUserPrompt() {
        return "FileUserPrompt";
    }

    protected String getPasswordOption() throws CommandValidationException, CommandException {
        return this.getPassword(this.getPasswordOptionName(), this.getPasswordPrompt(), this.getPasswordConfirmationPrompt(), true, false, false, false, null, null, true, this.confirmPassword(), false, true);
    }

    private String getUserName() throws CommandValidationException {
        String userName;
        if (this.getOperands() != null && this.getOperands().size() != 0) {
            userName = (String)this.getOperands().get(0);
        } else {
            try {
                InputsAndOutputs.getInstance().getUserOutput().print(this.getLocalizedString(this.getUserPrompt()));
                userName = InputsAndOutputs.getInstance().getUserInput().getLine();
            }
            catch (IOException ioe) {
                throw new CommandValidationException(this.getLocalizedString("CannotReadOption", new Object[]{this.getUserOptionName()}));
            }
        }
        return userName;
    }

    public boolean validateOptions() throws CommandValidationException {
        return super.validateOptions();
    }

    public void runCommand() throws CommandException, CommandValidationException {
        this.validateOptions();
        MBeanServerConnection mbsc = this.getMBeanServerConnection(this.getHost(), this.getPort(), this.getUser(), this.getPassword());
        String objectName = this.getObjectName();
        Object[] params = this.getParamsInfo();
        String operationName = this.getOperationName();
        String[] types = this.getTypesInfo();
        params[0] = this.getUserName();
        params[1] = this.getPasswordOption();
        try {
            Object returnValue = mbsc.invoke(new ObjectName(objectName), operationName, params, types);
            this.handleReturnValue(returnValue);
            CLILogger.getInstance().printDetailMessage(this.getLocalizedString("CommandSuccessful", new Object[]{this.name}));
        }
        catch (Exception e) {
            this.displayExceptionMessage(e);
        }
    }
}

